@echo off

REM Cygwin configuration
set MAKE_MODE=UNIX

REM *********************************************
REM Tecmake Configuration

REM Change the following lines to match your system installation
REM Use always  "/" is paths, except for TECMAKE_PATH

REM Do NOT use long file names with spaces here.
REM Use the tool "shortpath" to display the
REM   short name version of the current folder
REM   or pass the folder as the first parameter.
REM OR create a link to the folder using a name without spaces.
REM OR create a copy of the folder using a name without spaces.
REM *********************************************


REM Used only in some scripts on Tecmake for Windows.
REM Not used inside the Makefile.
REM Must use Windows standard PATH separators "\".
set TECMAKE_PATH=c:\tecgraf\tecmake
REM set TECMAKE_PATH=t:\lib\tecmake

REM Used only for RCS, can be ignored in Windows.
REM THis is the only place where a cygdrive path is used.
set TECMAKE_HOME=/cygdrive/c/tecgraf/tecmake
REM set TECMAKE_HOME=/cygdrive/t/lib/tecmake

REM This must be the GNU make
set TECMAKE_MAKE=make

REM Change the paths you need to match your installation:
rem set VC6=c:/app/lng/vc6
rem set VC7=c:/progra~1/micros~1.net/vc7
rem set VC8=c:/progra~1/mid05a~1/vc
rem set VC9=c:/progra~2/micros~1.0/vc
rem set VC10=c:/progra~2/micros~1.0/vc
rem set VC11=c:/progra~2/micros~1.0/vc

REM If you have problems with Visual C++ make sure that 
REM "C:\Program Files (x86)\Microsoft Visual Studio 9.0\Common7\IDE"
REM is in your PATH.

REM Leave this commented out to use the SDK installed with the compiler.
rem set PLATSDK=c:/progra~1/mifd68~1

REM By default for vc9/vc10 we will use the SDK
REM   from the folder $(VC9)/WinSDK or $(VC10)/WinSDK
REM   VC9/VC10 installs the Windows SDK in a separate directory,
REM   usually is similar to "C:\Program Files\Microsoft SDKs\Windows\v6.0A".
REM   VC11 is at "C:\Program Files (x86)\Windows Kits\8.0"
rem set VC9SDK=c:/progra~1/micros~3/windows/v6.0a
rem set VC10SDK=c:/progra~1/micros~3/windows/v7.1
rem set VC11SDK=c:/progra~1/micros~1/window~1/8.0
REM If PLATSDK is defined then VC*SDK are not used.

rem set OWC1=c:/app/lng/owc1
rem set BC55=c:/app/lng/bcc55
rem set BC56=c:/app/lng/CBuilderX
rem set MINGW3=c:/app/lng/mingw3
rem set MINGW4=c:/app/lng/mingw4
rem set MINGW4_64=c:/app/lng/mingw4_64
rem set GCC3=c:/cygwin15
rem set GCC4=c:/cygwin17

rem set GLUT=c:/app/lng/glut
rem set GTK=c:/app/lng/gtk
rem set GTK3=c:/app/lng/gtk3

REM Uncomment the variables you need
rem set TECTOOLS_HOME=c:/tecgraf
rem set CD=%TECTOOLS_HOME%/cd
rem set IM=%TECTOOLS_HOME%/im
rem set IUP=%TECTOOLS_HOME%/iup
rem set LUA=%TECTOOLS_HOME%/lua
rem set LUA5=%TECTOOLS_HOME%/lua5
rem set LUA50=%TECTOOLS_HOME%/lua50
rem set LUA51=%TECTOOLS_HOME%/lua5.1
rem set CDDIR=%CD%/etc
                   
REM Must edit or set this for your Windows system
rem set TEC_SYSVERSION=5
rem set TEC_SYSMINOR=1
rem set TEC_SYSRELEASE=%TEC_SYSVERSION%.%TEC_SYSMINOR%
REM TEC_SYSRELEASE will be defined as a variable when compiling code only for gcc

REM Define this if compiling for 64-bits in a 32bits environment
if %PROCESSOR_ARCHITECTURE%==x86 set USE_X86_CL64=Yes

REM *********************************************

if "%1"==""            goto default
if "%1"=="all"         goto all
if "%1"=="all-dll"     goto all-dll
if "%1"=="gcc3"        goto make
if "%1"=="gcc4"        goto make
if "%1"=="gcc4_64"     goto make
if "%1"=="mingw3"      goto make
if "%1"=="mingw4"      goto make
if "%1"=="mingw4_64"   goto make
if "%1"=="cygw15"      goto make
if "%1"=="cygw17"      goto make
if "%1"=="cygw17_64"   goto make
if "%1"=="vc7"         goto make
if "%1"=="vc6"         goto make
if "%1"=="vc8"         goto make
if "%1"=="vc8_64"      goto make
if "%1"=="vc9"         goto make
if "%1"=="vc9_64"      goto make
if "%1"=="vc10"        goto make
if "%1"=="vc10_64"     goto make
if "%1"=="vc11"        goto make
if "%1"=="vc11_64"     goto make
if "%1"=="owc1"        goto make
if "%1"=="bc55"        goto make
if "%1"=="bc56"        goto make
if "%1"=="dll"         goto make
if "%1"=="dll7"        goto make
if "%1"=="dll8"        goto make
if "%1"=="dll8_64"     goto make
if "%1"=="dll9"        goto make
if "%1"=="dll9_64"     goto make
if "%1"=="dll10"       goto make
if "%1"=="dll10_64"    goto make
if "%1"=="dll11"       goto make
if "%1"=="dll11_64"    goto make
if "%1"=="dllw4"       goto make
if "%1"=="dllg4"       goto make
if "%1"=="dllw4_64"    goto make
if "%1"=="dllg4_64"    goto make
goto error

:all
FOR %%u IN (vc11_64 vc11 vc10_64 vc10 vc9_64 vc9 vc8_64 vc8 vc7 vc6 owc1 bc6 gcc4 mingw4) DO call %TECMAKE_PATH%\tecmakewin.bat %%u %2 %3 %4 %5 %6 %7 %8 %9
goto end

:all-dll
FOR %%u IN (vc11_64 vc11 vc10_64 vc10 vc9_64 vc9 vc8_64 vc8 vc7 vc6 owc1 bc6 gcc4 mingw4 dll dll7 dll8 dll8_64 dll9 dll9_64 dll10 dll10_64 dll11 dll11_64) DO call %TECMAKE_PATH%\tecmakewin.bat %%u %2 %3 %4 %5 %6 %7 %8 %9
goto end

:make
call %TECMAKE_PATH%\tecmakewin.bat %1 %2 %3 %4 %5 %6 %7 %8 %9
goto end

:default
call %TECMAKE_PATH%\tecmakewin.bat vc9
goto end

:error
echo Invalid parameter.

:end
