#ifndef GLPANEL_H
#define GLPANEL_H

#include <QMouseEvent>
#include <QtOpenGL/QGLWidget>

class GLPanel : public QGLWidget
{
  Q_OBJECT // must include this if you use Qt Signals & Slots

 public:
  GLPanel(QWidget *parent = 0);
  ~GLPanel();

 protected:
  // Canvas predefined slots
  void initializeGL();
  void resizeGL(int _width, int _height);
  void paintGL();

 protected:
  int  m_w; // width: GL canvas horizontal size
  int  m_h; // height: GL canvas vertical size
  GLdouble m_left;    // left limit of object space window
  GLdouble m_right;   // right limit of object space window
  GLdouble m_bottom;  // bottom limit of object space window
  GLdouble m_top;     // top limit of object space window

  // Mouse point properties
  bool m_buttonPressed;     // if true, mouse button is pressed
  // QPoint is a Qt class that defines a point in a plane
  // i.e. the position of the mouse on the canvas.
  QPoint m_pt0;            // mouse position at button press event
  QPoint m_pt1;            // current mouse position

  // QPointF is a Qt class that defines a point in floating
  // point coordinates.
  QPointF convertPtCoordsToUniverse(QPoint _pt);

 public slots:
  // Mouse events slots
  void mousePressEvent(QMouseEvent* event);
  void mouseMoveEvent(QMouseEvent* event);
  void mouseReleaseEvent(QMouseEvent *event);
};

#endif // GLPANEL_H
