#include "glpanel.h"

//-------------------------------------------------------------------------
GLPanel::GLPanel(QWidget *parent)
: QGLWidget(parent)
{
 m_pt0.setX(0);
 m_pt0.setY(0);
 m_pt1.setY(0);
 m_pt1.setY(0);
 m_buttonPressed = false;
}
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
GLPanel::~GLPanel()
{
}
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
void
GLPanel::initializeGL()
{
 // set white as background color and clear window
 glClearColor(1.0, 1.0, 1.0, 1.0); 
 glClear(GL_COLOR_BUFFER_BIT);

 // enable smooth line display
 glEnable(GL_LINE_SMOOTH);
}
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
void
GLPanel::resizeGL(int _width,
                  int _height)
{
 // store GL canvas sizes in object properties
 m_w = _width;
 m_h = _height;

 // setup the viewport to canvas dimensions
 glViewport(0, 0, (GLint)m_w, (GLint)m_h);

 // setup world limit coordinates based on canvas sizes
 m_left = 0.0;
 m_right = (double)m_w/10.0;
 m_bottom = 0.0;
 m_top = (double)m_h/10.0;

 // reset the coordinate system
 glMatrixMode(GL_PROJECTION); 
 glLoadIdentity();

 // establish the clipping volume by setting up an
 // orthographic projection
 glOrtho(m_left, m_right, m_bottom, m_top, -1.0, 1.0);

 // setup display in model coordinates
 glMatrixMode(GL_MODELVIEW); 
 glLoadIdentity();
}
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
void
GLPanel::paintGL()
{
 // clear the buffer with the current clear color
 glClear(GL_COLOR_BUFFER_BIT);

 // draw a yellow line from button press point to current point
 glColor3f(1.0, 0.0, 0.0);  // red
 QPointF pt0_U = convertPtCoordsToUniverse(m_pt0);
 QPointF pt1_U = convertPtCoordsToUniverse(m_pt1);
 glBegin(GL_LINE_STRIP);
 glVertex2f(pt0_U.x(), pt0_U.y());
 glVertex2f(pt1_U.x(), pt1_U.y());
 glEnd();
}
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
QPointF 
GLPanel::convertPtCoordsToUniverse(QPoint _pt)
{
 double dX = m_right - m_left; // universe window horizontal size
 double dY = m_top - m_bottom; // universe window vertical size

 // Origin of canvas raster coordinates it at the left-top corner,
 // while origin of GL canvas floating point coordinates is at
 // left-bottom corner.
 // mX is the distance of point to left universe window limit
 // mY is the distance of point to bottom universe window limit
/*** COMPLETE HERE 01 ***/

 


/*** COMPLETE HERE 01 ***/
 return QPointF(x,y);
}
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
//                      PUBLIC SLOTS
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
void 
GLPanel::mousePressEvent(QMouseEvent* event)
{
/*** COMPLETE HERE 02 ***/


/*** COMPLETE HERE 02 ***/
}

//-------------------------------------------------------------------------
void 
GLPanel::mouseMoveEvent(QMouseEvent* event)
{
/*** COMPLETE HERE 03 ***/



/*** COMPLETE HERE 03 ***/
 update();
}
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
void 
GLPanel::mouseReleaseEvent(QMouseEvent *event)
{
/*** COMPLETE HERE 04 ***/


/*** COMPLETE HERE 04 ***/
 update();
}
//-------------------------------------------------------------------------
