/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.awt.Component;
import java.util.List;
import javax.swing.SortOrder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.table.ColumnsObjectTableModel;
import tecgraf.javautils.gui.table.IColumn;
import tecgraf.javautils.gui.table.SortableTable;

public class ObjectTableBuilder<R> {
    private IColumn<R>[] columns;
    private ColumnsWidthPolicy columnsWidthPolicy;
    private SelectionMode selectionMode;
    private int sortColumnIndex;
    private SortOrder sortOrder;

    public ObjectTableBuilder(IColumn<R> ... columns) {
        if (null == columns) {
            throw new NullPointerException("columns can't be null");
        }
        if (columns.length == 0) {
            throw new IllegalArgumentException("columns.length == 0");
        }
        this.columns = columns;
        this.columnsWidthPolicy = ColumnsWidthPolicy.ADJUST_BY_TITLE;
        this.selectionMode = SelectionMode.NO_SELECTION;
        this.sortColumnIndex = -1;
        this.sortOrder = SortOrder.UNSORTED;
    }

    public void setColumnsWidthPolicy(ColumnsWidthPolicy policy) {
        if (null == policy) {
            throw new NullPointerException("policy can't be null");
        }
        this.columnsWidthPolicy = policy;
    }

    public void setSelectionMode(SelectionMode mode) {
        if (null == mode) {
            throw new NullPointerException("mode can't be null");
        }
        this.selectionMode = mode;
    }

    public void setSortOrder(int columnIndex, SortOrder order) {
        if (columnIndex < 0 || columnIndex >= this.columns.length) {
            throw new ArrayIndexOutOfBoundsException(columnIndex);
        }
        if (null == order) {
            throw new NullPointerException("order can't be null");
        }
        this.sortColumnIndex = columnIndex;
        this.sortOrder = order;
    }

    public SortableTable build(List<R> objs) {
        ColumnsObjectTableModel<R> model = new ColumnsObjectTableModel<R>(objs, this.columns);
        SortableTable table = this.createTable(model);
        this.setCellRendererAndEditor(table);
        this.setSelectionMode(table);
        this.setColumnsWidthPolicy(table);
        this.sortTable(table);
        return table;
    }

    protected SortableTable createTable(TableModel model) {
        return new SortableTable(model);
    }

    private void setColumnsWidthPolicy(final SortableTable table) {
        switch (this.columnsWidthPolicy) {
            case ADJUST_BY_TITLE: {
                this.adjustColumnsWidth(table, false);
                break;
            }
            case ADJUST_BY_DATA_DYNAMIC: {
                table.getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent e) {
                        ObjectTableBuilder.this.adjustColumnsWidth(table, true);
                    }
                });
            }
            case ADJUST_BY_DATA: {
                this.adjustColumnsWidth(table, true);
                break;
            }
        }
    }

    private void adjustColumnsWidth(SortableTable table, boolean adjustByData) {
        TableColumnModel columnModel = table.getColumnModel();
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        for (int colInx = 0; colInx < table.getColumnCount(); ++colInx) {
            String columnName = table.getColumnName(colInx);
            Component header = headerRenderer.getTableCellRendererComponent(table, columnName, false, false, 0, colInx);
            int prefWidth = header.getPreferredSize().width;
            if (adjustByData) {
                TableColumn column = columnModel.getColumn(colInx);
                TableCellRenderer columnRenderer = column.getCellRenderer();
                if (null == columnRenderer) {
                    columnRenderer = headerRenderer;
                }
                TableModel tableModel = table.getModel();
                for (int rowInx = 0; rowInx < tableModel.getRowCount(); ++rowInx) {
                    Object value = tableModel.getValueAt(rowInx, colInx);
                    if (value == null) continue;
                    Component component = columnRenderer.getTableCellRendererComponent(table, value, false, false, rowInx, colInx);
                    int width = component.getPreferredSize().width;
                    prefWidth = Math.max(prefWidth, width);
                }
            }
            TableColumn aColumnModel = columnModel.getColumn(colInx);
            aColumnModel.setPreferredWidth(prefWidth + 1);
        }
    }

    private void setCellRendererAndEditor(SortableTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int inx = 0; inx < columnModel.getColumnCount(); ++inx) {
            TableCellEditor editor;
            TableColumn column = columnModel.getColumn(inx);
            TableCellRenderer renderer = this.columns[inx].createTableCellRenderer();
            if (null != renderer) {
                column.setCellRenderer(renderer);
            }
            if (null == (editor = this.columns[inx].createTableCellEditor())) continue;
            column.setCellEditor(editor);
        }
    }

    private void setSelectionMode(SortableTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        switch (this.selectionMode) {
            case SINGLE_SELECTION: {
                table.setRowSelectionAllowed(true);
                columnModel.getSelectionModel().setSelectionMode(0);
                break;
            }
            case SINGLE_INTERVAL_SELECTION: {
                table.setRowSelectionAllowed(true);
                columnModel.getSelectionModel().setSelectionMode(1);
                break;
            }
            case MULTIPLE_INTERVAL_SELECTION: {
                table.setRowSelectionAllowed(true);
                columnModel.getSelectionModel().setSelectionMode(2);
                break;
            }
            default: {
                table.setRowSelectionAllowed(false);
            }
        }
    }

    private void sortTable(SortableTable table) {
        if (this.sortOrder == SortOrder.UNSORTED) {
            table.sort(0, this.sortOrder);
        } else {
            table.sort(this.sortColumnIndex, this.sortOrder);
        }
    }

    public static enum ColumnsWidthPolicy {
        NONE,
        ADJUST_BY_TITLE,
        ADJUST_BY_DATA,
        ADJUST_BY_DATA_DYNAMIC;

    }

    public static enum SelectionMode {
        NO_SELECTION,
        SINGLE_SELECTION,
        SINGLE_INTERVAL_SELECTION,
        MULTIPLE_INTERVAL_SELECTION;

    }
}

