/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.selector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIResources;
import tecgraf.javautils.gui.panel.FilteredView;
import tecgraf.javautils.gui.panel.TextFieldFilterPanel;
import tecgraf.javautils.gui.selector.ContainerSelectionListener;
import tecgraf.javautils.gui.selector.ItemContainer;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class ContainerSelection<T>
implements FilteredView {
    private static final String LNG_KEY_PREFIX = ContainerSelection.class.getName() + ".";
    private Collection<T> defaultSelectedItems;
    private JButton restoreDefaultsButton;
    private boolean hasRestoreDefaultsButton;
    private JButton addAllButton;
    private JButton addButton;
    private JPanel panel;
    private JPanel buttonPanel;
    int gridy = 0;
    private JButton removeAllButton;
    private JButton removeButton;
    private ItemContainer<T> selectedContainer;
    private ItemContainer<T> availableContainer;
    private String selectedText;
    private String availableText;
    private boolean hasContainerTitle;
    private boolean hasAddAllButton = true;
    private boolean hasRemoveAllButton = true;
    private boolean showButtonsText = true;
    private int buttonPanelAnchor = 0;
    private List<ContainerSelectionListener> containerSelectionListeners;
    private TextFieldFilterPanel filterPanel;

    protected void fireContainerSelectionEvent() {
        for (ContainerSelectionListener csl : this.containerSelectionListeners) {
            csl.containerChanged();
        }
    }

    public void addContainerSelectionListener(ContainerSelectionListener l) {
        this.containerSelectionListeners.add(l);
    }

    public void removeContainerSelectionListener(ContainerSelectionListener l) {
        this.containerSelectionListeners.remove(l);
    }

    public void clear() {
        this.clearAvailableItems();
        this.clearSelectedItems();
    }

    public void clearAvailableItems() {
        this.availableContainer.removeAll();
    }

    public ItemContainer<T> getAvailableContainer() {
        return this.availableContainer;
    }

    public List<T> getAvailableItems() {
        return Collections.unmodifiableList(this.availableContainer.getAll());
    }

    public T getFirstAvailableItem() {
        if (!this.hasAvailableItems()) {
            return null;
        }
        return this.getAvailableItems().get(0);
    }

    public boolean hasAvailableItems() {
        return !this.getAvailableItems().isEmpty();
    }

    protected void loadAvailableItems(Collection<T> elements) {
        this.availableContainer.load(elements);
    }

    public void clearSelectedItems() {
        this.selectedContainer.removeAll();
    }

    public T getFirstSelectedItem() {
        if (!this.hasSelectedItems()) {
            return null;
        }
        return this.getSelectedItems().get(0);
    }

    public ItemContainer<T> getSelectedContainer() {
        return this.selectedContainer;
    }

    public List<T> getSelectedItems() {
        return Collections.unmodifiableList(this.selectedContainer.getAll());
    }

    public boolean hasSelectedItems() {
        return !this.getSelectedItems().isEmpty();
    }

    private void loadSelectedItems(Collection<T> elements) {
        this.selectedContainer.load(elements);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public boolean hasItems() {
        return this.hasSelectedItems() || this.hasAvailableItems();
    }

    public void loadItems(Collection<T> availableItems, Collection<T> selectedItems) {
        if (this.hasRestoreDefaultsButton) {
            LinkedList<T> defaultLocalList = new LinkedList<T>();
            defaultLocalList.addAll(selectedItems);
            this.loadItems(availableItems, selectedItems, defaultLocalList);
        } else {
            this.loadItems(availableItems, selectedItems, null);
        }
    }

    public void loadItems(Collection<T> availableItems, Collection<T> selectedItems, Collection<T> defaultSelectedItems) {
        if (this.restoreDefaultsButton != null) {
            this.restoreDefaultsButton.setEnabled(defaultSelectedItems != null);
        }
        this.defaultSelectedItems = defaultSelectedItems;
        LinkedList<T> availableCollection = new LinkedList<T>();
        availableCollection.addAll(availableItems);
        availableCollection.removeAll(selectedItems);
        this.clear();
        this.loadAvailableItems(availableCollection);
        this.loadSelectedItems(selectedItems);
        this.fireContainerSelectionEvent();
    }

    public void loadItems(Collection<T> availableItems) {
        this.loadItems(availableItems, new ArrayList());
    }

    public void setEnabled(boolean enabled) {
        if (this.restoreDefaultsButton != null) {
            this.restoreDefaultsButton.setEnabled(enabled && this.defaultSelectedItems != null);
        }
        this.availableContainer.setEnabled(enabled);
        this.selectedContainer.setEnabled(enabled);
        if (enabled) {
            if (this.availableContainer.hasSelectedItems()) {
                this.addButton.setEnabled(true);
            }
            if (!this.availableContainer.getAll().isEmpty()) {
                this.addAllButton.setEnabled(true);
            }
            if (this.selectedContainer.hasSelectedItems()) {
                this.removeButton.setEnabled(true);
            }
            if (!this.selectedContainer.getAll().isEmpty()) {
                this.removeAllButton.setEnabled(true);
            }
        } else {
            this.addButton.setEnabled(false);
            this.addAllButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
        }
    }

    protected void moveAllRows(ItemContainer<T> source, ItemContainer<T> target) {
        Collection<T> elements = source.removeAll();
        target.load(elements);
        this.fireContainerSelectionEvent();
    }

    protected void moveRows(ItemContainer<T> source, ItemContainer<T> target) {
        Collection<T> elements = source.removeSelectedElements();
        target.load(elements);
        this.fireContainerSelectionEvent();
    }

    private void buildPane() {
        GBC constraints;
        int height = this.hasRestoreDefaultsButton ? 5 : 4;
        this.panel = new JPanel(new GridBagLayout());
        int gridY = 0;
        if (this.hasContainerTitle) {
            constraints = new GBC(0, gridY++).insets(10, 2, 2, 2).west().none();
            JLabel availableLabel = new JLabel(this.availableText);
            this.panel.add((Component)availableLabel, constraints);
        }
        this.filterPanel = new TextFieldFilterPanel(this);
        constraints = new GBC(0, gridY).insets(2, 2, 2, 2).horizontal();
        this.panel.add((Component)this.filterPanel, constraints);
        this.filterPanel.setVisible(false);
        constraints = new GBC(0, gridY + 1).insets(2, 2, 2, 2).width(1).both().height(height);
        this.panel.add((Component)this.availableContainer.getView(), constraints);
        JPanel buttonPanel = this.makeButtonPanel();
        constraints = new GBC(1, gridY + 1).insets(2, 2, 2, 2).both().height(height).weightx(0.0);
        this.panel.add((Component)buttonPanel, constraints);
        gridY = 0;
        if (this.hasContainerTitle) {
            constraints = new GBC(2, gridY++).width(1).height(1).west().none().insets(10, 2, 2, 2);
            JLabel selectedLabel = new JLabel(this.selectedText);
            this.panel.add((Component)selectedLabel, constraints);
        }
        constraints = new GBC(2, gridY + 1).insets(2, 2, 2, 2).both().east().height(height);
        this.panel.add((Component)this.selectedContainer.getView(), constraints);
    }

    private JPanel makeButtonPanel() {
        this.buttonPanel = new JPanel(new GridBagLayout());
        GBC constraints = new GBC(0, this.gridy++).insets(2, 2, 2, 2).horizontal().center();
        this.buttonPanel.add((Component)this.addButton, constraints);
        constraints = new GBC(0, this.gridy++).insets(2, 2, 2, 2).horizontal().center();
        this.buttonPanel.add((Component)this.removeButton, constraints);
        if (this.hasAddAllButton) {
            constraints = new GBC(0, this.gridy++).insets(10, 2, 2, 2).horizontal().center();
            this.buttonPanel.add((Component)this.addAllButton, constraints);
        }
        if (this.hasRemoveAllButton) {
            constraints = this.hasAddAllButton ? new GBC(0, this.gridy++).insets(2, 2, 2, 2).horizontal().center() : new GBC(0, this.gridy++).insets(10, 2, 2, 2).horizontal().center();
            this.buttonPanel.add((Component)this.removeAllButton, constraints);
        }
        if (this.hasRestoreDefaultsButton) {
            constraints = new GBC(0, this.gridy++).insets(10, 2, 2, 2).horizontal().center();
            this.restoreDefaultsButton = this.makeRestoreDefaultsButton();
            this.buttonPanel.add((Component)this.restoreDefaultsButton, constraints);
        }
        JPanel returnPanel = new JPanel(new BorderLayout());
        switch (this.buttonPanelAnchor) {
            case 1: {
                returnPanel.add((Component)this.buttonPanel, "North");
                break;
            }
            case 5: {
                returnPanel.add((Component)this.buttonPanel, "South");
                break;
            }
            case 0: {
                returnPanel.add((Component)this.buttonPanel, "Center");
                break;
            }
            default: {
                returnPanel.add((Component)this.buttonPanel, "Center");
            }
        }
        return returnPanel;
    }

    private JButton makeAddAllButton() {
        ImageIcon icon = GUIResources.SELECTOR_ADDALL_ICON;
        String text = this.showButtonsText ? LNG.get((String)(LNG_KEY_PREFIX + "addAll")) : "";
        this.addAllButton = new JButton(text, icon);
        this.addAllButton.setHorizontalTextPosition(10);
        this.addAllButton.setToolTipText(LNG.get((String)(LNG_KEY_PREFIX + "addAll.tooltip")));
        this.addAllButton.setEnabled(false);
        this.addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ContainerSelection.this.moveAllRows(ContainerSelection.this.availableContainer, ContainerSelection.this.selectedContainer);
            }
        });
        return this.addAllButton;
    }

    private JButton makeAddButton() {
        ImageIcon icon = GUIResources.SELECTOR_ADD_ICON;
        String text = this.showButtonsText ? LNG.get((String)(LNG_KEY_PREFIX + "add")) : "";
        this.addButton = new JButton(text, icon);
        this.addButton.setHorizontalTextPosition(10);
        this.addButton.setToolTipText(LNG.get((String)(LNG_KEY_PREFIX + "add.tooltip")));
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ContainerSelection.this.moveRows(ContainerSelection.this.availableContainer, ContainerSelection.this.selectedContainer);
            }
        });
        return this.addButton;
    }

    private ItemContainer<T> makeContainer(ObjectTableProvider columnFormatter, JButton singleSelectionButton, JButton allSelectedButton, boolean enabled, boolean enableSort, boolean adjustColumnsWidth) {
        ItemContainer container = new ItemContainer(columnFormatter, singleSelectionButton, allSelectedButton, enabled, enableSort, adjustColumnsWidth);
        return container;
    }

    private JButton makeRemoveAllButton() {
        ImageIcon icon = GUIResources.SELECTOR_REMOVEALL_ICON;
        String text = this.showButtonsText ? LNG.get((String)(LNG_KEY_PREFIX + "removeAll")) : "";
        this.removeAllButton = new JButton(text, icon);
        this.removeAllButton.setToolTipText(LNG.get((String)(LNG_KEY_PREFIX + "removeAll.tooltip")));
        this.removeAllButton.setEnabled(false);
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ContainerSelection.this.moveAllRows(ContainerSelection.this.selectedContainer, ContainerSelection.this.availableContainer);
            }
        });
        return this.removeAllButton;
    }

    private JButton makeRemoveButton() {
        ImageIcon icon = GUIResources.SELECTOR_REMOVE_ICON;
        String text = this.showButtonsText ? LNG.get((String)(LNG_KEY_PREFIX + "remove")) : "";
        this.removeButton = new JButton(text, icon);
        this.removeButton.setToolTipText(LNG.get((String)(LNG_KEY_PREFIX + "remove.tooltip")));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ContainerSelection.this.moveRows(ContainerSelection.this.selectedContainer, ContainerSelection.this.availableContainer);
            }
        });
        return this.removeButton;
    }

    private JButton makeRestoreDefaultsButton() {
        ImageIcon icon = GUIResources.SELECTOR_RESTORE_ICON;
        String text = this.showButtonsText ? LNG.get((String)(LNG_KEY_PREFIX + "restoreDefaults")) : "";
        this.restoreDefaultsButton = new JButton(text, icon);
        this.restoreDefaultsButton.setToolTipText(LNG.get((String)(LNG_KEY_PREFIX + "restoreDefaults.tooltip")));
        this.restoreDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ContainerSelection.this.restoreDefaults();
            }
        });
        return this.restoreDefaultsButton;
    }

    public ContainerSelection(ObjectTableProvider formatter) {
        this(formatter, formatter, true);
    }

    public ContainerSelection(ObjectTableProvider firstFormatter, ObjectTableProvider secondFormatter) {
        this(firstFormatter, secondFormatter, true);
    }

    public ContainerSelection(ObjectTableProvider firstFormatter, ObjectTableProvider secondFormatter, boolean enabled) {
        this(firstFormatter, secondFormatter, enabled, true);
    }

    public ContainerSelection(ObjectTableProvider firstFormatter, ObjectTableProvider secondFormatter, boolean enabled, boolean hasRestoreDefaultsButton) {
        this(firstFormatter, secondFormatter, enabled, hasRestoreDefaultsButton, null, null, true, true);
    }

    public ContainerSelection(ObjectTableProvider firstFormatter, ObjectTableProvider secondFormatter, boolean enabled, boolean hasRestoreDefaultsButton, boolean hasAddAllButton, boolean hasRemoveAllButton) {
        this(firstFormatter, secondFormatter, enabled, hasRestoreDefaultsButton, null, null, hasAddAllButton, hasRemoveAllButton);
    }

    public ContainerSelection(ObjectTableProvider firstFormatter, ObjectTableProvider secondFormatter, boolean enabled, boolean hasRestoreDefaultsButton, boolean hasAddAllButton, boolean hasRemoveAllButton, int buttonPanelAnchor) {
        this(firstFormatter, secondFormatter, enabled, hasRestoreDefaultsButton, null, null, hasAddAllButton, hasRemoveAllButton, buttonPanelAnchor);
    }

    public ContainerSelection(ObjectTableProvider firstFormatter, ObjectTableProvider secondFormatter, boolean enabled, boolean hasRestoreDefaultsButton, boolean hasAddAllButton, boolean hasRemoveAllButton, int buttonPanelAnchor, boolean enableSort) {
        this(firstFormatter, secondFormatter, enabled, hasRestoreDefaultsButton, null, null, hasAddAllButton, hasRemoveAllButton, buttonPanelAnchor, enableSort);
    }

    public ContainerSelection(ObjectTableProvider firstFormatter, ObjectTableProvider secondFormatter, boolean enabled, boolean hasRestoreDefaultsButton, String availableText, String selectedText) {
        this(firstFormatter, secondFormatter, enabled, hasRestoreDefaultsButton, availableText, selectedText, true, true);
    }

    public ContainerSelection(ObjectTableProvider firstFormatter, ObjectTableProvider secondFormatter, boolean enabled, boolean hasRestoreDefaultsButton, String availableText, String selectedText, boolean hasAddAllButton, boolean hasRemoveAllButton) {
        this(firstFormatter, secondFormatter, enabled, hasRestoreDefaultsButton, availableText, selectedText, hasAddAllButton, hasRemoveAllButton, 0);
    }

    public ContainerSelection(ObjectTableProvider firstFormatter, ObjectTableProvider secondFormatter, boolean enabled, boolean hasRestoreDefaultsButton, String availableText, String selectedText, boolean hasAddAllButton, boolean hasRemoveAllButton, int buttonPanelAnchor) {
        this(firstFormatter, secondFormatter, enabled, hasRestoreDefaultsButton, availableText, selectedText, hasAddAllButton, hasRemoveAllButton, buttonPanelAnchor, true);
    }

    public ContainerSelection(ObjectTableProvider firstFormatter, ObjectTableProvider secondFormatter, boolean enabled, boolean hasRestoreDefaultsButton, String availableText, String selectedText, boolean hasAddAllButton, boolean hasRemoveAllButton, int buttonPanelAnchor, boolean enableSort) {
        this(firstFormatter, secondFormatter, enabled, hasRestoreDefaultsButton, availableText, selectedText, hasAddAllButton, hasRemoveAllButton, buttonPanelAnchor, true, true);
    }

    public ContainerSelection(ObjectTableProvider firstFormatter, ObjectTableProvider secondFormatter, SortableContainer sortableContainer) {
        this(firstFormatter, secondFormatter, true, true, null, null, true, true, 0, sortableContainer, true);
    }

    public ContainerSelection(ObjectTableProvider firstFormatter, ObjectTableProvider secondFormatter, boolean enabled, boolean hasRestoreDefaultsButton, String availableText, String selectedText, boolean hasAddAllButton, boolean hasRemoveAllButton, int buttonPanelAnchor, SortableContainer sortableContainer, boolean showButtonsText) {
        this(firstFormatter, secondFormatter, enabled, hasRestoreDefaultsButton, availableText, selectedText, hasAddAllButton, hasRemoveAllButton, buttonPanelAnchor, sortableContainer, showButtonsText, true);
    }

    public ContainerSelection(ObjectTableProvider firstFormatter, ObjectTableProvider secondFormatter, boolean enabled, boolean hasRestoreDefaultsButton, String availableText, String selectedText, boolean hasAddAllButton, boolean hasRemoveAllButton, int buttonPanelAnchor, SortableContainer sortableContainer, boolean showButtonsText, boolean adjustColumnsWidth) {
        this.hasRestoreDefaultsButton = hasRestoreDefaultsButton;
        this.hasAddAllButton = hasAddAllButton;
        this.hasRemoveAllButton = hasRemoveAllButton;
        this.hasContainerTitle = availableText != null && selectedText != null;
        this.buttonPanelAnchor = buttonPanelAnchor;
        this.availableText = availableText;
        this.selectedText = selectedText;
        this.showButtonsText = showButtonsText;
        this.addButton = this.makeAddButton();
        this.removeButton = this.makeRemoveButton();
        this.addAllButton = this.makeAddAllButton();
        this.removeAllButton = this.makeRemoveAllButton();
        boolean sortFirst = sortableContainer == SortableContainer.BOTH || sortableContainer == SortableContainer.LEFT_ONLY;
        boolean sortSecond = sortableContainer == SortableContainer.BOTH || sortableContainer == SortableContainer.RIGHT_ONLY;
        this.availableContainer = this.makeContainer(firstFormatter, this.addButton, this.addAllButton, enabled, sortFirst, adjustColumnsWidth);
        this.selectedContainer = this.makeContainer(secondFormatter, this.removeButton, this.removeAllButton, enabled, sortSecond, adjustColumnsWidth);
        this.containerSelectionListeners = new LinkedList<ContainerSelectionListener>();
        this.buildPane();
    }

    public ContainerSelection(ObjectTableProvider firstFormatter, ObjectTableProvider secondFormatter, boolean enabled, boolean hasRestoreDefaultsButton, String availableText, String selectedText, boolean hasAddAllButton, boolean hasRemoveAllButton, int buttonPanelAnchor, boolean enableSort, boolean showButtonsText) {
        this(firstFormatter, secondFormatter, enabled, hasRestoreDefaultsButton, availableText, selectedText, hasAddAllButton, hasRemoveAllButton, buttonPanelAnchor, SortableContainer.BOTH, showButtonsText);
    }

    public void restoreDefaults() {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(this.getAvailableItems());
        list.addAll(this.getSelectedItems());
        this.loadItems(list, this.defaultSelectedItems);
    }

    public void reset() {
        this.moveAllRows(this.selectedContainer, this.availableContainer);
    }

    public void adjustTableColumns() {
        this.availableContainer.getTable().adjustColumnWidth();
        this.selectedContainer.getTable().adjustColumnWidth();
    }

    public final void setToolTipEnabled(boolean enabled) {
        this.availableContainer.getTable().setToolTipEnabled(enabled);
        this.selectedContainer.getTable().setToolTipEnabled(enabled);
    }

    public void addButton(JButton button) {
        if (button == null) {
            throw new NullPointerException();
        }
        GBC constraints = new GBC(0, this.gridy++).insets(10, 2, 2, 2).horizontal().center();
        this.buttonPanel.add((Component)button, constraints);
    }

    public void setShowFilter(boolean showFilter) {
        this.filterPanel.setVisible(showFilter);
    }

    @Override
    public void filter(String toFilter) {
        this.availableContainer.filter(toFilter);
    }

    public static enum SortableContainer {
        LEFT_ONLY,
        RIGHT_ONLY,
        BOTH,
        NONE;

    }
}

