/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import javax.swing.ImageIcon;
import tecgraf.javautils.gui.print.PrintableHeader;

public class PrintableHeaderSample {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Forne\u00e7a o nome de dois arquivos de imagens.");
            System.exit(-1);
        }
        File fimg0 = new File(args[0]);
        File fimg1 = new File(args[1]);
        if (!fimg0.exists() || !fimg1.exists()) {
            System.out.println("Arquivo n\u00e3o existe.");
            System.exit(-1);
        }
        ImageIcon img0 = new ImageIcon(args[0]);
        ImageIcon img1 = new ImageIcon(args[1]);
        final PrintableHeader header = new PrintableHeader(img0, img1);
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(new Printable(){

            @Override
            public int print(Graphics g, PageFormat format, int page) {
                if (page > 0) {
                    return 1;
                }
                format = (PageFormat)format.clone();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(Color.black);
                header.print(g2d, format, page);
                return 0;
            }
        });
        job.printDialog();
        job.print();
        System.out.println("Digite <enter> para terminar.");
        System.in.read();
        System.exit(0);
    }
}

