/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.field;

import javax.swing.text.Document;
import tecgraf.javautils.gui.field.AbstractRegexField;
import tecgraf.javautils.gui.field.LatLongDocument;

public class LatLongField
extends AbstractRegexField {
    public static final LatLongDocument.Orientation LATITUDE = LatLongDocument.Orientation.LATITUDE;
    public static final LatLongDocument.Orientation LONGITUDE = LatLongDocument.Orientation.LONGITUDE;

    public LatLongField(LatLongDocument.Orientation orientation) {
        this(orientation, 2, false, true);
    }

    public LatLongField(LatLongDocument.Orientation orientation, int decimal) {
        this(orientation, decimal, false);
    }

    public LatLongField(LatLongDocument.Orientation orientation, boolean showValidation) {
        this(orientation, 2, showValidation);
    }

    public LatLongField(LatLongDocument.Orientation orientation, boolean showValidation, boolean hemisphereEnabled) {
        this(orientation, 2, showValidation, hemisphereEnabled);
    }

    public LatLongField(LatLongDocument.Orientation orientation, int decimal, boolean showValidation) {
        this(orientation, decimal, showValidation, true);
    }

    public LatLongField(LatLongDocument.Orientation orientation, int decimal, boolean showValidation, boolean hemisphereEnabled) {
        super(showValidation);
        this.setDocument(new LatLongDocument(orientation, decimal, hemisphereEnabled));
        this.setDecimal(decimal);
    }

    public void setAutoComplete(boolean complete) {
        if (complete) {
            this.getLatLongDocument().rebuildCompleText();
        } else {
            this.getLatLongDocument().setCompleteText(null);
        }
    }

    @Override
    public boolean isValidValue() {
        return this.getLatLongDocument().isValid();
    }

    public void setDecimal(int decimal) {
        this.getLatLongDocument().setDecimal(decimal);
    }

    public Integer getDegree() {
        return this.getLatLongDocument().getDegree();
    }

    public Integer getMinute() {
        return this.getLatLongDocument().getMinute();
    }

    public Float getSecond() {
        return this.getLatLongDocument().getSecond();
    }

    @Override
    public void setDocument(Document doc) {
        if (doc != null && doc instanceof LatLongDocument) {
            super.setDocument(doc);
        }
    }

    private LatLongDocument getLatLongDocument() {
        return (LatLongDocument)this.getDocument();
    }

    public boolean isHemisphereEnabled() {
        return this.getLatLongDocument().isHemisphereEnabled();
    }
}

