/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util.tracing;

import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.portableInterceptor.RecursionAwareCI;
import org.jacorb.util.tracing.Request;
import org.jacorb.util.tracing.RequestHelper;
import org.jacorb.util.tracing.Timer;
import org.jacorb.util.tracing.TraceData;
import org.jacorb.util.tracing.TracingService;
import org.omg.CORBA.Any;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ForwardRequest;

public class ClientTraceInterceptor
extends RecursionAwareCI {
    private TracingService tracer;
    private int myTraceId;
    private Codec codec;
    private Request current_request = null;
    private int slot_id;
    private Timer timer;

    public ClientTraceInterceptor(Codec codec, int slot_id, TracingService tracer) {
        super(true);
        this.tracer = tracer;
        this.codec = codec;
        this.slot_id = slot_id;
        this.myTraceId = tracer.get_id();
        this.timer = new Timer();
        System.out.println(" ********************************** ");
        System.out.println("          My id: " + this.myTraceId);
        System.out.println(" ********************************** ");
    }

    public String name() {
        return "ClientTraceInterceptor";
    }

    public void destroy() {
    }

    @Override
    public void do_send_request(ClientRequestInfo ri) throws ForwardRequest {
        try {
            if (ri.response_expected()) {
                System.out.println("request: call to op " + ri.operation());
                this.current_request = new Request(this.myTraceId, ri.effective_target().hashCode() << 32 | (this.myTraceId & 0xFFFF) << 16 | ri.request_id() & 0xFFFF);
                Any any = ri.get_slot(this.slot_id);
                if (any.type().kind().value() != 0) {
                    Request origin = RequestHelper.extract(any);
                    this.tracer.registerSubTrace(origin, this.current_request);
                }
                Any ctx_any = ((ClientRequestInfoImpl)ri).orb().create_any();
                RequestHelper.insert(ctx_any, this.current_request);
                ServiceContext context = new ServiceContext(0x7F00FF00, this.codec.encode(ctx_any));
                this.timer.start(ri.request_id(), ri.target());
                ri.add_request_service_context(context, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void do_send_poll(ClientRequestInfo ri) {
    }

    @Override
    public void do_receive_reply(ClientRequestInfo ri) {
        try {
            System.out.println("reply: return from op " + ri.operation());
            long t = this.timer.stop(ri.request_id(), ri.target());
            this.tracer.logTraceAtPoint(this.current_request, ri.operation(), t, 0L);
            TraceData trace = this.tracer.getTrace(this.current_request);
            System.out.println("-- Trace for request " + ri.operation() + " (rid:" + ri.request_id() + ") -- ");
            this.printTrace(trace, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void do_receive_exception(ClientRequestInfo ri) throws ForwardRequest {
    }

    @Override
    public void do_receive_other(ClientRequestInfo ri) throws ForwardRequest {
    }

    private void printTrace(TraceData trace, String prefix) {
        System.out.println(prefix + " Request originator: " + trace.tracer_id);
        System.out.println(prefix + " Operation: " + trace.operation);
        System.out.println(prefix + " Time: " + trace.client_time + " msecs");
        for (int i = 0; i < trace.subtrace.length; ++i) {
            System.out.println(prefix + "\tsubtrace " + i + " >>>");
            this.printTrace(trace.subtrace[i], prefix + '\t');
            System.out.println(prefix + "\t<<< subtrace " + i);
        }
    }
}

