/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.utils;

import busexplorer.Application;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntityDesc;

public class BusQuery {
    private final String expression;
    private final ScriptEngine engine;

    public BusQuery(String str) throws ScriptException {
        this.expression = str == null ? "" : str;
        ScriptEngineManager manager = new ScriptEngineManager();
        this.engine = manager.getEngineByName("nashorn");
        this.engine.eval("var openbus = {entity: {id: ''} }; ");
    }

    public boolean isValid() throws ScriptException {
        if (this.expression != null && !this.expression.isEmpty() && Pattern.compile("[^!=]+=[^=]+").matcher(this.expression).find()) {
            return false;
        }
        this.engine.eval(this.expression);
        return true;
    }

    public Map<RegisteredEntityDesc, List<String>> filterAuthorizations(Map<RegisteredEntityDesc, List<String>> authorizations) throws ScriptException, ServiceFailure {
        this.engine.put("auths", authorizations);
        this.engine.put("expression", this.expression);
        this.engine.eval("var found = new java.util.HashMap(); auths.forEach(function(key, value) {  openbus.entity.id = key.id;  var test = function() { return new Function(\"return \"+expression)(); };  if (test()) {    found.put(key,value);  } });");
        return (Map)this.engine.get("found");
    }

    public Map<RegisteredEntityDesc, List<String>> filterAuthorizations() throws ScriptException, ServiceFailure {
        return this.filterAuthorizations(Application.login().admin.getAuthorizations());
    }

    public ArrayList<ServiceOfferDesc> filterOffers(List<ServiceOfferDesc> offers) throws ScriptException, ServiceFailure {
        this.engine.put("offers", offers);
        this.engine.put("expression", this.expression);
        this.engine.eval("var found = new java.util.ArrayList(); for (i =0; i < offers.length; i++) {  var offer = offers[i];  for (j=0; j<offer.properties.length; j++) {    var property = offer.properties[j];     if (property.name == \"openbus.offer.entity\") {      openbus.entity.id = property.value;      var test = function() { return new Function(\"return \"+expression)(); };      if (test()) {        found.add(offer);      }     }  }};");
        return (ArrayList)this.engine.get("found");
    }

    public ArrayList<ServiceOfferDesc> filterOffers() throws ScriptException, ServiceFailure {
        return this.filterOffers(Application.login().admin.getOffers());
    }

    public ArrayList<RegisteredEntityDesc> filterEntities(List<RegisteredEntityDesc> entities) throws ScriptException, ServiceFailure {
        this.engine.put("entities", entities);
        this.engine.put("expression", this.expression);
        this.engine.eval("var found = new java.util.ArrayList(); for (i =0; i < entities.length; i++) {  openbus.entity.id = entities[i].id;  var test = function() { return new Function(\"return \"+expression)(); };  if (test()) {    found.add(entities[i]);  } };");
        return (ArrayList)this.engine.get("found");
    }

    public ArrayList<RegisteredEntityDesc> filterEntities() throws ScriptException, ServiceFailure {
        return this.filterEntities(Application.login().admin.getEntities());
    }
}

