/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.offers;

import busexplorer.Application;
import busexplorer.ApplicationIcons;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.offers.OfferWrapper;
import busexplorer.utils.Availability;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.TRANSIENT;

public class OfferStatusAction
extends OpenBusAction<OfferWrapper> {
    public OfferStatusAction(JFrame parentWindow) {
        super(parentWindow);
        this.putValue("SmallIcon", ApplicationIcons.ICON_VALIDATE_16);
        this.putValue("ShortDescription", this.getString("tooltip"));
    }

    @Override
    public ActionType getActionType() {
        return ActionType.OTHER_MULTI_SELECTION;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && this.getTablePanelComponent().getSelectedElements().size() > 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                int i = 0;
                List offers = OfferStatusAction.this.getTablePanelComponent().getSelectedElements();
                for (OfferWrapper offer : offers) {
                    try {
                        offer.getDescriptor().service_ref.getComponentId();
                        offer.updateStatus(Availability.Status.ONLINE, null);
                    }
                    catch (TRANSIENT e) {
                        offer.updateStatus(Availability.Status.UNREACHABLE, (Exception)((Object)e));
                    }
                    catch (COMM_FAILURE e) {
                        offer.updateStatus(Availability.Status.FAILURE, (Exception)((Object)e));
                    }
                    catch (Exception e) {
                        offer.updateStatus(Availability.Status.UNEXPECTED, e);
                    }
                    this.setProgressStatus(100 * ++i / offers.size());
                }
            }

            protected void afterTaskUI() {
                OfferStatusAction.this.getTablePanelComponent().updateUI();
            }
        };
        task.setProgressDialogDelay(1);
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0, true, false);
    }
}

