/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.offers;

import busexplorer.Application;
import busexplorer.desktop.dialog.InputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.offers.OfferWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOffer;

public class OfferDeleteAction
extends OpenBusAction<OfferWrapper> {
    public OfferDeleteAction(JFrame parentWindow) {
        super(parentWindow);
        this.putValue("ShortDescription", this.getString("tooltip"));
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REMOVE;
    }

    @Override
    public boolean abilityConditions() {
        if (Application.login() != null) {
            if (Application.login().hasAdminRights()) {
                return true;
            }
            List offers = this.getTablePanelComponent().getSelectedElements();
            if (offers.size() > 0) {
                for (OfferWrapper offer : offers) {
                    if (offer.getEntityId().equals(Application.login().info.entity)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (InputDialog.showConfirmDialog(this.parentWindow, this.getString("confirm.msg"), this.getString("confirm.title")) != 0) {
            return;
        }
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                List offers = OfferDeleteAction.this.getTablePanelComponent().getSelectedElements();
                for (OfferWrapper offer : offers) {
                    ServiceOffer ref = offer.getDescriptor().ref;
                    ref.remove();
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    OfferDeleteAction.this.getTablePanelComponent().removeSelectedElements();
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

