/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.healing;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.offers.OfferDeleteAction;
import busexplorer.panel.offers.OfferPropertiesAction;
import busexplorer.panel.offers.OfferRefreshAction;
import busexplorer.panel.offers.OfferTableProvider;
import busexplorer.panel.offers.OfferWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.BusQuery;
import busexplorer.utils.Language;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JFrame;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.services.governance.v1_0.Provider;

public class OfferMissingProvider
extends OfferRefreshAction {
    private Consumer<TablePanelComponent> updateReportHook = null;

    public OfferMissingProvider(JFrame parentWindow) {
        super(parentWindow);
    }

    public OfferMissingProvider(JFrame parentWindow, Consumer<TablePanelComponent> updateReportHook) {
        this(parentWindow);
        this.updateReportHook = updateReportHook;
    }

    protected TablePanelComponent<OfferWrapper> buildTableComponent() {
        if (this.getTablePanelComponent() == null) {
            ArrayList<OpenBusAction> actions = new ArrayList<OpenBusAction>();
            actions.add(new OfferDeleteAction((JFrame)this.parentWindow));
            final OfferPropertiesAction offerPropertiesAction = new OfferPropertiesAction(this.parentWindow);
            actions.add(offerPropertiesAction);
            actions.add(this);
            this.setTablePanelComponent(new TablePanelComponent(new ObjectTableModel(new ArrayList(), (ObjectTableProvider)new OfferTableProvider()), actions, false, true));
            this.getTablePanelComponent().addTableMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        offerPropertiesAction.actionPerformed(null);
                    }
                }
            });
        }
        return this.getTablePanelComponent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getTablePanelComponent().getElements().clear();
        if (!Application.login().extension.isExtensionCapable()) {
            return;
        }
        BusExplorerTask<List<OfferWrapper>> task = new BusExplorerTask<List<OfferWrapper>>(ExceptionContext.Service){

            @Override
            protected void doPerformTask() throws Exception {
                int i = 0;
                List result = Application.login().admin.getOffers();
                int size = result.size();
                List providers = Application.login().extension.getProviders();
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    boolean found = false;
                    OfferWrapper offer = new OfferWrapper((ServiceOfferDesc)it.next());
                    for (Provider provider : providers) {
                        if (!provider.busquery().isEmpty()) {
                            for (ServiceOfferDesc offerProvider : new BusQuery(provider.busquery()).filterOffers(result)) {
                                if (!new OfferWrapper(offerProvider).equals(offer)) continue;
                                it.remove();
                                found = true;
                                break;
                            }
                        }
                        if (!found) continue;
                        break;
                    }
                    this.setProgressStatus(100 * i / size);
                    ++i;
                }
                this.setResult(OfferWrapper.convertToInfo(result));
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    TablePanelComponent tablePanelComponent = OfferMissingProvider.this.getTablePanelComponent();
                    if (((List)this.getResult()).isEmpty() && OfferMissingProvider.this.updateReportHook != null && tablePanelComponent.getParent() != null) {
                        OfferMissingProvider.this.updateReportHook.accept(tablePanelComponent);
                    } else {
                        tablePanelComponent.setElements((List)this.getResult());
                    }
                }
            }
        };
        task.execute(this.parentWindow, Language.get(this.getClass().getSuperclass(), "waiting.title"), Language.get(this.getClass().getSuperclass(), "waiting.msg"), 2, 0, true, false);
    }
}

