/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.healing;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.consumers.ConsumerDeleteAction;
import busexplorer.panel.consumers.ConsumerEditAction;
import busexplorer.panel.consumers.ConsumerRefreshAction;
import busexplorer.panel.consumers.ConsumerTableProvider;
import busexplorer.panel.consumers.ConsumerWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JFrame;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class ConsumerMissingBasicInformation
extends ConsumerRefreshAction {
    private Consumer<TablePanelComponent> updateReportHook = null;

    public ConsumerMissingBasicInformation(JFrame parentWindow) {
        super(parentWindow);
    }

    public ConsumerMissingBasicInformation(JFrame parentWindow, Consumer<TablePanelComponent> updateReportHook) {
        this(parentWindow);
        this.updateReportHook = updateReportHook;
    }

    protected TablePanelComponent<ConsumerWrapper> buildTableComponent() {
        if (this.getTablePanelComponent() == null) {
            ArrayList<OpenBusAction> actions = new ArrayList<OpenBusAction>();
            actions.add(new ConsumerDeleteAction((JFrame)this.parentWindow));
            actions.add(new ConsumerEditAction((JFrame)this.parentWindow));
            actions.add(this);
            this.setTablePanelComponent(new TablePanelComponent(new ObjectTableModel(new ArrayList(), (ObjectTableProvider)new ConsumerTableProvider()), actions, false, true));
        }
        return this.getTablePanelComponent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getTablePanelComponent().getElements().clear();
        if (!Application.login().extension.isExtensionCapable()) {
            return;
        }
        BusExplorerTask<List<ConsumerWrapper>> task = new BusExplorerTask<List<ConsumerWrapper>>(ExceptionContext.Service){

            @Override
            protected void doPerformTask() throws Exception {
                int i = 0;
                ArrayList<tecgraf.openbus.services.governance.v1_0.Consumer> result = new ArrayList<tecgraf.openbus.services.governance.v1_0.Consumer>();
                List consumers = Application.login().extension.getConsumers();
                for (tecgraf.openbus.services.governance.v1_0.Consumer consumer : consumers) {
                    if (consumer.code().isEmpty() || consumer.manageroffice().isEmpty() || consumer.supportoffice().isEmpty() || consumer.manager().length == 0 || consumer.support().length == 0) {
                        result.add(consumer);
                    }
                    this.setProgressStatus(100 * i / consumers.size());
                    ++i;
                }
                this.setResult(ConsumerWrapper.convertToInfo(result));
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    TablePanelComponent tablePanelComponent = ConsumerMissingBasicInformation.this.getTablePanelComponent();
                    if (((List)this.getResult()).isEmpty() && ConsumerMissingBasicInformation.this.updateReportHook != null && tablePanelComponent.getParent() != null) {
                        ConsumerMissingBasicInformation.this.updateReportHook.accept(tablePanelComponent);
                    } else {
                        tablePanelComponent.setElements((List)this.getResult());
                    }
                }
            }
        };
        task.execute(this.parentWindow, Language.get(this.getClass().getSuperclass(), "waiting.title"), Language.get(this.getClass().getSuperclass(), "waiting.msg"), 2, 0, true, false);
    }
}

