/*
 * Decompiled with CFR 0.152.
 */
package busexplorer;

import busexplorer.utils.BusAddress;
import com.google.common.collect.ArrayListMultimap;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OfferObserver;
import tecgraf.openbus.OnReloginCallback;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.RemoteOffer;
import tecgraf.openbus.admin.BusAdminFacade;
import tecgraf.openbus.admin.BusAdminImpl;
import tecgraf.openbus.admin.BusAuditFacade;
import tecgraf.openbus.admin.BusAuditImpl;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.UnauthorizedOperation;
import tecgraf.openbus.core.v2_1.services.access_control.AccessDenied;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_1.services.access_control.TooManyAttempts;
import tecgraf.openbus.core.v2_1.services.access_control.UnknownDomain;
import tecgraf.openbus.core.v2_1.services.access_control.WrongEncoding;
import tecgraf.openbus.exception.AlreadyLoggedIn;
import tecgraf.openbus.extension.BusExtensionFacade;
import tecgraf.openbus.extension.BusExtensionImpl;

public class BusExplorerLogin {
    public final LoginInfo info;
    public final BusAddress address;
    public final String domain;
    public BusAdminFacade admin;
    public BusAuditFacade audit;
    public BusExtensionFacade extension;
    private static final short MAX_RETRIES = 3;
    private final OpenBusContext context;
    private boolean adminRights = false;
    private Connection conn;
    private OnReloginCallback onReloginCallback;
    private final SwingWorker<Void, Void> worker;

    public BusExplorerLogin(final BusAddress address, final String entity, String domain) throws InvalidName {
        address.checkBusVersion();
        address.checkBusReference();
        this.info = new LoginInfo();
        this.info.entity = entity;
        this.address = address;
        this.domain = domain;
        this.context = (OpenBusContext)ORBInitializer.initORB().resolve_initial_references("OpenBusContext");
        this.worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                BusExplorerLogin.this.context.ORB().run();
                return null;
            }

            @Override
            protected void done() {
                Logger.getLogger("tecgraf.openbus").info(String.format("ORB finalizou com sucesso para login do usu\u00e1rio %s no barramento %s", entity, address.toString()));
            }
        };
        this.worker.execute();
    }

    public void onRelogin(OnReloginCallback callback) {
        this.onReloginCallback = callback;
    }

    public void doLogin(String password) throws WrongEncoding, AlreadyLoggedIn, ServiceFailure, UnknownDomain, TooManyAttempts, AccessDenied, ServantNotActive, WrongPolicy {
        Object reference = this.getORB().string_to_object(this.address.toIOR());
        this.conn = this.context.connectByReference(reference);
        this.context.defaultConnection(this.conn);
        boolean done = false;
        Throwable lastFailure = null;
        for (int i = 0; i < 3; i = (int)((short)(i + 1))) {
            try {
                this.conn.loginByPassword(this.info.entity, password.getBytes(), this.domain);
                this.conn.onReloginCallback((connection, oldLogin) -> {
                    this.info.id = connection.login().id;
                    try {
                        this.checkAdminRights();
                    }
                    catch (ServiceFailure ex) {
                        ex.printStackTrace();
                    }
                    if (this.onReloginCallback != null) {
                        this.onReloginCallback.onRelogin(connection, oldLogin);
                    }
                });
                this.info.id = this.conn.login().id;
                this.admin = new BusAdminImpl(reference);
                this.audit = new BusAuditImpl(reference, this.conn);
                this.extension = new BusExtensionImpl(this.conn.offerRegistry());
                ArrayListMultimap busExtensionServiceProps = ArrayListMultimap.create();
                busExtensionServiceProps.put((java.lang.Object)"openbus.component.name", (java.lang.Object)"GovernanceExtensionService");
                this.conn.offerRegistry().subscribeObserver(offer -> {
                    try {
                        offer.subscribeObserver(new OfferObserver(){

                            @Override
                            public void propertiesChanged(RemoteOffer offer) {
                            }

                            @Override
                            public void removed(RemoteOffer offer) {
                                BusExplorerLogin.this.onReloginCallback.onRelogin(BusExplorerLogin.this.context.defaultConnection(), BusExplorerLogin.this.conn.login());
                            }
                        });
                    }
                    catch (ServantNotActive | WrongPolicy ex) {
                        ex.printStackTrace();
                    }
                    this.onReloginCallback.onRelogin(this.context.defaultConnection(), this.conn.login());
                }, (ArrayListMultimap<String, String>)busExtensionServiceProps);
                this.checkAdminRights();
                done = true;
                break;
            }
            catch (COMM_FAILURE | TRANSIENT e) {
                lastFailure = e;
            }
            catch (NO_PERMISSION e) {
                if (e.minor != 1112888319) {
                    throw e;
                }
                lastFailure = e;
            }
            catch (Exception e) {
                this.logout();
                throw e;
            }
            try {
                Thread.sleep(250L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!done) {
            throw new IllegalArgumentException(this.address.toIOR(), lastFailure);
        }
    }

    public boolean hasAdminRights() {
        return this.adminRights;
    }

    public void logout() {
        try {
            if (this.conn != null) {
                ORB orb = this.conn.ORB();
                this.conn.logout();
                orb.shutdown(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkAdminRights() throws ServiceFailure {
        try {
            this.admin.getLogins();
            this.adminRights = true;
        }
        catch (UnauthorizedOperation e) {
            this.adminRights = false;
        }
    }

    public OpenBusContext getOpenBusContext() {
        return this.context;
    }

    public ORB getORB() {
        return this.getOpenBusContext().ORB();
    }
}

