/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.retry;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.openbus.retry.RetryContext;

class RetryTask<T> {
    private static final Logger logger = Logger.getLogger(RetryTask.class.getName());
    private final ListeningScheduledExecutorService pool;
    private final Callable<T> task;
    private final SettableFuture<T> future = SettableFuture.create();
    private ListenableFuture<T> result = null;
    private final RetryContext context;
    private final FutureCallback<T> callback;

    public RetryTask(ListeningScheduledExecutorService scheduler, Callable<T> callable) {
        this(scheduler, callable, new RetryContext());
    }

    public RetryTask(ListeningScheduledExecutorService scheduler, Callable<T> callable, RetryContext context) {
        this.pool = scheduler;
        this.task = callable;
        this.context = context;
        this.context.future((Future)this.future);
        this.callback = new FutureCallback<T>(){

            public void onSuccess(T result) {
                try {
                    RetryTask.this.complete(result);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Erro ao lidar com uma RetryTask bem-sucedida.", e);
                    throw e;
                }
            }

            public void onFailure(Throwable t) {
                try {
                    RetryTask.this.handleException(t);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Erro ao lidar com um throwable recebido por uma RetryTask.", e);
                    throw e;
                }
            }
        };
    }

    public RetryTask(ListeningScheduledExecutorService scheduler, Runnable runnable) {
        this(scheduler, runnable, new RetryContext());
    }

    public RetryTask(ListeningScheduledExecutorService scheduler, Runnable runnable, RetryContext context) {
        this(scheduler, () -> {
            runnable.run();
            return null;
        }, context);
    }

    public void execute() {
        this.result = this.pool.submit(this.task);
        Futures.addCallback(this.result, this.callback, (Executor)this.pool);
    }

    protected void handleException(Throwable t) {
        this.context.setLastException(t);
        if (!this.future.isCancelled()) {
            if (this.context.shouldRetry()) {
                this.context.incrementRetrys();
                this.retryWithDelay();
            } else {
                logger.finest(String.format("M\u00c3\u00a1ximo de tentativas alcan\u00c3\u00a7ado. \u00c3\u009altima exce\u00c3\u00a7\u00c3\u00a3o: %s", t));
                this.future.setFuture(this.result);
            }
        } else {
            logger.finest("Execu\u00c3\u00a7\u00c3\u00a3o cancelada pelo usu\u00c3\u00a1rio, n\u00c3\u00a3o vai fazer retry");
        }
    }

    protected void complete(T result) {
        this.future.setFuture(this.result);
        logger.finest("Execu\u00c3\u00a7\u00c3\u00a3o bem-sucedida.");
    }

    protected ListenableFuture<T> getFuture() {
        return this.future;
    }

    private void retryWithDelay() {
        long delay = this.context.getDelay();
        TimeUnit unit = this.context.getDelayUnit();
        Throwable ex = this.context.getLastException();
        logger.finest(String.format("Falha na tarefa. Uma nova tentativa ser\u00c3\u00a1 agendada para ocorrer em %d %s. \u00c3\u009altima exce\u00c3\u00a7\u00c3\u00a3o: %s", new Object[]{delay, unit, ex}));
        this.result = this.pool.schedule(this.task, delay, unit);
        Futures.addCallback(this.result, this.callback, (Executor)this.pool);
    }
}

