/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import com.google.common.collect.ArrayListMultimap;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import scs.core.IComponent;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OfferObserver;
import tecgraf.openbus.OfferSubscription;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.RemoteOffer;
import tecgraf.openbus.core.OfferRegistryImpl;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.UnauthorizedOperation;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_1.services.offer_registry.InvalidProperties;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOffer;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceProperty;

class RemoteOfferImpl
implements RemoteOffer {
    private final Object lock = new Object();
    private final OfferRegistryImpl registry;
    private ServiceOfferDesc offer;
    private final LoginInfo owner;
    private ArrayListMultimap<String, String> properties;
    private final OpenBusContext context;
    private final Connection conn;

    protected RemoteOfferImpl(OfferRegistryImpl registry, ServiceOfferDesc offer) {
        this.registry = registry;
        this.offer = offer;
        this.owner = OfferRegistryImpl.getOwnerFromOffer(offer);
        this.properties = RemoteOfferImpl.convertPropertiesToHashMap(offer.properties);
        this.conn = registry.connection();
        this.context = this.conn.context();
    }

    @Override
    public Connection connection() {
        return this.conn;
    }

    @Override
    public LoginInfo owner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IComponent service() {
        Object object = this.lock;
        synchronized (object) {
            return this.offer != null ? this.offer.service_ref : null;
        }
    }

    @Override
    public ArrayListMultimap<String, String> properties() {
        return this.properties(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void properties(ArrayListMultimap<String, String> properties) throws UnauthorizedOperation, InvalidProperties, ServiceFailure {
        ServiceOfferDesc offerDesc = this.offer();
        if (offerDesc == null || offerDesc.ref == null) {
            throw new OBJECT_NOT_EXIST("A oferta foi removida do barramento.");
        }
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            offerDesc.ref.setProperties(OfferRegistryImpl.convertMapToProperties(properties));
        }
        finally {
            this.context.currentConnection(prev);
        }
        this.updateProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() throws ServiceFailure, UnauthorizedOperation {
        ServiceOfferDesc offerDesc = this.offer();
        if (offerDesc == null) {
            return;
        }
        ServiceOffer offer = offerDesc.ref;
        if (offer == null) {
            return;
        }
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            offer.remove();
        }
        catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
        }
        finally {
            this.context.currentConnection(prev);
        }
        this.removed();
    }

    @Override
    public OfferSubscription subscribeObserver(OfferObserver observer) throws ServantNotActive, WrongPolicy {
        return this.registry.subscribeToOffer(this, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayListMultimap<String, String> properties(boolean update) {
        ServiceOfferDesc offer;
        if (update && (offer = this.offer()) != null) {
            Connection prev = this.context.currentConnection();
            try {
                this.context.currentConnection(this.conn);
                ServiceProperty[] props = offer.ref.properties();
                Object object = this.lock;
                synchronized (object) {
                    ArrayListMultimap<String, String> arrayListMultimap = this.properties = RemoteOfferImpl.convertPropertiesToHashMap(props);
                    return arrayListMultimap;
                }
            }
            finally {
                this.context.currentConnection(prev);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            return this.properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceOfferDesc offer() {
        Object object = this.lock;
        synchronized (object) {
            return this.offer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void offer(ServiceOfferDesc offer) {
        Object object = this.lock;
        synchronized (object) {
            this.offer = offer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removed() {
        Object object = this.lock;
        synchronized (object) {
            this.offer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProperties(ArrayListMultimap<String, String> props) {
        Object object = this.lock;
        synchronized (object) {
            this.properties = props;
        }
    }

    public static ArrayListMultimap<String, String> convertPropertiesToHashMap(ServiceProperty[] properties) {
        ArrayListMultimap map = ArrayListMultimap.create();
        for (ServiceProperty property : properties) {
            map.put((Object)property.name, (Object)property.value);
        }
        return map;
    }
}

