/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import scs.core.IComponent;
import tecgraf.openbus.Connection;
import tecgraf.openbus.LocalOffer;
import tecgraf.openbus.OfferRegistry;
import tecgraf.openbus.OfferRegistrySubscription;
import tecgraf.openbus.OfferSubscription;
import tecgraf.openbus.RemoteOffer;
import tecgraf.openbus.core.BusResource;
import tecgraf.openbus.core.LocalOfferImpl;
import tecgraf.openbus.core.LoginEvent;
import tecgraf.openbus.core.OfferObserverImpl;
import tecgraf.openbus.core.OfferRegistryObserverImpl;
import tecgraf.openbus.core.OfferRegistryRetryContext;
import tecgraf.openbus.core.OfferRegistrySubscriptionImpl;
import tecgraf.openbus.core.OfferRegistrySubscriptionRetryContext;
import tecgraf.openbus.core.OfferSubscriptionImpl;
import tecgraf.openbus.core.OfferSubscriptionRetryContext;
import tecgraf.openbus.core.OpenBusContextImpl;
import tecgraf.openbus.core.OpenBusRetryContext;
import tecgraf.openbus.core.RemoteOfferImpl;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.UnauthorizedOperation;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_1.services.offer_registry.InvalidProperties;
import tecgraf.openbus.core.v2_1.services.offer_registry.InvalidService;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferObserver;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferObserverHelper;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferObserverSubscription;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistryObserver;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistryObserverHelper;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistryObserverSubscription;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOffer;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceProperty;
import tecgraf.openbus.core.v2_1.services.offer_registry.UnauthorizedFacets;
import tecgraf.openbus.retry.RetryContext;
import tecgraf.openbus.retry.RetryTaskPool;

class OfferRegistryImpl
implements OfferRegistry {
    private final java.lang.Object lock = new java.lang.Object();
    private final OpenBusContextImpl context;
    private final Connection conn;
    private final POA poa;
    private tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry registry;
    private final RetryTaskPool pool;
    private Map<LocalOfferImpl, ListenableFuture<RemoteOfferImpl>> maintainedOffers;
    private Map<OfferRegistrySubscriptionImpl, ListenableFuture<OfferRegistryObserverSubscription>> registrySubs;
    private Map<OfferSubscriptionImpl, ListenableFuture<OfferObserverSubscription>> offerSubs;
    private ListenableFuture<Void> futureReLogin;
    private final long retryDelay;
    private final TimeUnit delayUnit;
    private static final Logger logger = Logger.getLogger(OfferRegistryImpl.class.getName());

    protected OfferRegistryImpl(OpenBusContextImpl context, Connection conn, POA poa, RetryTaskPool pool, long interval, TimeUnit unit) {
        this.context = context;
        this.conn = conn;
        this.poa = poa;
        this.pool = pool;
        this.retryDelay = interval;
        this.delayUnit = unit;
    }

    @Override
    public Connection connection() {
        return this.conn;
    }

    @Override
    public LocalOffer registerService(IComponent service, ArrayListMultimap<String, String> properties) {
        tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry registry = this.registry();
        if (registry == null) {
            return null;
        }
        LocalOfferImpl localOffer = new LocalOfferImpl(this, service, OfferRegistryImpl.convertMapToProperties(properties));
        if (!this.doRegisterTask(registry, localOffer)) {
            return null;
        }
        return localOffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RemoteOffer> findServices(ArrayListMultimap<String, String> properties) throws ServiceFailure {
        tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry registry = this.registry();
        if (registry == null) {
            return new ArrayList<RemoteOffer>();
        }
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            ServiceOfferDesc[] descs = registry.findServices(OfferRegistryImpl.convertMapToProperties(properties));
            ArrayList<RemoteOffer> offers = new ArrayList<RemoteOffer>(descs.length);
            for (ServiceOfferDesc desc : descs) {
                offers.add(new RemoteOfferImpl(this, desc));
            }
            ArrayList<RemoteOffer> arrayList = offers;
            return arrayList;
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RemoteOffer> allServices() throws ServiceFailure {
        tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry registry = this.registry();
        if (registry == null) {
            return new ArrayList<RemoteOffer>();
        }
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            ServiceOfferDesc[] descs = registry.getAllServices();
            ArrayList<RemoteOffer> offers = new ArrayList<RemoteOffer>(descs.length);
            for (ServiceOfferDesc desc : descs) {
                offers.add(new RemoteOfferImpl(this, desc));
            }
            ArrayList<RemoteOffer> arrayList = offers;
            return arrayList;
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    @Override
    public OfferRegistrySubscription subscribeObserver(tecgraf.openbus.OfferRegistryObserver observer, ArrayListMultimap<String, String> properties) throws ServantNotActive, WrongPolicy {
        tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry registry = this.registry();
        if (registry == null) {
            return null;
        }
        OfferRegistryObserverImpl busObserver = new OfferRegistryObserverImpl(observer, this);
        OfferRegistryObserver proxy = OfferRegistryObserverHelper.narrow(this.poa.servant_to_reference((Servant)busObserver));
        OfferRegistrySubscriptionImpl localSub = new OfferRegistrySubscriptionImpl(this, busObserver, proxy, properties);
        if (!this.doSubscribeToRegistryTask(registry, localSub)) {
            return null;
        }
        return localSub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelRegisterTask(LocalOfferImpl offer) {
        java.lang.Object object = this.lock;
        synchronized (object) {
            Map<LocalOfferImpl, ListenableFuture<RemoteOfferImpl>> maintainedOffers = this.maintainedOffers();
            if (maintainedOffers == null) {
                return;
            }
            final AtomicBoolean needRemove = new AtomicBoolean(false);
            ListenableFuture<RemoteOfferImpl> future = maintainedOffers.get(offer);
            if (future != null) {
                if (!future.cancel(false)) {
                    needRemove.set(true);
                } else {
                    Futures.addCallback(future, (FutureCallback)new FutureCallback<RemoteOfferImpl>(){

                        public void onFailure(Throwable ex) {
                        }

                        public void onSuccess(RemoteOfferImpl remote) {
                            try {
                                needRemove.set(true);
                            }
                            catch (Throwable e) {
                                logger.log(Level.SEVERE, "Erro ao completar uma tarefa de cancelamento de registro de oferta do OfferRegistry bem-sucedida.", e);
                                throw e;
                            }
                        }
                    }, (Executor)this.pool.pool());
                    try {
                        future.get();
                    }
                    catch (Exception exception) {}
                }
            } else if (maintainedOffers.containsKey(offer)) {
                needRemove.set(true);
            }
            if (needRemove.get()) {
                RemoteOfferImpl remote = null;
                if (future != null) {
                    try {
                        remote = future.isDone() ? (RemoteOfferImpl)future.get() : null;
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        // empty catch block
                    }
                }
                if (remote == null) {
                    try {
                        remote = (RemoteOfferImpl)offer.remoteOffer();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (remote != null) {
                    ListenableFuture<Void> futureRemoval = this.pool.doTask(new OfferRemovalTask(remote), (RetryContext)new OpenBusRetryContext(this.retryDelay, this.delayUnit));
                    Futures.addCallback(futureRemoval, (FutureCallback)new FutureCallback<Void>(){

                        public void onFailure(Throwable ex) {
                            try {
                                logger.log(Level.SEVERE, "Erro ao remover oferta do barramento.", ex);
                            }
                            catch (Throwable e) {
                                logger.log(Level.SEVERE, "Erro ao completar uma tarefa de remo\u00e7\u00e3o de oferta do OfferRegistry mal-sucedida.", e);
                                throw e;
                            }
                        }

                        public void onSuccess(Void nothing) {
                            try {
                                logger.info("Oferta removida do barramento.");
                            }
                            catch (Throwable e) {
                                logger.log(Level.SEVERE, "Erro ao completar uma tarefa de remo\u00e7\u00e3o de oferta do OfferRegistry bem-sucedida.", e);
                                throw e;
                            }
                        }
                    }, (Executor)this.pool.pool());
                }
            }
            maintainedOffers.remove(offer);
            logger.info("Registro de oferta cancelado com sucesso.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRegistrySubscription(OfferRegistrySubscriptionImpl localSub) {
        java.lang.Object object = this.lock;
        synchronized (object) {
            Map<OfferRegistrySubscriptionImpl, ListenableFuture<OfferRegistryObserverSubscription>> registrySubs = this.registrySubs();
            if (registrySubs == null) {
                return;
            }
            final AtomicBoolean needRemove = new AtomicBoolean(false);
            ListenableFuture<OfferRegistryObserverSubscription> future = registrySubs.get(localSub);
            if (future != null) {
                if (!future.cancel(false)) {
                    needRemove.set(true);
                } else {
                    Futures.addCallback(future, (FutureCallback)new FutureCallback<OfferRegistryObserverSubscription>(){

                        public void onFailure(Throwable ex) {
                        }

                        public void onSuccess(OfferRegistryObserverSubscription remote) {
                            try {
                                needRemove.set(true);
                            }
                            catch (Throwable e) {
                                logger.log(Level.SEVERE, "Erro ao completar uma tarefa de cancelamento de observador de registro de oferta do OfferRegistry bem-sucedida.", e);
                                throw e;
                            }
                        }
                    }, (Executor)this.pool.pool());
                    try {
                        future.get();
                    }
                    catch (Exception exception) {}
                }
            } else if (registrySubs.containsKey(localSub)) {
                needRemove.set(true);
            }
            if (needRemove.get()) {
                OfferRegistryObserverSubscription sub = null;
                if (future != null) {
                    try {
                        sub = future.isDone() ? (OfferRegistryObserverSubscription)future.get() : null;
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        // empty catch block
                    }
                }
                if (sub == null) {
                    sub = localSub.sub();
                }
                if (sub != null) {
                    ListenableFuture<Void> futureRemoval = this.pool.doTask(new OfferRegistrySubRemovalTask(sub), (RetryContext)new OpenBusRetryContext(this.retryDelay, this.delayUnit));
                    Futures.addCallback(futureRemoval, (FutureCallback)new FutureCallback<Void>(){

                        public void onFailure(Throwable ex) {
                            try {
                                logger.log(Level.SEVERE, "Erro ao remover subscri\u00e7\u00e3o de registro de oferta do barramento.", ex);
                            }
                            catch (Throwable e) {
                                logger.log(Level.SEVERE, "Erro ao completar uma tarefa de remo\u00e7\u00e3o de observador de registro de oferta do OfferRegistry mal-sucedida.", e);
                                throw e;
                            }
                        }

                        public void onSuccess(Void nothing) {
                            try {
                                logger.info("Subscri\u00e7\u00e3o de registro de oferta removida do barramento.");
                            }
                            catch (Throwable e) {
                                logger.log(Level.SEVERE, "Erro ao completar uma tarefa de remo\u00e7\u00e3o de observador de registro de oferta do OfferRegistry bem-sucedida.", e);
                                throw e;
                            }
                        }
                    }, (Executor)this.pool.pool());
                }
            }
            registrySubs.remove(localSub);
            try {
                byte[] oid = this.poa.reference_to_id((Object)localSub.proxy);
                this.poa.deactivate_object(oid);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Erro ao desativar um objeto observador de registro de ofertas.", e);
            }
            logger.info("Subscri\u00e7\u00e3o de registro de oferta cancelada com sucesso.");
        }
    }

    protected OfferSubscription subscribeToOffer(RemoteOfferImpl remoteOffer, tecgraf.openbus.OfferObserver observer) throws ServantNotActive, WrongPolicy {
        ServiceOfferDesc offerDesc = remoteOffer.offer();
        if (offerDesc == null || offerDesc.ref == null) {
            throw new ServantNotActive("A oferta aparentemente foi removida.");
        }
        Map<OfferSubscriptionImpl, ListenableFuture<OfferObserverSubscription>> offerSubs = this.offerSubs();
        if (offerSubs == null) {
            return null;
        }
        OfferObserverImpl internalObserver = new OfferObserverImpl(this, observer, remoteOffer);
        OfferObserver proxy = OfferObserverHelper.narrow(this.poa.servant_to_reference((Servant)internalObserver));
        OfferSubscriptionImpl localSub = new OfferSubscriptionImpl(this, remoteOffer, internalObserver, proxy);
        if (!this.doSubscribeToOfferTask(offerSubs, localSub)) {
            return null;
        }
        return localSub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOfferSubscription(OfferSubscriptionImpl localSub) {
        java.lang.Object object = this.lock;
        synchronized (object) {
            Map<OfferSubscriptionImpl, ListenableFuture<OfferObserverSubscription>> offerSubs = this.offerSubs();
            if (offerSubs == null) {
                return;
            }
            final AtomicBoolean needRemove = new AtomicBoolean(false);
            ListenableFuture<OfferObserverSubscription> future = offerSubs.get(localSub);
            if (future != null) {
                if (!future.cancel(false)) {
                    needRemove.set(true);
                } else {
                    Futures.addCallback(future, (FutureCallback)new FutureCallback<OfferObserverSubscription>(){

                        public void onFailure(Throwable ex) {
                        }

                        public void onSuccess(OfferObserverSubscription remote) {
                            try {
                                needRemove.set(true);
                            }
                            catch (Throwable e) {
                                logger.log(Level.SEVERE, "Erro ao completar uma tarefa de cancelamento de observador de oferta do OfferRegistry bem-sucedida.", e);
                                throw e;
                            }
                        }
                    }, (Executor)this.pool.pool());
                    try {
                        future.get();
                    }
                    catch (Exception exception) {}
                }
            } else if (offerSubs.containsKey(localSub)) {
                needRemove.set(true);
            }
            if (needRemove.get()) {
                OfferObserverSubscription sub = null;
                if (future != null) {
                    try {
                        sub = future.isDone() ? (OfferObserverSubscription)future.get() : null;
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        // empty catch block
                    }
                }
                if (sub == null) {
                    sub = localSub.sub();
                }
                if (sub != null) {
                    ListenableFuture<Void> futureRemoval = this.pool.doTask(new OfferSubRemovalTask(sub), (RetryContext)new OpenBusRetryContext(this.retryDelay, this.delayUnit));
                    Futures.addCallback(futureRemoval, (FutureCallback)new FutureCallback<Void>(){

                        public void onFailure(Throwable ex) {
                            try {
                                logger.log(Level.SEVERE, "Erro ao remover subscri\u00e7\u00e3o de oferta do barramento.", ex);
                            }
                            catch (Throwable e) {
                                logger.log(Level.SEVERE, "Erro ao completar uma tarefa de remo\u00e7\u00e3o de observador de oferta do OfferRegistry mal-sucedida.", e);
                                throw e;
                            }
                        }

                        public void onSuccess(Void nothing) {
                            try {
                                logger.info("Subscri\u00e7\u00e3o de oferta removida da oferta no barramento.");
                            }
                            catch (Throwable e) {
                                logger.log(Level.SEVERE, "Erro ao completar uma tarefa de remo\u00e7\u00e3o de observador de oferta do OfferRegistry bem-sucedida.", e);
                                throw e;
                            }
                        }
                    }, (Executor)this.pool.pool());
                }
            }
            offerSubs.remove(localSub);
            try {
                byte[] oid = this.poa.reference_to_id((Object)localSub.proxy);
                this.poa.deactivate_object(oid);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Erro ao desativar um objeto observador de oferta.", e);
            }
            logger.info("Subscri\u00e7\u00e3o de oferta cancelada com sucesso.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onOfferRemove(RemoteOfferImpl offer, boolean localCancelOnly) {
        java.lang.Object object = this.lock;
        synchronized (object) {
            Map<OfferSubscriptionImpl, ListenableFuture<OfferObserverSubscription>> offerSubs = this.offerSubs();
            if (offerSubs == null) {
                return;
            }
            for (Map.Entry<OfferSubscriptionImpl, ListenableFuture<OfferObserverSubscription>> entry : offerSubs.entrySet()) {
                String receivedId = (String)offer.properties(false).get((java.lang.Object)"openbus.offer.id").get(0);
                OfferSubscriptionImpl sub = entry.getKey();
                String iterId = OfferRegistryImpl.getOfferIdFromProperties(sub.offerDesc);
                if (!receivedId.equals(iterId)) continue;
                if (localCancelOnly) {
                    sub.cancel();
                    continue;
                }
                this.clearOfferSubscription(sub);
            }
        }
    }

    protected RetryTaskPool pool() {
        return this.pool;
    }

    protected long interval() {
        return this.retryDelay;
    }

    protected TimeUnit intervalUnit() {
        return this.delayUnit;
    }

    protected void fireEvent(LoginEvent e, LoginInfo newLogin) {
        switch (e) {
            case LOGGED_IN: {
                this.onLogin();
                break;
            }
            case LOGGED_OUT: {
                this.onLogout();
                break;
            }
            case RELOGIN: {
                this.onRelogin(newLogin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLogin() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            Connection prev = this.context.currentConnection();
            try {
                this.context.currentConnection(this.conn);
                this.registry = this.context.getOfferRegistry();
                if (this.maintainedOffers == null) {
                    this.maintainedOffers = new HashMap<LocalOfferImpl, ListenableFuture<RemoteOfferImpl>>();
                }
                if (this.registrySubs == null) {
                    this.registrySubs = new HashMap<OfferRegistrySubscriptionImpl, ListenableFuture<OfferRegistryObserverSubscription>>();
                }
                if (this.offerSubs == null) {
                    this.offerSubs = new HashMap<OfferSubscriptionImpl, ListenableFuture<OfferObserverSubscription>>();
                }
            }
            finally {
                this.context.currentConnection(prev);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLogout() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            this.clearLoginState();
            Connection prev = this.context.currentConnection();
            try {
                this.context.currentConnection(this.conn);
                if (this.maintainedOffers != null) {
                    for (LocalOfferImpl localOfferImpl : this.maintainedOffers.keySet()) {
                        localOfferImpl.loggedOut();
                    }
                    this.maintainedOffers.clear();
                }
                this.maintainedOffers = null;
                if (this.registrySubs != null) {
                    for (OfferRegistrySubscriptionImpl offerRegistrySubscriptionImpl : this.registrySubs.keySet()) {
                        try {
                            offerRegistrySubscriptionImpl.remove();
                        }
                        catch (Exception exception) {}
                    }
                    this.registrySubs.clear();
                }
                this.registrySubs = null;
                if (this.offerSubs != null) {
                    for (OfferSubscriptionImpl offerSubscriptionImpl : this.offerSubs.keySet()) {
                        this.clearOfferSubscription(offerSubscriptionImpl);
                    }
                    this.offerSubs.clear();
                }
                this.offerSubs = null;
                this.lock.notifyAll();
            }
            finally {
                this.context.currentConnection(prev);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLoginState() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            ListenableFuture future;
            if (this.maintainedOffers != null) {
                for (Map.Entry<BusResource, java.lang.Object> entry : this.maintainedOffers.entrySet()) {
                    future = (ListenableFuture)entry.getValue();
                    if (future == null) continue;
                    future.cancel(false);
                    this.maintainedOffers.put((LocalOfferImpl)entry.getKey(), null);
                }
            }
            if (this.registrySubs != null) {
                for (Map.Entry<BusResource, java.lang.Object> entry : this.registrySubs.entrySet()) {
                    future = (ListenableFuture)entry.getValue();
                    if (future == null) continue;
                    future.cancel(false);
                    this.registrySubs.put((OfferRegistrySubscriptionImpl)entry.getKey(), null);
                }
            }
            if (this.offerSubs != null) {
                for (Map.Entry<BusResource, java.lang.Object> entry : this.offerSubs.entrySet()) {
                    future = (ListenableFuture)entry.getValue();
                    if (future == null) continue;
                    future.cancel(false);
                    this.offerSubs.put((OfferSubscriptionImpl)entry.getKey(), null);
                }
            }
            if (this.futureReLogin != null) {
                this.futureReLogin.cancel(false);
            }
            this.registry = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRelogin(LoginInfo newLogin) {
        java.lang.Object object = this.lock;
        synchronized (object) {
            if (!(this.maintainedOffers != null && this.maintainedOffers.size() != 0 || this.registrySubs != null && this.registrySubs.size() != 0 || this.offerSubs != null && this.offerSubs.size() != 0)) {
                return;
            }
            while (this.futureReLogin != null) {
                LoginInfo currLogin;
                this.clearLoginState();
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    this.logInterruptError(e);
                }
                if ((currLogin = this.conn.login()) != null && newLogin.id.equals(currLogin.id)) continue;
                return;
            }
            this.onLogin();
            this.futureReLogin = this.pool.doTask(new ReLoginTask(this.context.getOfferRegistry()), new RetryContext(this.retryDelay, this.delayUnit));
            Futures.addCallback(this.futureReLogin, (FutureCallback)new FutureCallback<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(Void result) {
                    try {
                        java.lang.Object object = OfferRegistryImpl.this.lock;
                        synchronized (object) {
                            if (OfferRegistryImpl.this.futureReLogin != null && !OfferRegistryImpl.this.futureReLogin.isCancelled()) {
                                OfferRegistryImpl.this.futureReLogin = null;
                            }
                            OfferRegistryImpl.this.lock.notifyAll();
                        }
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Erro ao completar uma tarefa de relogin do OfferRegistry bem-sucedida.", e);
                        throw e;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Throwable t) {
                    try {
                        logger.log(Level.WARNING, "Erro ao reinserir registros e observadores de oferta no barramento devido a um logout ou relogin. Esse erro provavelmente pode ser ignorado.", t);
                        java.lang.Object object = OfferRegistryImpl.this.lock;
                        synchronized (object) {
                            OfferRegistryImpl.this.lock.notifyAll();
                        }
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Erro ao completar uma tarefa de relogin do OfferRegistry mal-sucedida.", e);
                        throw e;
                    }
                }
            }, (Executor)this.pool.pool());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOfferSubscription(OfferSubscriptionImpl localSub) {
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            try {
                localSub.remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRegisterTask(tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry registry, final LocalOfferImpl localOffer) {
        java.lang.Object object = this.lock;
        synchronized (object) {
            OfferRegistryTask task = new OfferRegistryTask(localOffer, registry);
            OfferRegistryRetryContext retry = new OfferRegistryRetryContext(this.retryDelay, this.delayUnit, localOffer);
            ListenableFuture<RemoteOfferImpl> futureRegistry = this.pool.doTask(task, (RetryContext)retry);
            this.maintainedOffers.put(localOffer, futureRegistry);
            Futures.addCallback(futureRegistry, (FutureCallback)new FutureCallback<RemoteOfferImpl>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Throwable ex) {
                    try {
                        java.lang.Object object = OfferRegistryImpl.this.lock;
                        synchronized (object) {
                            localOffer.remove();
                            OfferRegistryImpl.this.maintainedOffers.remove(localOffer);
                        }
                        logger.log(Level.SEVERE, "Erro ao registrar oferta no barramento, esse pedido n\u00e3o ser\u00e1 mais mantido pelo SDK.", ex);
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Erro ao completar uma tarefa de registro de oferta do OfferRegistry mal-sucedida.", e);
                        throw e;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(RemoteOfferImpl remote) {
                    try {
                        java.lang.Object object = OfferRegistryImpl.this.lock;
                        synchronized (object) {
                            ListenableFuture future = (ListenableFuture)OfferRegistryImpl.this.maintainedOffers.get(localOffer);
                            if (future != null) {
                                OfferRegistryImpl.this.maintainedOffers.put(localOffer, null);
                                localOffer.remote(remote);
                                logger.info("Registro de oferta realizado com sucesso.");
                            }
                        }
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Erro ao completar uma tarefa de registro de oferta do OfferRegistry bem-sucedida.", e);
                        throw e;
                    }
                }
            }, (Executor)this.pool.pool());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSubscribeToRegistryTask(tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry registry, final OfferRegistrySubscriptionImpl localSub) {
        java.lang.Object object = this.lock;
        synchronized (object) {
            final Map<OfferRegistrySubscriptionImpl, ListenableFuture<OfferRegistryObserverSubscription>> registrySubs = this.registrySubs();
            if (registrySubs == null) {
                return false;
            }
            OfferRegistrySubscriptionTask task = new OfferRegistrySubscriptionTask(registry, localSub.proxy, OfferRegistryImpl.convertMapToProperties(localSub.properties()));
            ListenableFuture<OfferRegistryObserverSubscription> futureRegistrySub = this.pool.doTask(task, (RetryContext)new OfferRegistrySubscriptionRetryContext(this.retryDelay, this.delayUnit, localSub));
            registrySubs.put(localSub, futureRegistrySub);
            Futures.addCallback(futureRegistrySub, (FutureCallback)new FutureCallback<OfferRegistryObserverSubscription>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Throwable ex) {
                    try {
                        java.lang.Object object = OfferRegistryImpl.this.lock;
                        synchronized (object) {
                            localSub.remove();
                        }
                        logger.log(Level.SEVERE, "Erro ao inserir um observador de registro de oferta no barramento.", ex);
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Erro ao completar uma tarefa de subscri\u00e7\u00e3o de observador de registro de oferta do OfferRegistry mal-sucedida.", e);
                        throw e;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(OfferRegistryObserverSubscription sub) {
                    try {
                        java.lang.Object object = OfferRegistryImpl.this.lock;
                        synchronized (object) {
                            localSub.sub(sub);
                            registrySubs.put(localSub, null);
                            logger.info("Observador de registro de ofertas cadastrado no barramento.");
                        }
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Erro ao completar uma tarefa de subscri\u00e7\u00e3o de observador de registro de oferta do OfferRegistry bem-sucedida.", e);
                        throw e;
                    }
                }
            }, (Executor)this.pool.pool());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSubscribeToOfferTask(final Map<OfferSubscriptionImpl, ListenableFuture<OfferObserverSubscription>> offerSubs, final OfferSubscriptionImpl localSub) {
        java.lang.Object object = this.lock;
        synchronized (object) {
            if (localSub.offerDesc == null) {
                return false;
            }
            OfferSubscriptionTask task = new OfferSubscriptionTask(localSub.offerDesc.ref, localSub.proxy);
            ListenableFuture<OfferObserverSubscription> futureOfferSub = this.pool.doTask(task, (RetryContext)new OfferSubscriptionRetryContext(this.retryDelay, this.delayUnit, localSub));
            offerSubs.put(localSub, futureOfferSub);
            Futures.addCallback(futureOfferSub, (FutureCallback)new FutureCallback<OfferObserverSubscription>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Throwable ex) {
                    try {
                        java.lang.Object object = OfferRegistryImpl.this.lock;
                        synchronized (object) {
                            localSub.remove();
                        }
                        logger.log(Level.SEVERE, "Erro ao inserir um observador de oferta no barramento", ex);
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Erro ao completar uma tarefa de subscri\u00e7\u00e3o de observador de oferta do OfferRegistry mal-sucedida.", e);
                        throw e;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(OfferObserverSubscription sub) {
                    try {
                        java.lang.Object object = OfferRegistryImpl.this.lock;
                        synchronized (object) {
                            localSub.sub(sub);
                            offerSubs.put(localSub, null);
                            logger.info("Observador de oferta cadastrado no barramento.");
                        }
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Erro ao completar uma tarefa de subscri\u00e7\u00e3o de observador de oferta do OfferRegistry bem-sucedida.", e);
                        throw e;
                    }
                }
            }, (Executor)this.pool.pool());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<LocalOfferImpl, ListenableFuture<RemoteOfferImpl>> maintainedOffers() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            while (this.maintainedOffers == null) {
                if (this.futureReLogin == null) {
                    logger.severe("N\u00e3o h\u00e1 login para realizar a chamada.");
                    throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    this.logInterruptError(e);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            return this.maintainedOffers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<OfferRegistrySubscriptionImpl, ListenableFuture<OfferRegistryObserverSubscription>> registrySubs() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            while (this.registrySubs == null) {
                if (this.futureReLogin == null) {
                    logger.severe("N\u00e3o h\u00e1 login para realizar a chamada.");
                    throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    this.logInterruptError(e);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            return this.registrySubs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<OfferSubscriptionImpl, ListenableFuture<OfferObserverSubscription>> offerSubs() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            while (this.offerSubs == null) {
                if (this.futureReLogin == null) {
                    logger.severe("N\u00e3o h\u00e1 login para realizar a chamada.");
                    throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    this.logInterruptError(e);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            return this.offerSubs;
        }
    }

    private void logInterruptError(Exception e) {
        logger.log(Level.SEVERE, "Interrup\u00e7\u00e3o n\u00e3o esperada ao refazer um login. Verifique se sua aplica\u00e7\u00e3o est\u00e1 tentando interromper a thread quando esta est\u00e1 executando c\u00f3digo alheio, como do SDK OpenBus ou do JacORB.", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry registry() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            while (this.registry == null) {
                if (this.futureReLogin == null) {
                    logger.severe("N\u00e3o h\u00e1 login para realizar a chamada.");
                    throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    this.logInterruptError(e);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            return this.registry;
        }
    }

    protected static LoginInfo getOwnerFromOffer(ServiceOfferDesc desc) {
        ServiceProperty[] props = desc.properties;
        LoginInfo info = new LoginInfo();
        boolean foundId = false;
        boolean foundEntity = false;
        for (ServiceProperty prop : props) {
            if (prop.name.equals("openbus.offer.login")) {
                info.id = prop.value;
                foundId = true;
            }
            if (prop.name.equals("openbus.offer.entity")) {
                info.entity = prop.value;
                foundEntity = true;
            }
            if (foundId && foundEntity) break;
        }
        return info;
    }

    protected static String getOfferIdFromProperties(ServiceOfferDesc desc) {
        ServiceProperty[] props;
        for (ServiceProperty prop : props = desc.properties) {
            if (!prop.name.equals("openbus.offer.id")) continue;
            return prop.value;
        }
        return "";
    }

    protected static ServiceProperty[] convertMapToProperties(ArrayListMultimap<String, String> properties) {
        ServiceProperty[] props = new ServiceProperty[properties.size()];
        int i = 0;
        for (Map.Entry entry : properties.entries()) {
            props[i] = new ServiceProperty((String)entry.getKey(), (String)entry.getValue());
            ++i;
        }
        return props;
    }

    private class ReLoginTask
    implements Callable<Void> {
        private final tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry registry;

        public ReLoginTask(tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry registry) {
            this.registry = registry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            OfferRegistryImpl.this.context.currentConnection(OfferRegistryImpl.this.conn);
            java.lang.Object object = OfferRegistryImpl.this.lock;
            synchronized (object) {
                BusResource localSub;
                ListenableFuture future;
                for (Map.Entry entry : OfferRegistryImpl.this.maintainedOffers.entrySet()) {
                    LocalOfferImpl offer = (LocalOfferImpl)entry.getKey();
                    offer.removeOffer();
                    future = (ListenableFuture)entry.getValue();
                    if (future != null && !future.isCancelled()) continue;
                    OfferRegistryImpl.this.doRegisterTask(this.registry, offer);
                }
                for (Map.Entry entry : OfferRegistryImpl.this.registrySubs.entrySet()) {
                    localSub = (OfferRegistrySubscriptionImpl)entry.getKey();
                    ((OfferRegistrySubscriptionImpl)localSub).removeSub();
                    future = (ListenableFuture)entry.getValue();
                    if (future != null && !future.isCancelled()) continue;
                    OfferRegistryImpl.this.doSubscribeToRegistryTask(OfferRegistryImpl.this.context.getOfferRegistry(), (OfferRegistrySubscriptionImpl)localSub);
                }
                for (Map.Entry entry : OfferRegistryImpl.this.offerSubs.entrySet()) {
                    localSub = (OfferSubscriptionImpl)entry.getKey();
                    future = (ListenableFuture)entry.getValue();
                    if (future != null && !future.isCancelled() || OfferRegistryImpl.this.doSubscribeToOfferTask(OfferRegistryImpl.this.offerSubs, (OfferSubscriptionImpl)localSub)) continue;
                    ((OfferSubscriptionImpl)localSub).remove();
                }
            }
            return null;
        }
    }

    private class OfferSubscriptionTask
    implements Callable<OfferObserverSubscription> {
        private final OfferObserver observer;
        private final ServiceOffer offer;

        public OfferSubscriptionTask(ServiceOffer offer, OfferObserver observer) {
            this.offer = offer;
            this.observer = observer;
        }

        @Override
        public OfferObserverSubscription call() throws ServiceFailure {
            try {
                OfferRegistryImpl.this.context.currentConnection(OfferRegistryImpl.this.conn);
                return this.offer.subscribeObserver(this.observer);
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                return null;
            }
        }
    }

    private class OfferRegistrySubscriptionTask
    implements Callable<OfferRegistryObserverSubscription> {
        private final tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry registry;
        private final OfferRegistryObserver observer;
        private final ServiceProperty[] properties;

        public OfferRegistrySubscriptionTask(tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry registry, OfferRegistryObserver observer, ServiceProperty[] properties) {
            this.registry = registry;
            this.observer = observer;
            this.properties = properties;
        }

        @Override
        public OfferRegistryObserverSubscription call() throws ServiceFailure {
            OfferRegistryImpl.this.context.currentConnection(OfferRegistryImpl.this.conn);
            return this.registry.subscribeObserver(this.observer, this.properties);
        }
    }

    private class OfferSubRemovalTask
    implements Callable<Void> {
        private final OfferObserverSubscription sub;

        public OfferSubRemovalTask(OfferObserverSubscription sub) {
            this.sub = sub;
        }

        @Override
        public Void call() throws ServiceFailure, UnauthorizedOperation {
            try {
                OfferRegistryImpl.this.context.currentConnection(OfferRegistryImpl.this.conn);
                this.sub.remove();
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                // empty catch block
            }
            return null;
        }
    }

    private class OfferRegistrySubRemovalTask
    implements Callable<Void> {
        private final OfferRegistryObserverSubscription sub;

        public OfferRegistrySubRemovalTask(OfferRegistryObserverSubscription sub) {
            this.sub = sub;
        }

        @Override
        public Void call() throws ServiceFailure, UnauthorizedOperation {
            try {
                OfferRegistryImpl.this.context.currentConnection(OfferRegistryImpl.this.conn);
                this.sub.remove();
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                // empty catch block
            }
            return null;
        }
    }

    private class OfferRemovalTask
    implements Callable<Void> {
        private final RemoteOfferImpl remote;

        public OfferRemovalTask(RemoteOfferImpl remote) {
            this.remote = remote;
        }

        @Override
        public Void call() throws ServiceFailure, UnauthorizedOperation {
            try {
                OfferRegistryImpl.this.context.currentConnection(OfferRegistryImpl.this.conn);
                this.remote.remove();
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                // empty catch block
            }
            return null;
        }
    }

    private class OfferRegistryTask
    implements Callable<RemoteOfferImpl> {
        private final LocalOfferImpl local;
        private final tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry registry;

        public OfferRegistryTask(LocalOfferImpl local, tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry registry) {
            this.local = local;
            this.registry = registry;
        }

        @Override
        public RemoteOfferImpl call() throws ServiceFailure, InvalidService, InvalidProperties, UnauthorizedFacets {
            OfferRegistryImpl.this.context.currentConnection(OfferRegistryImpl.this.conn);
            ServiceOfferDesc offer = this.registry.registerService(this.local.service, this.local.props).describe();
            return new RemoteOfferImpl(OfferRegistryImpl.this, offer);
        }
    }
}

