/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import tecgraf.openbus.core.ORBInitializerInfo;
import tecgraf.openbus.core.OpenBusContextImpl;

final class ORBBuilder {
    private final String[] args;
    private final Properties props;
    private static final Logger logger = Logger.getLogger(ORBBuilder.class.getName());

    public ORBBuilder() {
        this(null, null);
    }

    public ORBBuilder(String[] args) {
        this(args, null);
    }

    public ORBBuilder(Properties props) {
        this(null, props);
    }

    public ORBBuilder(String[] args, Properties props) {
        this.args = args;
        this.props = new Properties();
        this.props.put("jacorb.connection.client.disconnect_after_systemexception", (Object)false);
        if (props != null) {
            this.props.putAll((Map<?, ?>)props);
        }
        this.props.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
    }

    public void addInitializer(ORBInitializerInfo initializer) {
        this.props.put("org.omg.PortableInterceptor.ORBInitializerClass." + initializer.getId(), initializer.getClassName());
    }

    public ORB build() {
        ORB orb = ORB.init((String[])this.args, (Properties)this.props);
        try {
            OpenBusContextImpl context = (OpenBusContextImpl)orb.resolve_initial_references("OpenBusContext");
            context.ORB(orb);
            context.POA(null);
        }
        catch (InvalidName e) {
            String message = "Falha inesperada ao registrar o POA no multiplexador";
            logger.log(Level.SEVERE, message, e);
            throw new INITIALIZE(message);
        }
        return orb;
    }
}

