/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import tecgraf.openbus.Connection;
import tecgraf.openbus.LoginObserver;
import tecgraf.openbus.LoginSubscription;
import tecgraf.openbus.core.ConnectionImpl;
import tecgraf.openbus.core.LoginEvent;
import tecgraf.openbus.core.LoginSubscriptionImpl;
import tecgraf.openbus.core.OpenBusContextImpl;
import tecgraf.openbus.core.OpenBusRetryContext;
import tecgraf.openbus.core.v2_1.OctetSeqHolder;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.UnauthorizedOperation;
import tecgraf.openbus.core.v2_1.services.access_control.InvalidLogins;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_1.services.access_control.LoginObserverHelper;
import tecgraf.openbus.core.v2_1.services.access_control.LoginObserverPOA;
import tecgraf.openbus.core.v2_1.services.access_control.LoginObserverSubscription;
import tecgraf.openbus.core.v2_1.services.access_control.LoginRegistry;
import tecgraf.openbus.retry.RetryContext;
import tecgraf.openbus.retry.RetryTaskPool;

class LoginRegistryImpl
extends LoginObserverPOA
implements tecgraf.openbus.LoginRegistry {
    private final OpenBusContextImpl context;
    private final ConnectionImpl conn;
    private final POA poa;
    private final java.lang.Object lock = new java.lang.Object();
    private LoginRegistry registry;
    private final RetryTaskPool pool;
    private tecgraf.openbus.core.v2_1.services.access_control.LoginObserver observer;
    private ListenableFuture<LoginObserverSubscription> futureSub;
    private ListenableFuture<Void> futureRemove;
    private ListenableFuture<LoginObserverSubscription> futureReLogin;
    private LoginObserverSubscription sub;
    private List<LoginSubscriptionImpl> subs;
    private final long retryDelay;
    private final TimeUnit delayUnit;
    private static final Logger logger = Logger.getLogger(LoginRegistryImpl.class.getName());

    protected LoginRegistryImpl(OpenBusContextImpl context, ConnectionImpl conn, POA poa, RetryTaskPool pool, long interval, TimeUnit unit) {
        this.context = context;
        this.conn = conn;
        this.poa = poa;
        this.pool = pool;
        this.retryDelay = interval;
        this.delayUnit = unit;
    }

    @Override
    public Connection connection() {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LoginInfo> allLogins() throws ServiceFailure, UnauthorizedOperation {
        LoginRegistry registry = this.registry();
        if (registry == null) {
            return new ArrayList<LoginInfo>();
        }
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            List<LoginInfo> list = LoginRegistryImpl.convertLoginArrayToList(registry.getAllLogins());
            return list;
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LoginInfo> entityLogins(String entity) throws ServiceFailure, UnauthorizedOperation {
        LoginRegistry registry = this.registry();
        if (registry == null) {
            return new ArrayList<LoginInfo>();
        }
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            List<LoginInfo> list = LoginRegistryImpl.convertLoginArrayToList(registry.getEntityLogins(entity));
            return list;
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invalidateLogin(String loginId) throws ServiceFailure, UnauthorizedOperation {
        LoginRegistry registry = this.registry();
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            boolean bl = registry != null && registry.invalidateLogin(loginId);
            return bl;
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoginInfo loginInfo(String loginId, OctetSeqHolder pubkey) throws InvalidLogins, ServiceFailure {
        LoginRegistry registry = this.registry();
        if (registry == null) {
            return new LoginInfo();
        }
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            LoginInfo loginInfo = registry.getLoginInfo(loginId, pubkey);
            return loginInfo;
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int loginValidity(String loginId) throws ServiceFailure {
        LoginRegistry registry = this.registry();
        if (registry == null) {
            return -1;
        }
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            int n = registry.getLoginValidity(loginId);
            return n;
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoginSubscription subscribeObserver(LoginObserver callback) throws ServantNotActive, WrongPolicy {
        LoginRegistry registry = this.registry();
        if (registry == null) {
            return null;
        }
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            LoginSubscriptionImpl ret = new LoginSubscriptionImpl(callback, this);
            java.lang.Object object = this.lock;
            synchronized (object) {
                List<LoginSubscriptionImpl> subs;
                block11: {
                    subs = this.subs();
                    if (subs != null) break block11;
                    LoginSubscription loginSubscription = null;
                    return loginSubscription;
                }
                subs.add(ret);
                if (this.sub == null) {
                    if (this.observer == null) {
                        this.observer = LoginObserverHelper.narrow(this.poa.servant_to_reference((Servant)this));
                    }
                    ReLoginTask task = new ReLoginTask(registry, this.observer, null);
                    this.futureSub = this.pool.doTask(task, new RetryContext(this.retryDelay, this.delayUnit));
                    Futures.addCallback(this.futureSub, (FutureCallback)new FutureCallback<LoginObserverSubscription>(){

                        public void onFailure(Throwable ex) {
                            try {
                                logger.log(Level.SEVERE, "Erro ao inserir o observador de logins no barramento.", ex);
                                LoginRegistryImpl.this.lock.notifyAll();
                            }
                            catch (Throwable e) {
                                logger.log(Level.SEVERE, "Erro ao completar uma tarefa de subscri\u00e7\u00e3o de observador de login do LoginRegistry mal-sucedida.", e);
                                throw e;
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onSuccess(LoginObserverSubscription sub) {
                            try {
                                java.lang.Object object = LoginRegistryImpl.this.lock;
                                synchronized (object) {
                                    LoginRegistryImpl.this.sub = sub;
                                    LoginRegistryImpl.this.futureSub = null;
                                    LoginRegistryImpl.this.lock.notifyAll();
                                    logger.info("Observador de logins cadastrado no barramento.");
                                }
                            }
                            catch (Throwable e) {
                                logger.log(Level.SEVERE, "Erro ao completar uma tarefa de subscri\u00e7\u00e3o de observador de login do LoginRegistry bem-sucedida.", e);
                                throw e;
                            }
                        }
                    }, (Executor)this.pool.pool());
                }
            }
            object = ret;
            return object;
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void entityLogout(LoginInfo login) {
        ArrayList<LoginSubscriptionImpl> subs;
        java.lang.Object object = this.lock;
        synchronized (object) {
            if (this.subs == null) {
                return;
            }
            subs = new ArrayList<LoginSubscriptionImpl>(this.subs);
        }
        Thread t = new Thread(() -> {
            this.context.currentConnection(this.conn);
            for (LoginSubscriptionImpl sub1 : subs) {
                try {
                    sub1.observer().entityLogout(login);
                    sub1.forgetLogin(login.id);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Erro ao avisar um observador da aplica\u00e7\u00e3o de que o login " + login.id + " da entidade " + login.entity + " foi desfeito.", e);
                }
            }
        });
        t.start();
    }

    protected void fireEvent(LoginEvent e, LoginInfo newLogin) {
        switch (e) {
            case LOGGED_IN: {
                this.onLogin();
                break;
            }
            case LOGGED_OUT: {
                this.onLogout();
                break;
            }
            case RELOGIN: {
                this.onRelogin(newLogin);
            }
        }
    }

    protected boolean watchLogin(String loginId) throws ServiceFailure {
        LoginObserverSubscription sub = this.sub();
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            while (true) {
                try {
                    boolean bl = sub != null && sub.watchLogin(loginId);
                    return bl;
                }
                catch (OBJECT_NOT_EXIST e) {
                    sub = this.sub();
                    continue;
                }
                break;
            }
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forgetLogin(String loginId) throws ServiceFailure {
        LoginObserverSubscription sub = this.sub();
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            while (true) {
                block8: {
                    try {
                        if (sub != null) break block8;
                        return;
                    }
                    catch (OBJECT_NOT_EXIST e) {
                        sub = this.sub();
                        continue;
                    }
                }
                sub.forgetLogin(loginId);
                break;
            }
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void watchLogins(List<String> loginIds) throws ServiceFailure, InvalidLogins {
        LoginObserverSubscription sub = this.sub();
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            while (true) {
                block8: {
                    try {
                        if (sub != null) break block8;
                        return;
                    }
                    catch (OBJECT_NOT_EXIST e) {
                        sub = this.sub();
                        continue;
                    }
                }
                sub.watchLogins(loginIds.toArray(new String[loginIds.size()]));
                break;
            }
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forgetLogins(List<String> loginIds) throws ServiceFailure {
        LoginObserverSubscription sub = this.sub();
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            while (true) {
                block8: {
                    try {
                        if (sub != null) break block8;
                        return;
                    }
                    catch (OBJECT_NOT_EXIST e) {
                        sub = this.sub();
                        continue;
                    }
                }
                sub.forgetLogins(loginIds.toArray(new String[loginIds.size()]));
                break;
            }
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    protected List<LoginInfo> getWatchedLogins() {
        LoginObserverSubscription sub = this.sub();
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this.conn);
            while (true) {
                block8: {
                    try {
                        if (sub != null) break block8;
                        ArrayList<LoginInfo> arrayList = new ArrayList<LoginInfo>();
                        return arrayList;
                    }
                    catch (OBJECT_NOT_EXIST e) {
                        sub = this.sub();
                        continue;
                    }
                }
                List<LoginInfo> list = LoginRegistryImpl.convertLoginArrayToList(sub.getWatchedLogins());
                return list;
            }
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(LoginSubscriptionImpl localSub) {
        java.lang.Object object = this.lock;
        synchronized (object) {
            List<LoginSubscriptionImpl> subs = this.subs();
            if (subs == null) {
                return;
            }
            subs.remove(localSub);
            if (subs.isEmpty()) {
                final AtomicBoolean needRemove = new AtomicBoolean(false);
                if (this.futureSub != null) {
                    if (!this.futureSub.cancel(false)) {
                        needRemove.set(true);
                    } else {
                        Futures.addCallback(this.futureSub, (FutureCallback)new FutureCallback<LoginObserverSubscription>(){

                            public void onFailure(Throwable ex) {
                            }

                            public void onSuccess(LoginObserverSubscription remote) {
                                try {
                                    needRemove.set(true);
                                }
                                catch (Throwable e) {
                                    logger.log(Level.SEVERE, "Erro ao completar uma tarefa de remo\u00e7\u00e3o de observador de login do LoginRegistry bem-sucedida.", e);
                                    throw e;
                                }
                            }
                        }, (Executor)this.pool.pool());
                    }
                } else {
                    needRemove.set(true);
                }
                if (needRemove.get()) {
                    LoginObserverSubscription sub = this.sub();
                    if (sub == null) {
                        return;
                    }
                    LoginSubRemovalTask task = new LoginSubRemovalTask(sub);
                    this.futureRemove = this.pool.doTask(task, (RetryContext)new OpenBusRetryContext(this.retryDelay, this.delayUnit));
                    Futures.addCallback(this.futureRemove, (FutureCallback)new FutureCallback<Void>(){

                        public void onFailure(Throwable ex) {
                            try {
                                logger.log(Level.SEVERE, "Erro ao remover o observador de logins do barramento.", ex);
                            }
                            catch (Throwable e) {
                                logger.log(Level.SEVERE, "Erro ao completar uma tarefa de remo\u00e7\u00e3o de observador de login do LoginRegistry mal-sucedida.", e);
                                throw e;
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onSuccess(Void nothing) {
                            try {
                                java.lang.Object object = LoginRegistryImpl.this.lock;
                                synchronized (object) {
                                    LoginRegistryImpl.this.futureSub = null;
                                    LoginRegistryImpl.this.futureRemove = null;
                                }
                                logger.info("Observador de login removido do barramento.");
                            }
                            catch (Throwable e) {
                                logger.log(Level.SEVERE, "Erro ao completar uma tarefa de remo\u00e7\u00e3o de observador de login do LoginRegistry bem-sucedida.", e);
                                throw e;
                            }
                        }
                    }, (Executor)this.pool.pool());
                    this.deactivateObserver();
                }
            }
        }
    }

    protected RetryTaskPool pool() {
        return this.pool;
    }

    protected long interval() {
        return this.retryDelay;
    }

    protected TimeUnit intervalUnit() {
        return this.delayUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLogin() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            Connection prev = this.context.currentConnection();
            try {
                this.context.currentConnection(this.conn);
                this.registry = this.context.getLoginRegistry();
                if (this.subs == null) {
                    this.subs = new ArrayList<LoginSubscriptionImpl>();
                }
                this.lock.notifyAll();
            }
            finally {
                this.context.currentConnection(prev);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLogout() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            this.clearLoginState();
            if (this.subs != null) {
                this.subs.clear();
            }
            this.subs = null;
            this.deactivateObserver();
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateObserver() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            if (this.observer != null) {
                try {
                    byte[] oid = this.poa.reference_to_id((Object)this.observer);
                    this.poa.deactivate_object(oid);
                    this.observer = null;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Erro ao desativar o objeto observador de logins.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLoginState() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            this.registry = null;
            this.sub = null;
            if (this.futureSub != null) {
                this.futureSub.cancel(false);
            }
            this.futureSub = null;
            if (this.futureRemove != null) {
                this.futureRemove.cancel(false);
            }
            this.futureRemove = null;
            if (this.futureReLogin != null) {
                this.futureReLogin.cancel(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRelogin(LoginInfo newLogin) {
        java.lang.Object object = this.lock;
        synchronized (object) {
            if (this.subs == null || this.subs.size() == 0) {
                return;
            }
            while (this.futureReLogin != null) {
                LoginInfo currLogin;
                this.clearLoginState();
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    this.logInterruptError(e);
                }
                if ((currLogin = this.conn.login()) != null && newLogin.id.equals(currLogin.id)) continue;
                return;
            }
            this.onLogin();
            HashSet<String> watchedLogins = new HashSet<String>();
            for (LoginSubscriptionImpl sub : this.subs) {
                watchedLogins.addAll(sub.loginsCopy());
            }
            this.futureReLogin = this.pool.doTask(new ReLoginTask(this.registry, this.observer, watchedLogins), new RetryContext(this.retryDelay, this.delayUnit));
            Futures.addCallback(this.futureReLogin, (FutureCallback)new FutureCallback<LoginObserverSubscription>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(LoginObserverSubscription result) {
                    try {
                        java.lang.Object object = LoginRegistryImpl.this.lock;
                        synchronized (object) {
                            if (LoginRegistryImpl.this.futureReLogin != null && !LoginRegistryImpl.this.futureReLogin.isCancelled()) {
                                if (result != null) {
                                    LoginRegistryImpl.this.sub = result;
                                }
                                LoginRegistryImpl.this.futureReLogin = null;
                            }
                            LoginRegistryImpl.this.lock.notifyAll();
                        }
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Erro ao completar uma tarefa de relogin do LoginRegistry bem-sucedida.", e);
                        throw e;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Throwable t) {
                    try {
                        logger.log(Level.WARNING, "Erro ao reinserir o observador de logins do barramento devido a um logout ou relogin. Esse erro provavelmente pode ser ignorado.", t);
                        java.lang.Object object = LoginRegistryImpl.this.lock;
                        synchronized (object) {
                            LoginRegistryImpl.this.lock.notifyAll();
                        }
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Erro ao completar uma tarefa de relogin do LoginRegistry mal-sucedida.", e);
                        throw e;
                    }
                }
            }, (Executor)this.pool.pool());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginRegistry registry() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            while (this.registry == null) {
                if (this.futureReLogin == null) {
                    logger.severe("N\u00e3o h\u00e1 login para realizar a chamada.");
                    throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    this.logInterruptError(e);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            return this.registry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginObserverSubscription sub() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            while (this.sub == null) {
                if (this.futureReLogin == null) {
                    if (this.futureSub != null) {
                        if (this.futureSub.isCancelled()) {
                            throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
                        }
                        if (this.futureSub.isDone()) {
                            throw new OBJECT_NOT_EXIST("A subscri\u00e7\u00e3o foi removida do barramento por uma a\u00e7\u00e3o diferente de um logout ou relogin.");
                        }
                    } else {
                        throw new OBJECT_NOT_EXIST("A subscri\u00e7\u00e3o foi removida do barramento por uma a\u00e7\u00e3o diferente de um logout ou relogin.");
                    }
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    this.logInterruptError(e);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            return this.sub;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LoginSubscriptionImpl> subs() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            while (this.subs == null) {
                if (this.futureReLogin == null) {
                    logger.severe("N\u00e3o h\u00e1 login para realizar a chamada.");
                    throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    this.logInterruptError(e);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            return this.subs;
        }
    }

    private void logInterruptError(Exception e) {
        logger.log(Level.SEVERE, "Interrup\u00e7\u00e3o n\u00e3o esperada ao refazer um login. Verifique se sua aplica\u00e7\u00e3o est\u00e1 tentando interromper a thread quando esta est\u00e1 executando c\u00f3digo alheio, como do SDK OpenBus ou do JacORB.", e);
    }

    private static List<LoginInfo> convertLoginArrayToList(LoginInfo[] infos) {
        ArrayList<LoginInfo> ret = new ArrayList<LoginInfo>();
        Collections.addAll(ret, infos);
        return ret;
    }

    private class ReLoginTask
    implements Callable<LoginObserverSubscription> {
        private final LoginRegistry registry;
        private final tecgraf.openbus.core.v2_1.services.access_control.LoginObserver observer;
        private final Set<String> watchedLogins;

        public ReLoginTask(LoginRegistry registry, tecgraf.openbus.core.v2_1.services.access_control.LoginObserver observer, Set<String> watchedLogins) {
            this.registry = registry;
            this.observer = observer;
            this.watchedLogins = watchedLogins;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LoginObserverSubscription call() throws ServiceFailure {
            LoginRegistryImpl.this.context.currentConnection(LoginRegistryImpl.this.conn);
            LoginObserverSubscription sub = this.registry.subscribeObserver(this.observer);
            java.lang.Object object = LoginRegistryImpl.this.lock;
            synchronized (object) {
                if (this.watchedLogins != null) {
                    try {
                        sub.watchLogins(this.watchedLogins.toArray(new String[this.watchedLogins.size()]));
                    }
                    catch (InvalidLogins e) {
                        java.lang.Object object2 = LoginRegistryImpl.this.lock;
                        synchronized (object2) {
                            List subs = LoginRegistryImpl.this.subs();
                            if (subs != null) {
                                for (LoginSubscriptionImpl loginSubscription : subs) {
                                    Thread t = new Thread(() -> loginSubscription.nonExistentLogins(e.loginIds));
                                    t.start();
                                }
                            }
                        }
                        logger.log(Level.WARNING, "Alguns logins n\u00e3o puderam ser re-observados pois sa\u00edram do barramento.", (Throwable)((java.lang.Object)e));
                    }
                    catch (OBJECT_NOT_EXIST e) {
                        sub = null;
                    }
                    catch (Exception e) {
                        try {
                            sub.remove();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw e;
                    }
                }
            }
            return sub;
        }
    }

    private class LoginSubRemovalTask
    implements Callable<Void> {
        private final LoginObserverSubscription sub;

        public LoginSubRemovalTask(LoginObserverSubscription sub) {
            this.sub = sub;
        }

        @Override
        public Void call() throws ServiceFailure {
            try {
                LoginRegistryImpl.this.context.currentConnection(LoginRegistryImpl.this.conn);
                this.sub.remove();
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                // empty catch block
            }
            return null;
        }
    }
}

