/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import scs.core.IComponent;
import tecgraf.openbus.Connection;
import tecgraf.openbus.LocalOffer;
import tecgraf.openbus.RemoteOffer;
import tecgraf.openbus.core.BusResource;
import tecgraf.openbus.core.OfferRegistryImpl;
import tecgraf.openbus.core.RemoteOfferImpl;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.offer_registry.InvalidProperties;
import tecgraf.openbus.core.v2_1.services.offer_registry.InvalidService;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceProperty;
import tecgraf.openbus.core.v2_1.services.offer_registry.UnauthorizedFacets;
import tecgraf.openbus.exception.OpenBusInternalException;

class LocalOfferImpl
extends BusResource
implements LocalOffer {
    public final IComponent service;
    public final ServiceProperty[] props;
    private final OfferRegistryImpl registry;
    private RemoteOfferImpl remote = null;
    private static final Logger logger = Logger.getLogger(LocalOfferImpl.class.getName());

    protected LocalOfferImpl(OfferRegistryImpl registry, IComponent service, ServiceProperty[] props) {
        this.registry = registry;
        this.service = service;
        this.props = props;
    }

    @Override
    public Connection connection() {
        return this.registry.connection();
    }

    @Override
    public RemoteOffer remoteOffer() throws ServiceFailure, InvalidService, InvalidProperties, UnauthorizedFacets {
        while (true) {
            try {
                return this.remoteOffer(Integer.MAX_VALUE);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteOffer remoteOffer(long timeoutMillis) throws ServiceFailure, InvalidService, InvalidProperties, UnauthorizedFacets, TimeoutException {
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("O timeout deve ser positivo.");
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.remote == null && this.lastError == null && timeoutMillis >= 0L) {
                long initial = System.currentTimeMillis();
                this.checkLoggedOut();
                if (this.cancelled) {
                    return null;
                }
                try {
                    if (timeoutMillis > 0L) {
                        this.lock.wait(timeoutMillis);
                    }
                }
                catch (InterruptedException e) {
                    this.logInterruptError(logger, e);
                    Thread.currentThread().interrupt();
                    return null;
                }
                timeoutMillis -= System.currentTimeMillis() - initial;
            }
            this.checkLoggedOut();
            if (this.cancelled) {
                return null;
            }
            if (this.remote == null) {
                if (this.lastError == null) {
                    throw new TimeoutException("N\u00e3o foi poss\u00edvel obter a oferta remota no tempo especificado.");
                }
                try {
                    throw this.lastError;
                }
                catch (Error | RuntimeException | ServiceFailure | InvalidProperties | InvalidService | UnauthorizedFacets e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new OpenBusInternalException("Exce\u00e7\u00e3o inesperada ao tentar registrar uma oferta. Por favor contacte o administrador do sistema e informe-o sobre este erro.", e);
                }
            }
            return this.remote;
        }
    }

    @Override
    public void remove() {
        this.cancel();
        this.registry.cancelRegisterTask(this);
        this.removeOffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void error(Throwable error) {
        Object object = this.lock;
        synchronized (object) {
            this.remote = null;
            super.error(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loggedOut() {
        Object object = this.lock;
        synchronized (object) {
            super.loggedOut();
            this.removeOffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remote(RemoteOfferImpl remote) {
        Object object = this.lock;
        synchronized (object) {
            this.remote = remote;
            this.lastError = null;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOffer() {
        Object object = this.lock;
        synchronized (object) {
            if (this.remote != null) {
                this.remote.removed();
                this.remote = null;
            }
            this.lastError = null;
            this.lock.notifyAll();
        }
    }
}

