/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import tecgraf.openbus.core.InterceptorImpl;
import tecgraf.openbus.core.v2_0.credential.CredentialDataHelper;
import tecgraf.openbus.core.v2_0.credential.SignedCallChain;
import tecgraf.openbus.core.v2_0.services.access_control.CallChain;
import tecgraf.openbus.core.v2_1.credential.CredentialData;
import tecgraf.openbus.core.v2_1.credential.CredentialReset;
import tecgraf.openbus.core.v2_1.credential.CredentialResetHelper;
import tecgraf.openbus.core.v2_1.credential.SignedData;
import tecgraf.openbus.core.v2_1.services.access_control.CallChainHelper;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;

class Credential {
    public final String bus;
    public final String login;
    public final int session;
    public final int ticket;
    public final byte[] hash;
    public final Chain chain;
    public Boolean legacy = null;

    Credential(CredentialData credential) {
        this.legacy = false;
        this.bus = credential.bus;
        this.login = credential.login;
        this.session = credential.session;
        this.ticket = credential.ticket;
        this.hash = credential.hash;
        this.chain = new Chain(credential.chain);
    }

    Credential(tecgraf.openbus.core.v2_0.credential.CredentialData credential) {
        this.legacy = true;
        this.bus = credential.bus;
        this.login = credential.login;
        this.session = credential.session;
        this.ticket = credential.ticket;
        this.hash = credential.hash;
        this.chain = new Chain(credential.chain);
    }

    Credential(String busId, String login, int session, int ticket, byte[] credentialDataHash, Chain chain, Boolean legacy) {
        this.legacy = legacy;
        this.bus = busId;
        this.login = login;
        this.session = session;
        this.ticket = ticket;
        this.hash = credentialDataHash;
        this.chain = chain;
    }

    Chain decodeChain(Codec codec) throws FormatMismatch, TypeMismatch {
        if (!this.legacy.booleanValue()) {
            Any any = codec.decode_value(this.chain.signedChain.encoded, CallChainHelper.type());
            tecgraf.openbus.core.v2_1.services.access_control.CallChain callChain = CallChainHelper.extract(any);
            this.chain.updateInfos(callChain);
            return this.chain;
        }
        Any any = codec.decode_value(this.chain.signedLegacy.encoded, tecgraf.openbus.core.v2_0.services.access_control.CallChainHelper.type());
        CallChain callChain = tecgraf.openbus.core.v2_0.services.access_control.CallChainHelper.extract((Any)any);
        this.chain.updateInfos(this.bus, callChain);
        return this.chain;
    }

    ServiceContext toServiceContext(ORB orb, Codec codec) throws InvalidTypeForEncoding {
        Any anyCredential = orb.create_any();
        if (!this.legacy.booleanValue()) {
            CredentialData credential = new CredentialData(this.bus, this.login, this.session, this.ticket, this.hash, this.chain.signedChain);
            tecgraf.openbus.core.v2_1.credential.CredentialDataHelper.insert(anyCredential, credential);
            byte[] encoded = codec.encode_value(anyCredential);
            return new ServiceContext(1112888065, encoded);
        }
        tecgraf.openbus.core.v2_0.credential.CredentialData credential = new tecgraf.openbus.core.v2_0.credential.CredentialData(this.bus, this.login, this.session, this.ticket, this.hash, this.chain.signedLegacy);
        CredentialDataHelper.insert((Any)anyCredential, (tecgraf.openbus.core.v2_0.credential.CredentialData)credential);
        byte[] encoded = codec.encode_value(anyCredential);
        return new ServiceContext(1112888064, encoded);
    }

    static class Reset {
        public String target;
        public String entity;
        public int session;
        public byte[] challenge;
        public boolean legacy;

        Reset(LoginInfo login, int session, byte[] challenge, boolean legacy) {
            this.target = login.id;
            this.entity = login.entity;
            this.session = session;
            this.challenge = challenge;
            this.legacy = legacy;
        }

        ServiceContext toServiceContext(ORB orb, Codec codec) throws InvalidTypeForEncoding {
            if (!this.legacy) {
                CredentialReset reset = new CredentialReset(this.target, this.entity, this.session, this.challenge);
                Any any = orb.create_any();
                CredentialResetHelper.insert(any, reset);
                byte[] encodedCredential = codec.encode_value(any);
                return new ServiceContext(1112888065, encodedCredential);
            }
            tecgraf.openbus.core.v2_0.credential.CredentialReset reset = new tecgraf.openbus.core.v2_0.credential.CredentialReset(this.target, this.session, this.challenge);
            Any any = orb.create_any();
            tecgraf.openbus.core.v2_0.credential.CredentialResetHelper.insert((Any)any, (tecgraf.openbus.core.v2_0.credential.CredentialReset)reset);
            byte[] encodedCredential = codec.encode_value(any);
            return new ServiceContext(1112888064, encodedCredential);
        }
    }

    static class Chain {
        public SignedData signedChain = InterceptorImpl.NULL_SIGNED_CALL_CHAIN;
        public SignedCallChain signedLegacy = InterceptorImpl.NULL_SIGNED_LEGACY_CALL_CHAIN;
        public String bus;
        public String target;
        public LoginInfo[] originators;
        public LoginInfo caller;

        Chain(SignedData chain) {
            if (chain != null) {
                this.signedChain = chain;
            }
        }

        Chain(SignedCallChain chain) {
            if (chain != null) {
                this.signedLegacy = chain;
            }
        }

        Chain(SignedData chain, SignedCallChain legacy_chain) {
            if (chain != null) {
                this.signedChain = chain;
            }
            if (legacy_chain != null) {
                this.signedLegacy = legacy_chain;
            }
        }

        void updateInfos(tecgraf.openbus.core.v2_1.services.access_control.CallChain callChain) {
            this.bus = callChain.bus;
            this.target = callChain.target;
            this.caller = callChain.caller;
            this.originators = callChain.originators;
        }

        void updateInfos(String busid, CallChain callChain) {
            this.bus = busid;
            this.target = callChain.target;
            this.caller = new LoginInfo(callChain.caller.id, callChain.caller.entity);
            this.originators = new LoginInfo[callChain.originators.length];
            for (int i = 0; i < callChain.originators.length; ++i) {
                tecgraf.openbus.core.v2_0.services.access_control.LoginInfo info = callChain.originators[i];
                this.originators[i] = new LoginInfo(info.id, info.entity);
            }
        }

        byte[] encoded() {
            if (this.signedChain != InterceptorImpl.NULL_SIGNED_CALL_CHAIN) {
                return this.signedChain.encoded;
            }
            return this.signedLegacy.encoded;
        }

        byte[] signature() {
            if (this.signedChain != InterceptorImpl.NULL_SIGNED_CALL_CHAIN) {
                return this.signedChain.signature;
            }
            return this.signedLegacy.signature;
        }

        boolean isLegacy() {
            return this.signedChain == InterceptorImpl.NULL_SIGNED_CALL_CHAIN && this.signedLegacy != InterceptorImpl.NULL_SIGNED_LEGACY_CALL_CHAIN;
        }
    }
}

