/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.PortableServer.POA;
import scs.core.IComponent;
import scs.core.IComponentHelper;
import tecgraf.openbus.CallerChain;
import tecgraf.openbus.Connection;
import tecgraf.openbus.LoginCallback;
import tecgraf.openbus.OnReloginCallback;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.SharedAuthSecret;
import tecgraf.openbus.core.AuthArgs;
import tecgraf.openbus.core.BusInfo;
import tecgraf.openbus.core.ChainCacheKey;
import tecgraf.openbus.core.Credential;
import tecgraf.openbus.core.EffectiveProfile;
import tecgraf.openbus.core.InternalLogin;
import tecgraf.openbus.core.LRUCache;
import tecgraf.openbus.core.LeaseRenewer;
import tecgraf.openbus.core.LegacySupport;
import tecgraf.openbus.core.LoginCache;
import tecgraf.openbus.core.LoginEvent;
import tecgraf.openbus.core.LoginRegistryImpl;
import tecgraf.openbus.core.ORBMediator;
import tecgraf.openbus.core.ORBUtils;
import tecgraf.openbus.core.OfferRegistryImpl;
import tecgraf.openbus.core.OpenBusContextImpl;
import tecgraf.openbus.core.OpenBusProperty;
import tecgraf.openbus.core.Session;
import tecgraf.openbus.core.SharedAuthSecretImpl;
import tecgraf.openbus.core.v2_0.services.access_control.AccessControl;
import tecgraf.openbus.core.v2_0.services.access_control.AccessControlHelper;
import tecgraf.openbus.core.v2_0.services.access_control.AccessDenied;
import tecgraf.openbus.core.v2_0.services.access_control.InvalidPublicKey;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_0.services.access_control.LoginProcess;
import tecgraf.openbus.core.v2_0.services.access_control.WrongEncoding;
import tecgraf.openbus.core.v2_1.EncryptedBlockHolder;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.access_control.InvalidToken;
import tecgraf.openbus.core.v2_1.services.access_control.LoginAuthenticationInfo;
import tecgraf.openbus.core.v2_1.services.access_control.LoginAuthenticationInfoHelper;
import tecgraf.openbus.core.v2_1.services.access_control.LoginProcessOperations;
import tecgraf.openbus.core.v2_1.services.access_control.LoginRegistry;
import tecgraf.openbus.core.v2_1.services.access_control.MissingCertificate;
import tecgraf.openbus.core.v2_1.services.access_control.TooManyAttempts;
import tecgraf.openbus.core.v2_1.services.access_control.UnknownDomain;
import tecgraf.openbus.core.v2_1.services.legacy_support.LegacyConverter;
import tecgraf.openbus.core.v2_1.services.legacy_support.LegacyConverterHelper;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry;
import tecgraf.openbus.exception.AlreadyLoggedIn;
import tecgraf.openbus.exception.CryptographyException;
import tecgraf.openbus.exception.InvalidLoginProcess;
import tecgraf.openbus.exception.InvalidPropertyValue;
import tecgraf.openbus.exception.OpenBusInternalException;
import tecgraf.openbus.exception.WrongBus;
import tecgraf.openbus.retry.RetryTaskPool;
import tecgraf.openbus.security.Cryptography;

final class ConnectionImpl
implements Connection {
    private final String connId = UUID.randomUUID().toString();
    private static final Logger logger = Logger.getLogger(ConnectionImpl.class.getName());
    private Cryptography crypto;
    private final ORB orb;
    private final POA poa;
    private final OpenBusContextImpl context;
    private final BusInfo bus;
    private final LoginRegistryImpl loginRegistry;
    private final OfferRegistryImpl offerRegistry;
    private final long interval;
    private final TimeUnit unit;
    private RSAPublicKey publicKey;
    private RSAPrivateKey privateKey;
    private InternalLogin internalLogin;
    private volatile OnReloginCallback reloginCallback;
    private final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.rwlock.writeLock();
    private LeaseRenewer renewer;
    private LoginCallback cb;
    Caches cache;
    private boolean legacy;
    private LegacySupport legacySupport;

    ConnectionImpl(Object reference, OpenBusContextImpl context, ORB orb, POA poa, Properties props) throws InvalidPropertyValue {
        KeyPair keyPair;
        int threadNum;
        this.orb = orb;
        this.poa = poa;
        this.context = context;
        if (props == null) {
            props = new Properties();
        }
        String busCertPath = OpenBusProperty.BUS_CERTIFICATE.getProperty(props);
        X509Certificate busCert = null;
        if (busCertPath != null) {
            try {
                this.crypto = Cryptography.getInstance();
                busCert = this.crypto.readX509Certificate(busCertPath);
            }
            catch (IOException e) {
                throw new InvalidPropertyValue(OpenBusProperty.BUS_CERTIFICATE.getKey(), busCertPath, e);
            }
            catch (CryptographyException e) {
                throw new OpenBusInternalException("Erro inesperado ao carregar o certificado do barramento.", e);
            }
        }
        this.bus = new BusInfo(reference, busCert);
        String threads = OpenBusProperty.THREAD_NUMBER.getProperty(props);
        try {
            threadNum = Integer.parseInt(threads);
            if (threadNum <= 0) {
                throw new InvalidPropertyValue(OpenBusProperty.THREAD_NUMBER.getKey(), threads);
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyValue(OpenBusProperty.THREAD_NUMBER.getKey(), threads, e);
        }
        RetryTaskPool pool = new RetryTaskPool(threadNum);
        String interval = OpenBusProperty.TIME_INTERVAL.getProperty(props);
        try {
            this.interval = Long.parseLong(interval);
            if (this.interval < 0L) {
                throw new InvalidPropertyValue(OpenBusProperty.TIME_INTERVAL.getKey(), interval);
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyValue(OpenBusProperty.TIME_INTERVAL.getKey(), interval, e);
        }
        String unit = OpenBusProperty.TIME_UNIT.getProperty(props);
        this.unit = ConnectionImpl.convertUnitPropertyToTimeUnit(unit);
        this.loginRegistry = new LoginRegistryImpl(context, this, poa, pool, this.interval, this.unit);
        this.offerRegistry = new OfferRegistryImpl(context, this, poa, pool, this.interval, this.unit);
        String prop = OpenBusProperty.LEGACY_DISABLE.getProperty(props);
        Boolean disabled = Boolean.valueOf(prop);
        this.legacy = disabled == false;
        String ssize = OpenBusProperty.CACHE_SIZE.getProperty(props);
        try {
            int size = Integer.parseInt(ssize);
            if (size <= 0) {
                throw new InvalidPropertyValue(OpenBusProperty.CACHE_SIZE.getKey(), ssize);
            }
            this.cache = new Caches(this, size);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyValue(OpenBusProperty.CACHE_SIZE.getKey(), ssize, e);
        }
        String path = OpenBusProperty.ACCESS_KEY.getProperty(props);
        if (path != null) {
            try {
                this.crypto = Cryptography.getInstance();
                keyPair = this.crypto.readKeyPairFromFile(path);
            }
            catch (IOException | InvalidKeySpecException e) {
                throw new InvalidPropertyValue(OpenBusProperty.ACCESS_KEY.getKey(), path, e);
            }
            catch (CryptographyException e) {
                throw new OpenBusInternalException("Erro inesperado ao carregar a chave privada.", e);
            }
        }
        try {
            this.crypto = Cryptography.getInstance();
            keyPair = this.crypto.generateRSAKeyPair();
        }
        catch (CryptographyException e) {
            throw new OpenBusInternalException("Erro inesperado na gera\u00e7\u00e3o do par de chaves.", e);
        }
        this.publicKey = (RSAPublicKey)keyPair.getPublic();
        this.privateKey = (RSAPrivateKey)keyPair.getPrivate();
        this.internalLogin = new InternalLogin(this);
    }

    @Override
    public ORB ORB() {
        return this.orb;
    }

    @Override
    public POA POA() {
        return this.poa;
    }

    @Override
    public OpenBusContext context() {
        return this.context;
    }

    @Override
    public String busId() {
        return this.getBus().getId();
    }

    @Override
    public RSAPublicKey busPublicKey() {
        return this.getBus().getPublicKey();
    }

    @Override
    public RSAPrivateKey privateKey() {
        return this.privateKey;
    }

    @Override
    public RSAPublicKey publicKey() {
        return this.publicKey;
    }

    private void checkLoggedIn() throws AlreadyLoggedIn {
        tecgraf.openbus.core.v2_1.services.access_control.LoginInfo login = this.internalLogin.login();
        if (login != null) {
            throw new AlreadyLoggedIn();
        }
    }

    @Override
    public void loginByPassword(String login, byte[] password, String domain) throws tecgraf.openbus.core.v2_1.services.access_control.AccessDenied, AlreadyLoggedIn, TooManyAttempts, UnknownDomain, ServiceFailure, tecgraf.openbus.core.v2_1.services.access_control.WrongEncoding {
        try {
            this.loginByCallback(() -> new AuthArgs(login, password, domain));
        }
        catch (InvalidLoginProcess | WrongBus e) {
            throw new OpenBusInternalException("Exce\u00e7\u00e3o de login por autentica\u00e7\u00e3o compartilhada recebida ao realizar login por senha.", e);
        }
        catch (MissingCertificate e) {
            throw new OpenBusInternalException("Exce\u00e7\u00e3o de login por chave privada recebida ao realizar login por senha.", (Throwable)((java.lang.Object)e));
        }
    }

    private void loginByPassword(String entity, byte[] password, String domain, LoginCallback cb, boolean relogin, tecgraf.openbus.core.v2_1.services.access_control.LoginInfo oldLogin) throws tecgraf.openbus.core.v2_1.services.access_control.AccessDenied, AlreadyLoggedIn, TooManyAttempts, UnknownDomain, ServiceFailure, tecgraf.openbus.core.v2_1.services.access_control.WrongEncoding {
        tecgraf.openbus.core.v2_1.services.access_control.LoginInfo newLogin;
        this.checkLoggedIn();
        try {
            this.context.ignoreThread();
            this.bus.basicBusInitialization();
            byte[] encryptedLoginAuthenticationInfo = this.generateEncryptedLoginAuthenticationInfo(password);
            IntHolder validityHolder = new IntHolder();
            newLogin = this.access().loginByPassword(entity, domain, this.publicKey().getEncoded(), encryptedLoginAuthenticationInfo, validityHolder);
            this.localLogin(newLogin, validityHolder.value, cb, relogin, oldLogin);
        }
        catch (tecgraf.openbus.core.v2_1.services.access_control.InvalidPublicKey e) {
            throw new OpenBusInternalException("Falha no protocolo OpenBus: A chave de acesso gerada n\u00e3o foi aceita. Mensagem=" + e.message);
        }
        finally {
            this.context.unignoreThread();
        }
        logger.info(String.format("Login por senha efetuado com sucesso: busId (%s) login (%s) entidade (%s)", this.busId(), newLogin.id, newLogin.entity));
    }

    private byte[] generateEncryptedLoginAuthenticationInfo(byte[] data) {
        try {
            byte[] publicKeyHash = this.crypto.generateHash(this.publicKey().getEncoded());
            LoginAuthenticationInfo authenticationInfo = new LoginAuthenticationInfo(publicKeyHash, data);
            Any authenticationInfoAny = this.orb.create_any();
            LoginAuthenticationInfoHelper.insert(authenticationInfoAny, authenticationInfo);
            ORBMediator mediator = ORBUtils.getMediator(this.orb);
            byte[] encodedLoginAuthenticationInfo = mediator.getCodec().encode_value(authenticationInfoAny);
            return this.crypto.encrypt(encodedLoginAuthenticationInfo, this.getBus().getPublicKey());
        }
        catch (InvalidTypeForEncoding e) {
            throw new OpenBusInternalException("Falha inesperada ao codificar as informa\u00e7\u00f5es de autentica\u00e7\u00e3o", e);
        }
        catch (CryptographyException e) {
            throw new OpenBusInternalException("Erro de criptografia com uso de chave p\u00fablica.", e);
        }
    }

    @Override
    public void loginByPrivateKey(String entity, RSAPrivateKey key) throws AlreadyLoggedIn, tecgraf.openbus.core.v2_1.services.access_control.AccessDenied, MissingCertificate, ServiceFailure, tecgraf.openbus.core.v2_1.services.access_control.WrongEncoding {
        try {
            this.loginByCallback(() -> new AuthArgs(entity, key));
        }
        catch (InvalidLoginProcess | WrongBus e) {
            throw new OpenBusInternalException("Exce\u00e7\u00e3o de login por autentica\u00e7\u00e3o compartilhada recebida ao realizar login por chave privada.", e);
        }
        catch (TooManyAttempts | UnknownDomain e) {
            throw new OpenBusInternalException("Exce\u00e7\u00e3o de login por senha recebida ao realizar login por chave privada.", e);
        }
    }

    private void loginByPrivateKey(String entity, RSAPrivateKey privateKey, LoginCallback cb, boolean relogin, tecgraf.openbus.core.v2_1.services.access_control.LoginInfo oldLogin) throws AlreadyLoggedIn, MissingCertificate, tecgraf.openbus.core.v2_1.services.access_control.AccessDenied, ServiceFailure, tecgraf.openbus.core.v2_1.services.access_control.WrongEncoding {
        tecgraf.openbus.core.v2_1.services.access_control.LoginInfo newLogin;
        this.checkLoggedIn();
        this.context.ignoreThread();
        this.bus.basicBusInitialization();
        LoginProcessOperations loginProcess = null;
        try {
            EncryptedBlockHolder challengeHolder = new EncryptedBlockHolder();
            loginProcess = this.access().startLoginByCertificate(entity, challengeHolder);
            byte[] decryptedChallenge = this.crypto.decrypt(challengeHolder.value, privateKey);
            byte[] encryptedLoginAuthenticationInfo = this.generateEncryptedLoginAuthenticationInfo(decryptedChallenge);
            IntHolder validityHolder = new IntHolder();
            newLogin = loginProcess.login(this.publicKey().getEncoded(), encryptedLoginAuthenticationInfo, validityHolder);
            this.localLogin(newLogin, validityHolder.value, cb, relogin, oldLogin);
        }
        catch (CryptographyException e) {
            loginProcess.cancel();
            throw new tecgraf.openbus.core.v2_1.services.access_control.AccessDenied("Erro ao descriptografar desafio.");
        }
        catch (tecgraf.openbus.core.v2_1.services.access_control.InvalidPublicKey e) {
            throw new OpenBusInternalException("Falha no protocolo OpenBus: A chave de acesso gerada n\u00e3o foi aceita. Mensagem=" + e.message);
        }
        finally {
            this.context.unignoreThread();
        }
        logger.info(String.format("Login por certificado efetuada com sucesso: busId (%s) login (%s) entidade (%s)", this.busId(), newLogin.id, newLogin.entity));
    }

    @Override
    public void loginByCallback(LoginCallback cb) throws AlreadyLoggedIn, WrongBus, InvalidLoginProcess, tecgraf.openbus.core.v2_1.services.access_control.AccessDenied, TooManyAttempts, UnknownDomain, MissingCertificate, ServiceFailure, tecgraf.openbus.core.v2_1.services.access_control.WrongEncoding {
        this.loginByCallback(cb, false, null);
    }

    @Override
    public SharedAuthSecret startSharedAuth() throws ServiceFailure {
        EncryptedBlockHolder challenge = new EncryptedBlockHolder();
        LoginProcessOperations process = null;
        byte[] secret = null;
        LoginProcess legacyProcess = null;
        Connection previousConnection = this.context.currentConnection();
        try {
            this.context.currentConnection(this);
            process = this.access().startLoginBySharedAuth(challenge);
            secret = this.crypto.decrypt(challenge.value, this.privateKey());
            if (this.legacy() && this.legacySupport().converter() != null) {
                try {
                    legacyProcess = this.legacySupport().converter().convertSharedAuth((tecgraf.openbus.core.v2_1.services.access_control.LoginProcess)process);
                }
                catch (Exception e) {
                    String msg = "N\u00e3o foi poss\u00edvel converter o compartilhamento de autentica\u00e7\u00e3o";
                    logger.log(Level.SEVERE, msg, e);
                }
            }
        }
        catch (CryptographyException e) {
            process.cancel();
            throw new ServiceFailure("Erro ao decriptar segredo com chave privada: " + e.getMessage());
        }
        finally {
            this.context.currentConnection(previousConnection);
        }
        return new SharedAuthSecretImpl(this.busId(), (tecgraf.openbus.core.v2_1.services.access_control.LoginProcess)process, legacyProcess, secret, this.context);
    }

    private void loginBySharedAuth(SharedAuthSecret secret, LoginCallback cb, boolean relogin, tecgraf.openbus.core.v2_1.services.access_control.LoginInfo oldLogin) throws AlreadyLoggedIn, WrongBus, ServiceFailure, tecgraf.openbus.core.v2_1.services.access_control.AccessDenied, InvalidLoginProcess {
        tecgraf.openbus.core.v2_1.services.access_control.LoginInfo newLogin;
        block13: {
            this.checkLoggedIn();
            try {
                this.context.ignoreThread();
                this.bus.basicBusInitialization();
                if (this.busId().equals(secret.busid())) {
                    SharedAuthSecretImpl sharedAuth = (SharedAuthSecretImpl)secret;
                    byte[] encryptedLoginAuthenticationInfo = this.generateEncryptedLoginAuthenticationInfo(sharedAuth.secret());
                    IntHolder validity = new IntHolder();
                    if (sharedAuth.attempt() != null) {
                        newLogin = sharedAuth.attempt().login(this.publicKey().getEncoded(), encryptedLoginAuthenticationInfo, validity);
                    } else {
                        LoginInfo legacy = sharedAuth.legacy().login(this.publicKey().getEncoded(), encryptedLoginAuthenticationInfo, validity);
                        newLogin = new tecgraf.openbus.core.v2_1.services.access_control.LoginInfo(legacy.id, legacy.entity);
                    }
                    this.localLogin(newLogin, validity.value, cb, relogin, oldLogin);
                    break block13;
                }
                throw new WrongBus();
            }
            catch (WrongEncoding | tecgraf.openbus.core.v2_1.services.access_control.WrongEncoding e) {
                throw new tecgraf.openbus.core.v2_1.services.access_control.AccessDenied("Erro durante tentativa de login.");
            }
            catch (OBJECT_NOT_EXIST e) {
                throw new InvalidLoginProcess("Objeto de processo de login \u00e9 inv\u00e1lido");
            }
            catch (tecgraf.openbus.core.v2_1.services.access_control.InvalidPublicKey e) {
                throw new OpenBusInternalException("Falha no protocolo OpenBus: A chave de acesso gerada n\u00e3o foi aceita. Mensagem=" + e.message);
            }
            catch (InvalidPublicKey e) {
                throw new OpenBusInternalException("Falha no protocolo OpenBus: A chave de acesso gerada n\u00e3o foi aceita. Mensagem=" + e.message);
            }
            catch (AccessDenied e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                throw new tecgraf.openbus.core.v2_1.services.access_control.AccessDenied(e.getMessage());
            }
            catch (tecgraf.openbus.core.v2_0.services.ServiceFailure e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                throw new ServiceFailure(e.getMessage(), e.message);
            }
            finally {
                this.context.unignoreThread();
            }
        }
        logger.info(String.format("Login por compatilhamento de autentica\u00e7\u00e3o efetuado com sucesso: busId (%s) login (%s) entidade (%s)", this.busId(), newLogin.id, newLogin.entity));
    }

    private void loginByCallback(LoginCallback cb, boolean relogin, tecgraf.openbus.core.v2_1.services.access_control.LoginInfo oldLogin) throws AlreadyLoggedIn, WrongBus, InvalidLoginProcess, tecgraf.openbus.core.v2_1.services.access_control.AccessDenied, TooManyAttempts, UnknownDomain, MissingCertificate, ServiceFailure, tecgraf.openbus.core.v2_1.services.access_control.WrongEncoding {
        AuthArgs args = cb.authenticationArguments();
        switch (args.mode) {
            case AuthByPassword: {
                this.loginByPassword(args.entity, args.password, args.domain, cb, relogin, oldLogin);
                break;
            }
            case AuthByPrivateKey: {
                this.loginByPrivateKey(args.entity, args.privkey, cb, relogin, oldLogin);
                break;
            }
            case AuthBySharedSecret: {
                this.loginBySharedAuth(args.secret, cb, relogin, oldLogin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidLogin(tecgraf.openbus.core.v2_1.services.access_control.LoginInfo loginInfo) {
        logger.info("Refazendo login da entidade " + loginInfo.entity + ". Login perdido: " + loginInfo.id);
        boolean retry = true;
        boolean loggedOut = true;
        if (this.login() != null) {
            retry = false;
            loggedOut = false;
        }
        while (retry && loggedOut) {
            try {
                LoginCallback cb;
                this.readLock.lock();
                try {
                    cb = this.cb;
                }
                finally {
                    this.readLock.unlock();
                }
                this.loginByCallback(cb, true, loginInfo);
                retry = false;
            }
            catch (AlreadyLoggedIn e) {
                retry = false;
            }
            catch (Exception e) {
                logger.warning("Erro ao tentar refazer o login. " + e);
                retry = true;
            }
            if (retry) {
                Uninterruptibles.sleepUninterruptibly((long)this.interval, (TimeUnit)this.unit);
            }
            loggedOut = this.login() == null;
        }
        logger.info("Login refeito.");
    }

    @Override
    public tecgraf.openbus.LoginRegistry loginRegistry() {
        return this.loginRegistry;
    }

    @Override
    public tecgraf.openbus.OfferRegistry offerRegistry() {
        return this.offerRegistry;
    }

    @Override
    public void onReloginCallback(OnReloginCallback callback) {
        this.reloginCallback = callback;
    }

    @Override
    public OnReloginCallback onReloginCallback() {
        return this.reloginCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallerChain makeChainFor(String entity) throws ServiceFailure {
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this);
            CallerChain callerChain = this.context.makeChainFor(entity);
            return callerChain;
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallerChain importChain(byte[] token, String domain) throws InvalidToken, UnknownDomain, tecgraf.openbus.core.v2_1.services.access_control.WrongEncoding, ServiceFailure {
        Connection prev = this.context.currentConnection();
        try {
            this.context.currentConnection(this);
            CallerChain callerChain = this.context.importChain(token, domain);
            return callerChain;
        }
        finally {
            this.context.currentConnection(prev);
        }
    }

    public static TimeUnit convertUnitPropertyToTimeUnit(String unit) throws InvalidPropertyValue {
        switch (unit = unit.trim().toLowerCase()) {
            case "ns": 
            case "nanos": 
            case "nanosecs": 
            case "nanoseconds": {
                return TimeUnit.NANOSECONDS;
            }
            case "us": 
            case "micros": 
            case "microsecs": 
            case "microseconds": {
                return TimeUnit.MICROSECONDS;
            }
            case "ms": 
            case "millis": 
            case "millisecs": 
            case "milliseconds": {
                return TimeUnit.MILLISECONDS;
            }
            case "s": 
            case "secs": 
            case "seconds": {
                return TimeUnit.SECONDS;
            }
            case "m": 
            case "mins": 
            case "minutes": {
                return TimeUnit.MINUTES;
            }
            case "h": 
            case "hrs": 
            case "hours": {
                return TimeUnit.HOURS;
            }
            case "d": 
            case "days": {
                return TimeUnit.DAYS;
            }
        }
        throw new InvalidPropertyValue(OpenBusProperty.TIME_UNIT.getKey(), unit);
    }

    private void fireRenewerThread(int defaultLease) {
        if (this.renewer != null) {
            this.renewer.stop();
        }
        this.renewer = new LeaseRenewer(this, defaultLease);
        this.renewer.start();
    }

    private void stopRenewerThread() {
        if (this.renewer != null) {
            this.renewer.stop();
        }
        this.renewer = null;
    }

    @Override
    public tecgraf.openbus.core.v2_1.services.access_control.LoginInfo login() {
        return this.internalLogin.login();
    }

    tecgraf.openbus.core.v2_1.services.access_control.LoginInfo getLogin() {
        return this.internalLogin.getLogin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localLogin(tecgraf.openbus.core.v2_1.services.access_control.LoginInfo newLogin, int validity, LoginCallback cb, boolean relogin, tecgraf.openbus.core.v2_1.services.access_control.LoginInfo oldLogin) throws AlreadyLoggedIn {
        if (this.legacy) {
            this.activateLegacySupport();
        }
        this.writeLock().lock();
        try {
            this.checkLoggedIn();
            this.internalLogin.setLoggedIn(newLogin);
            this.cb = cb;
            this.fireRenewerThread(validity);
        }
        finally {
            this.writeLock().unlock();
        }
        this.readLock().lock();
        try {
            if (relogin) {
                this.loginRegistry.fireEvent(LoginEvent.RELOGIN, newLogin);
                this.offerRegistry.fireEvent(LoginEvent.RELOGIN, newLogin);
                OnReloginCallback callback = this.onReloginCallback();
                new Thread(() -> {
                    if (callback != null) {
                        callback.onRelogin(this, oldLogin);
                    }
                }).start();
            } else {
                this.loginRegistry.fireEvent(LoginEvent.LOGGED_IN, newLogin);
                this.offerRegistry.fireEvent(LoginEvent.LOGGED_IN, newLogin);
            }
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean logout() throws ServiceFailure {
        tecgraf.openbus.core.v2_1.services.access_control.LoginInfo login;
        this.writeLock().lock();
        try {
            this.stopRenewerThread();
            login = this.internalLogin.login();
            if (login == null) {
                if (this.internalLogin.invalid() != null) {
                    this.localLogout(false);
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.writeLock().unlock();
        }
        Connection previousConnection = this.context.currentConnection();
        CallerChain previousChain = this.context.joinedChain();
        try {
            this.context.exitChain();
            this.context.currentConnection(this);
            this.context.ignoreInvLogin();
            this.access().logout();
        }
        catch (NO_PERMISSION e) {
            if (e.minor != 1112888066) {
                logger.log(Level.WARNING, String.format("Erro durante chamada remota de logout: busId (%s) login (%s) entidade (%s)", this.busId(), login.id, login.entity), e);
                boolean bl = false;
                return bl;
            }
        }
        catch (SystemException e) {
            logger.log(Level.WARNING, String.format("Erro durante chamada remota de logout: busId (%s) login (%s) entidade (%s)", this.busId(), login.id, login.entity), e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.context.currentConnection(previousConnection);
            this.context.joinChain(previousChain);
            this.context.unignoreInvLogin();
            this.localLogout(false);
        }
        return true;
    }

    void localLogout(boolean invalidated) {
        this.writeLock.lock();
        try {
            this.cache.clear();
            this.bus.clearBusInfos();
            this.stopRenewerThread();
            if (invalidated) {
                this.internalLogin.setInvalid();
            } else {
                tecgraf.openbus.core.v2_1.services.access_control.LoginInfo old = this.internalLogin.setLoggedOut();
                this.loginRegistry.fireEvent(LoginEvent.LOGGED_OUT, null);
                this.offerRegistry.fireEvent(LoginEvent.LOGGED_OUT, null);
                if (old != null) {
                    logger.info(String.format("Logout efetuado: id (%s) entidade (%s)", old.id, old.entity));
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    tecgraf.openbus.core.v2_1.services.access_control.AccessControl access() {
        return this.getBus().getAccessControl();
    }

    LoginRegistry logins() {
        return this.getBus().getLoginRegistry();
    }

    OfferRegistry offers() {
        return this.getBus().getOfferRegistry();
    }

    public boolean legacy() {
        return this.legacy && this.legacySupport != null;
    }

    LegacySupport legacySupport() {
        return this.legacySupport;
    }

    private BusInfo getBus() {
        return this.bus;
    }

    ReentrantReadWriteLock.ReadLock readLock() {
        return this.readLock;
    }

    ReentrantReadWriteLock.WriteLock writeLock() {
        return this.writeLock;
    }

    String connId() {
        return this.connId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int nextAvailableSessionId() {
        Map<Integer, Session.ServerSideSession> map = this.cache.srvSessions;
        synchronized (map) {
            for (int i = 1; i <= this.cache.CACHE_SIZE + 1; ++i) {
                if (this.cache.srvSessions.containsKey(i)) continue;
                return i;
            }
        }
        return this.cache.CACHE_SIZE + 1;
    }

    public boolean equals(java.lang.Object obj) {
        if (obj instanceof ConnectionImpl) {
            ConnectionImpl other = (ConnectionImpl)obj;
            return this.connId.equals(other.connId);
        }
        return false;
    }

    public int hashCode() {
        return this.connId.hashCode();
    }

    public String toString() {
        return this.connId;
    }

    private void activateLegacySupport() {
        Object object = this.bus.getComponent().getFacetByName("LegacySupport");
        if (object != null) {
            IComponent comp = IComponentHelper.narrow((Object)object);
            Object faccess = comp.getFacet(AccessControlHelper.id());
            if (faccess != null) {
                AccessControl access = AccessControlHelper.narrow((Object)faccess);
                Object fconv = comp.getFacet(LegacyConverterHelper.id());
                LegacyConverter converter = null;
                if (fconv != null) {
                    converter = LegacyConverterHelper.narrow(fconv);
                } else {
                    logger.warning("Exporta\u00e7\u00e3o de dado legado desativado.");
                }
                this.legacySupport = new LegacySupport(access, converter);
            } else {
                this.legacy = false;
                logger.severe("Suporte legado desativado dado aus\u00eancia de controle de acesso");
            }
        } else {
            this.legacy = false;
            logger.warning("Suporte legado n\u00e3o dispon\u00edvel");
        }
    }

    class Caches {
        final int CACHE_SIZE;
        final Map<EffectiveProfile, String> entities;
        final Map<String, Session.ClientSideSession> cltSessions;
        final Map<ChainCacheKey, Credential.Chain> chains;
        final Map<Integer, Session.ServerSideSession> srvSessions;
        final LoginCache logins;

        public Caches(ConnectionImpl conn, int size) {
            this.CACHE_SIZE = size;
            this.entities = Collections.synchronizedMap(new LRUCache(this.CACHE_SIZE));
            this.cltSessions = Collections.synchronizedMap(new LRUCache(this.CACHE_SIZE));
            this.chains = Collections.synchronizedMap(new LRUCache(this.CACHE_SIZE));
            this.srvSessions = Collections.synchronizedMap(new LRUCache(this.CACHE_SIZE));
            this.logins = new LoginCache(conn, this.CACHE_SIZE);
        }

        void clear() {
            this.entities.clear();
            this.cltSessions.clear();
            this.chains.clear();
            this.srvSessions.clear();
            this.logins.clear();
        }
    }
}

