/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.core.lng;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import tecgraf.javautils.core.lng.LNG;

public class FormatUtils {
    private static final String LOCALE_DELIMITER = "_";

    public static String format(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date == null");
        }
        String subformat = LNG.get("javautils.default.date.format");
        String format = "{0,date," + subformat + "}";
        MessageFormat formatter = new MessageFormat(format);
        return formatter.format(new Date[]{date});
    }

    public static String format(long timeInMillis) {
        return FormatUtils.format(new Date(timeInMillis));
    }

    public static String format(Date date, int style, Locale locale) {
        if (date == null) {
            throw new IllegalArgumentException("date == null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale == null");
        }
        DateFormat formatter = DateFormat.getDateInstance(style, locale);
        return formatter.format(date);
    }

    public static String format(Date date, int style) {
        return FormatUtils.format(date, style, LNG.getLocale());
    }

    public static String format(long dateInMillis, int style) {
        return FormatUtils.format(new Date(dateInMillis), style);
    }

    public static Date parseDate(String formattedDate) throws ParseException {
        if (formattedDate == null) {
            throw new IllegalArgumentException("formattedDate == null");
        }
        String format = LNG.get("javautils.default.date.format");
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.parse(formattedDate);
    }

    public static Date parseDate(String formattedDate, int style) throws ParseException {
        if (formattedDate == null) {
            throw new IllegalArgumentException("formattedDate == null");
        }
        Locale locale = LNG.getLocale();
        DateFormat formatter = DateFormat.getDateInstance(style, locale);
        return formatter.parse(formattedDate);
    }

    public static String format(Object[] items) {
        if (items == null) {
            throw new IllegalArgumentException("items == null");
        }
        if (items.length == 0) {
            throw new IllegalArgumentException("items.length == 0");
        }
        StringBuffer result = new StringBuffer();
        result.append(items[0]);
        int itemCount = items.length;
        for (int i = 1; i < itemCount - 1; ++i) {
            result.append(", ");
            result.append(items[i]);
        }
        if (itemCount > 1) {
            result.append(" " + LNG.get("javautils.and") + " ");
            result.append(items[itemCount - 1]);
        }
        return result.toString();
    }

    public static String formatInterval(int itime) {
        if (itime < 0) {
            throw new IllegalArgumentException("interval < 0");
        }
        DecimalFormat f = new DecimalFormat("00");
        int sec = itime % 60;
        int min = itime / 60;
        int hour = min / 60;
        if (hour > 0) {
            min -= hour * 60;
        }
        return f.format(hour) + ":" + f.format(min) + ":" + f.format(sec);
    }

    public static Locale parseLocale(String localeStr) {
        if (localeStr == null) {
            return null;
        }
        if (localeStr.length() == 0) {
            return null;
        }
        String[] tokens = localeStr.split(LOCALE_DELIMITER, 3);
        switch (tokens.length) {
            case 0: {
                return null;
            }
            case 1: {
                return new Locale(tokens[0]);
            }
            case 2: {
                return new Locale(tokens[0], tokens[1]);
            }
            case 3: {
                return new Locale(tokens[0], tokens[1], tokens[2]);
            }
        }
        throw new IllegalStateException("Erro no m\u00e9todo String.split.");
    }

    public static String formatNumber(double value, int fractionDigits) {
        NumberFormat valueFmt = NumberFormat.getNumberInstance(LNG.getLocale());
        valueFmt.setMaximumFractionDigits(fractionDigits);
        valueFmt.setMinimumFractionDigits(fractionDigits);
        return valueFmt.format(value);
    }

    public static String formatNumber(double value, int fractionDigits, Locale locale) {
        NumberFormat valueFmt = NumberFormat.getNumberInstance(locale);
        valueFmt.setMaximumFractionDigits(fractionDigits);
        valueFmt.setMinimumFractionDigits(fractionDigits);
        return valueFmt.format(value);
    }

    public static String formatSize(long sizeInBytes, int fractionDigits) {
        return FormatUtils.adjustSize(sizeInBytes, fractionDigits, null);
    }

    public static String formatSize(long sizeInBytes, int fractionDigits, Locale locale) {
        return FormatUtils.adjustSize(sizeInBytes, fractionDigits, locale);
    }

    private static String adjustSize(long sizeInBytes, int fractionDigits, Locale locale) {
        int sizeUnitIndex;
        int UNIT_FACTOR = 1024;
        if (sizeInBytes < 0L) {
            throw new IllegalArgumentException("sizeInBytes < 0");
        }
        if (sizeInBytes < 1024L) {
            fractionDigits = 0;
        }
        String[] sizeUnit = new String[]{"byte(s)", "kB", "MB", "GB"};
        double size = sizeInBytes;
        for (sizeUnitIndex = 0; size >= 1024.0 && sizeUnitIndex < sizeUnit.length - 1; size /= 1024.0, ++sizeUnitIndex) {
        }
        if (locale != null) {
            return FormatUtils.formatNumber(size, fractionDigits, locale) + " " + sizeUnit[sizeUnitIndex];
        }
        return FormatUtils.formatNumber(size, fractionDigits) + " " + sizeUnit[sizeUnitIndex];
    }
}

