/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.core.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import tecgraf.javautils.core.string.StringUtils;

public class FileUtils {
    public static final boolean osIsWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    private static final char FILE_EXTENSION_SEPARATOR = '.';

    public static final String fixDirectoryName(String name) {
        return StringUtils.removeAccents(name).replaceAll("[^-\\w]", "_");
    }

    public static final String fixFileName(String name) {
        return StringUtils.removeAccents(name).replaceAll("[^-\\w.]", "_");
    }

    public static final boolean delete(File file) {
        File[] children;
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory() && (children = file.listFiles()) != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                FileUtils.delete(children[i]);
            }
        }
        return file.delete();
    }

    @Deprecated
    public static final String joinPath(String[] splittedPath, String fileName, String separator) {
        return FileUtils.joinPath(fileName, separator.charAt(0), splittedPath);
    }

    public static final String joinPath(String separator, String[] splittedPath) {
        return FileUtils.joinPath(separator.charAt(0), splittedPath);
    }

    public static final String joinPath(String fileName, char separator, String ... splittedPath) {
        if (splittedPath == null) {
            throw new IllegalArgumentException("directoryPath == null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("O par\u00e2metro fileName est\u00e1 nulo.");
        }
        String path = FileUtils.joinPath(separator, splittedPath);
        path = path + separator + fileName;
        return path;
    }

    @Deprecated
    public static final String joinPath(String[] splittedPath, String separator) {
        return FileUtils.joinPath(separator.charAt(0), splittedPath);
    }

    public static final String joinPath(String ... splittedPath) {
        return FileUtils.joinPath(File.separatorChar, splittedPath);
    }

    public static String joinPath(boolean absolute, char separator, String ... splittedPath) {
        StringBuilder buffer = new StringBuilder();
        if (splittedPath == null) {
            throw new IllegalArgumentException("array de diret\u00f3rios == null");
        }
        if (absolute) {
            buffer.append(separator);
        }
        for (int i = 0; i < splittedPath.length - 1; ++i) {
            buffer.append(splittedPath[i]);
            buffer.append(separator);
        }
        if (splittedPath.length > 0) {
            buffer.append(splittedPath[splittedPath.length - 1]);
        }
        return buffer.toString();
    }

    public static final String joinPath(char separator, String ... splittedPath) {
        return FileUtils.joinPath(false, separator, splittedPath);
    }

    public static final String joinFileName(String fileNameWithoutExtension, String fileExtension) {
        if (fileNameWithoutExtension == null) {
            throw new IllegalArgumentException("O par\u00e2metro fileName est\u00e1 nulo.");
        }
        if (fileExtension == null) {
            throw new IllegalArgumentException("O par\u00e2metro fileExtension est\u00e1 nulo.");
        }
        return fileNameWithoutExtension + '.' + fileExtension;
    }

    public static final String[] splitPath(String joinedPath) {
        return FileUtils.splitPath(joinedPath, File.separator);
    }

    public static final String[] splitPath(String joinedPath, String separator) {
        if (joinedPath == null) {
            throw new IllegalArgumentException("joinedPath == null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("separator == null");
        }
        return FileUtils.splitPath(joinedPath, separator.charAt(0));
    }

    public static final String[] splitPath(String path, char separator) {
        Scanner scanner = new Scanner(path).useDelimiter(Pattern.quote(String.valueOf(separator)));
        ArrayList<String> pathAsList = new ArrayList<String>();
        while (scanner.hasNext()) {
            String dir = scanner.next();
            if (dir.isEmpty()) continue;
            pathAsList.add(dir);
        }
        return pathAsList.toArray(new String[pathAsList.size()]);
    }

    public static final String getFileExtension(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("path est\u00e1 vazia");
        }
        int periodIndex = path.lastIndexOf(46);
        if (periodIndex == -1 || periodIndex == path.length() - 1) {
            return null;
        }
        return path.substring(periodIndex + 1).toLowerCase();
    }

    public static final String replaceFileExtension(String path, String newExt) {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("path est\u00e1 vazio");
        }
        int periodIndex = path.lastIndexOf(46);
        if (periodIndex == -1) {
            periodIndex = path.length();
        }
        String withoutExt = path.substring(0, periodIndex);
        if (newExt.startsWith(".")) {
            return withoutExt + newExt;
        }
        return withoutExt + "." + newExt;
    }

    public static final String addFileExtension(String path, String ext) {
        String currentExt;
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("path est\u00e1 vazio");
        }
        if (ext == null) {
            throw new IllegalArgumentException("extens\u00e3o == null");
        }
        if (ext.isEmpty()) {
            throw new IllegalArgumentException("extens\u00e3o est\u00e1 vazia");
        }
        String newExt = ext;
        if (newExt.startsWith(".")) {
            newExt = newExt.substring(1, newExt.length());
        }
        if ((currentExt = FileUtils.getFileExtension(path)) != null && currentExt.equalsIgnoreCase(newExt)) {
            return path;
        }
        if (path.endsWith(".")) {
            return path + newExt;
        }
        return path + "." + newExt;
    }

    public static final String getFileName(String path) {
        return FileUtils.getFileName(path, File.separator);
    }

    public static final String getFileName(String path, String separator) {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("path == null");
        }
        int index = path.lastIndexOf(separator);
        if (index == -1) {
            return path;
        }
        return path.substring(index + 1);
    }

    public static final String getFilePath(String path) {
        return FileUtils.getFilePath(path, File.separator);
    }

    public static final String getFilePath(String path, String separator) {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("path == null");
        }
        if ((path = path.trim()).isEmpty()) {
            return "";
        }
        int index = path.lastIndexOf(separator);
        if (index == -1) {
            return "";
        }
        return path.substring(0, index);
    }

    public static boolean startsAsURL(String url) {
        return url.matches("^(https?|file|ftp):.*");
    }

    public static String prepareURL(String rawUrl) {
        String url = rawUrl.replaceAll("\\\\", "/");
        StringBuilder fixedURL = new StringBuilder(url);
        if (!FileUtils.startsAsURL(url)) {
            if (!FileUtils.isAbsolutePath(url)) {
                String currDir = System.getProperty("user.dir").replaceAll("\\\\", "/");
                fixedURL.insert(0, currDir + '/');
            }
            if (osIsWindows) {
                fixedURL.insert(0, '/');
            }
            fixedURL.insert(0, "file://");
        }
        if (fixedURL.charAt(fixedURL.length() - 1) != '/') {
            fixedURL.append('/');
        }
        return fixedURL.toString();
    }

    public static boolean isAbsolutePath(String path) {
        return path.startsWith("/") || path.matches("^\\w:\\\\.*");
    }

    public static String getRelativePath(File from, File to, char separator) throws IOException {
        String pathTo;
        String pathFrom = from.getCanonicalPath();
        if (pathFrom.equals(pathTo = to.getCanonicalPath())) {
            return ".";
        }
        List<String> componentsFrom = FileUtils.pathToList(pathFrom, separator);
        List<String> componentsTo = FileUtils.pathToList(pathTo, separator);
        int lastMatch = FileUtils.findPrefixEnd(componentsFrom, componentsTo);
        int goUp = componentsFrom.size() - 1;
        if (lastMatch > -1) {
            goUp -= lastMatch;
        } else if (componentsTo.isEmpty()) {
            ++goUp;
        }
        StringBuilder relativePath = new StringBuilder();
        int i = goUp;
        while (i > 0) {
            relativePath.append("..");
            if (--i <= 0) continue;
            relativePath.append(separator);
        }
        int sizeTo = componentsTo.size();
        boolean addSeparator = goUp > 0;
        for (int i2 = lastMatch + 1; i2 < sizeTo; ++i2) {
            if (addSeparator) {
                relativePath.append(separator);
            }
            addSeparator = true;
            relativePath.append(componentsTo.get(i2));
        }
        return relativePath.toString();
    }

    public static String getRelativePath(String from, String to, char separator) throws IOException {
        return FileUtils.getRelativePath(new File(from), new File(to), separator);
    }

    private static List<String> pathToList(String path, char separator) {
        String regex = Pattern.quote("" + separator);
        ArrayList<String> list = new ArrayList<String>();
        for (String string : path.split(regex)) {
            if (string.isEmpty()) continue;
            list.add(string);
        }
        return list;
    }

    private static <T> int findPrefixEnd(List<T> list1, List<T> list2) {
        int i;
        if (list1.isEmpty() || list2.isEmpty()) {
            return -1;
        }
        if (!list1.get(0).equals(list2.get(0))) {
            return -1;
        }
        int size1 = list1.size();
        int size2 = list2.size();
        for (i = 1; i < size1 && i < size2 && list1.get(i).equals(list2.get(i)); ++i) {
        }
        return i - 1;
    }
}

