/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.core.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class FileFinder {
    private Set<String> blackList;
    private FileFilter filter;
    private int maxResults = 0;
    private int maxDepth = 0;
    private static final Hashtable<String, Pattern> PATTERN_CACHE = new Hashtable();
    private static Comparator<File> FILE_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            if (o1.isDirectory()) {
                if (!o2.isDirectory()) {
                    return 1;
                }
            } else if (o2.isDirectory()) {
                return -1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };
    public static final FileFilter DIR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    public static final FileFilter ZERO_LENGTH_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.length() == 0L;
        }
    };
    public static final FileFilter FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return !pathname.isDirectory();
        }
    };
    public static final FileFilter DOTFILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().charAt(0) == '.';
        }
    };
    public static final FileFilter NO_DOTFILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().charAt(0) != '.';
        }
    };

    public FileFinder() {
        this(null);
    }

    public FileFinder(FileFilter filter) {
        this.filter = filter;
    }

    private File[] preFilter(File dir) {
        FileFilter firstPassFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (FileFinder.this.blackList != null && FileFinder.this.blackList.contains(pathname.getName())) {
                    return false;
                }
                return pathname.isDirectory() || FileFinder.this.filter == null || FileFinder.this.filter.accept(pathname);
            }
        };
        return dir.listFiles(firstPassFilter);
    }

    public FileFilter group(final boolean matchAll, final FileFilter currentFilter, final FileFilter ... filters) {
        if (filters == null) {
            return null;
        }
        if (!matchAll) {
            for (FileFilter filter : filters) {
                if (filter != null) continue;
                return null;
            }
        }
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (matchAll) {
                    if (currentFilter != null && !currentFilter.accept(pathname)) {
                        return false;
                    }
                    for (FileFilter filter : filters) {
                        if (filter == null || filter.accept(pathname)) continue;
                        return false;
                    }
                    return true;
                }
                if (currentFilter != null && currentFilter.accept(pathname)) {
                    return true;
                }
                for (FileFilter filter : filters) {
                    if (!filter.accept(pathname)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public FileFinder skip(String ... names) {
        this.blackList = new HashSet<String>();
        if (names != null) {
            Collections.addAll(this.blackList, names);
        }
        return this;
    }

    public FileFinder limit(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public List<File> findIn(String startPath) throws IOException {
        return this.findIn(new File(startPath));
    }

    public List<File> findIn(File start) throws IOException {
        if (!start.exists()) {
            throw new IOException(start.getPath() + " n\u00e3o existe");
        }
        if (!start.isDirectory()) {
            throw new IOException(start.getPath() + " n\u00e3o \u00e9 um diret\u00f3rio");
        }
        ArrayList<File> result = new ArrayList<File>();
        this.findIn(start, result, 0);
        return result;
    }

    private void findIn(File start, List<File> result, int depth) {
        if (this.maxDepth > 0 && depth > this.maxDepth) {
            return;
        }
        File[] files = this.preFilter(start);
        if (files == null) {
            return;
        }
        Arrays.sort(files, FILE_COMPARATOR);
        for (File file : files) {
            if (!file.isDirectory()) {
                if (this.addResult(result, file)) continue;
                return;
            }
            if ((this.filter == null || this.filter.accept(file)) && !this.addResult(result, file)) {
                return;
            }
            this.findIn(file, result, depth + 1);
        }
    }

    private boolean addResult(List<File> result, File file) {
        if (this.maxResults > 0 && result.size() == this.maxResults) {
            return false;
        }
        result.add(file);
        return true;
    }

    public FileFinder match(FileFilter newFilter) {
        this.filter = newFilter;
        return this;
    }

    public FileFinder matchAll(FileFilter ... filters) {
        this.filter = this.group(true, null, filters);
        return this;
    }

    public FileFinder matchAny(FileFilter ... filters) {
        this.filter = this.group(false, null, filters);
        return this;
    }

    public FileFinder andMatch(FileFilter ... filters) {
        this.filter = this.group(true, this.filter, filters);
        return this;
    }

    public FileFinder orMatch(FileFilter ... filters) {
        this.filter = this.group(false, this.filter, filters);
        return this;
    }

    public FileFinder maxDepth(int depth) {
        this.maxDepth = depth;
        return this;
    }

    public static FileFilter nameFilter(final String ... names) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                for (String n : names) {
                    if (!name.equals(n)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static FileFilter nameIgnoreCaseFilter(final String name) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().equalsIgnoreCase(name);
            }
        };
    }

    public static FileFilter prefixFilter(final String ... prefixes) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                for (String prefix : prefixes) {
                    if (!name.startsWith(prefix)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static FileFilter prefixIgnoreCaseFilter(String prefix) {
        final String _prefix = prefix.toLowerCase();
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().startsWith(_prefix);
            }
        };
    }

    public static FileFilter suffixFilter(final String ... suffixes) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                for (String suffix : suffixes) {
                    if (!name.endsWith(suffix)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static FileFilter suffixIgnoreCaseFilter(String suffix) {
        final String _suffix = suffix.toLowerCase();
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith(_suffix);
            }
        };
    }

    public static FileFilter namePartFilter(final String ... parts) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                for (String part : parts) {
                    if (!name.contains(part)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static FileFilter namePartIgnoreCaseFilter(String part) {
        final String _part = part.toLowerCase();
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().contains(_part);
            }
        };
    }

    public static FileFilter regexFilter(final String ... regexes) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                for (String regex : regexes) {
                    if (!FileFinder.getPattern(regex).matcher(name).matches()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static FileFilter regexFilter(final Pattern ... patterns) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                for (Pattern pattern : patterns) {
                    if (!pattern.matcher(name).matches()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static Pattern getPattern(String regex) {
        Pattern pattern = PATTERN_CACHE.get(regex);
        if (pattern != null) {
            return pattern;
        }
        pattern = Pattern.compile(regex);
        PATTERN_CACHE.put(regex, pattern);
        return pattern;
    }
}

