#!/bin/ksh

# Script para gerao da chave privada e do certificado digital para
# conexo com o OpenBus.
# 
# $Id$

# Padro  usar do host
OPENSSL_CMD=openssl
sslConfig=

scriptName=$(basename $0)

function usage {
    cat << EOF

Uso: $scriptName [opcoes]

  onde [opcoes] sao:

  -h      : ajuda
  -c arq  : arquivo de configuracao do OpenSSL
  -n nome : nome da entidade para a qual a chave privada e o certificado sero gerados

OBS.: se o nome nao for fornecido via '-n' sera obtido interativamente
EOF
}

function die {
        echo $@
        exit 1
}

function checkOpenSSL {
  which openssl > /dev/null 2>&1
  if [ $? == "1" ]; then
    echo "============================================================="
    echo "[ERRO] O aplicativo 'openssl' no foi encontrado."
    echo "============================================================="
    return 1
  fi
}

while getopts "hc:n:" params; do
     case $params in
        h)
            usage
            exit 0
        ;;
        c)
            sslConfig="-config $OPTARG"
        ;;
        n)
            entityName="$OPTARG"
        ;;
        *)
            usage
            exit 1
        ;;
     esac
done

# descartamos os parametros processados
shift $((OPTIND - 1))

if [ -z "$entityName" ]; then
  echo -n "Digite o nome da chave: "
  read entityName
fi

# OpenBus configurado, usar nossa instalao. Seno, usar do host.
if [ -n "${OPENBUS_HOME}" ]; then
  OPENSSL_CMD="${OPENBUS_HOME}/bin/openssl"
  # Verifica se o OpenBus instalou o OpenSSL, caso contrrio, mantm o padro.
  if [ -x "${OPENSSL_CMD}" ]; then
    export OPENSSL_HOME="${OPENBUS_HOME}/openssl"
  else
    checkOpenSSL
    OPENSSL_CMD=openssl
  fi
  # Se usurio no informar arquivo de configurao usaremos aquele distribudo no OpenBus.
  if [ -z "$sslConfig" ]; then
    sslConfig="-config ${OPENBUS_HOME}/openssl/openssl.cnf"
  fi
else
  checkOpenSSL
fi

echo "============================================================="
echo "Criando certificados para o Openbus ..."
echo "Comando 'openssl' utilizado : ${OPENSSL_CMD}"
echo "============================================================="

${OPENSSL_CMD} genrsa -out ${entityName}_openssl.key 2048 || exit 1

${OPENSSL_CMD} pkcs8 -topk8 -nocrypt \
    -in ${entityName}_openssl.key \
    -out ${entityName}.key -outform DER \
    || exit 1

${OPENSSL_CMD} req ${sslConfig} -new -x509 \
    -key ${entityName}.key -keyform DER \
    -out ${entityName}.crt -outform DER \
    || exit 1

rm -f ${entityName}_openssl.key

echo "============================================================="
echo "Chave privada : ${entityName}.key"
echo "Certificado   : ${entityName}.crt"
echo "============================================================="
