#ifndef RECEPTACLE_H
#define RECEPTACLE_H

#include <scs/private/config.h>

#ifndef SCS_ORBIX
#  include <CORBA.h>
#  include <stubs/scs.h>
#else
#  include <cstdio> // Orbix uses EOF without including this header
#  include <stubs/orbix/scsS.hh>
#  include <orbix/corba.hh>
#endif

#include <list>
#include <map>
#include <string>

namespace scs {
  namespace core {
    /*
     * Classe criada para facilitar o gerenciamento dos receptaculos no servant da
     * interface IReceptacles.
     */
    struct Receptacle
    {
      std::string name, interface_name;
      bool multiplexed;
      std::map<ConnectionId, CORBA::Object_var> connections;

      Receptacle(std::string name, std::string interface_name
                 , bool multiplexed)
        : name(name), interface_name(interface_name)
        , multiplexed(multiplexed) {}
    };
  }
}
#endif // RECEPTACLE_H
