/*
** IReceptacles.h
*/

#ifndef IRECEPTACLESORBIX_H
#define IRECEPTACLESORBIX_H

#include <scs/private/config.h>
#include <scs/ComponentContext.h>

#ifndef SCS_ORBIX
#  include <CORBA.h>
#  include <stubs/scs.h>
#else
#  include <cstdio> // Orbix uses EOF without including this header
#  include <stubs/orbix/scsS.hh>
#  include <orbix/corba.hh>
#endif

namespace scs {
  namespace core {
    //! Implementacao do servant da interface scs.core.IReceptacles
    class SCS_DECL IReceptaclesImpl : virtual public POA_scs::core::IReceptacles
                           , virtual public PortableServer::RefCountServantBase
    {
    private:
      ComponentContext* component;
      int connectionCounter;
      int connectionLimit;

    public:
      /**
       * \brief Construtor
       *
       * \param component Referencia para uma instancia de ComponentContext
       */
      IReceptaclesImpl(ComponentContext& component);
      //! Destrutor
      ~IReceptaclesImpl();
      /**
       * \brief Implementacao para conectar um objeto a um receptaculo
       *
       * \param receptacle O nome do receptaculo
       * \param obj Objeto a se conectar
       *
       * \return O identificador da conexao criada.
       *
       * A complexidade desta funcao e O(n+log n+log m), onde n e o numero de
       * receptaculos no componente, e m e a media de conexoes por
       * receptaculo.
       */
      ConnectionId connect (const char* receptacle, CORBA::Object_ptr obj)
        throw(
          InvalidName, 
          InvalidConnection, 
          AlreadyConnected,
          ExceededConnectionLimit);

      /**
       * \brief Implementacao para fazer uma desconexao
       *
       * \param id Identificador da conexao
       *
       * A complexidade desta funcao e O(n*m), onde n e o numero de
       * receptaculos no componente, e m e a media de conexoes por
       * receptaculo.
       */
      void disconnect (ConnectionId id)
        throw(
          InvalidConnection, 
          NoConnection);

      /**
       * \brief Retorna as descricoes de todas as conexoes de um receptaculo
       *
       * \param receptacle Nome do receptaculo
       *
       * A complexidade desta funcao e O(log m + n), onde n e o numero
       * de conexoes do receptaculo e m e o numero de receptaculos do
       * componente
       */
      ConnectionDescriptions* getConnections (const char* receptacle)
        throw(InvalidName);
    };
  }
}

#endif

