/*
 *  MICO --- an Open Source CORBA implementation
 *  Copyright (c) 1997-2006 by The Mico Team
 *
 *  This file was automatically generated. DO NOT EDIT!
 */

#include <CORBA.h>
#include <mico/throw.h>

#ifndef __ACCESS_CONTROL_SERVICE_H__
#define __ACCESS_CONTROL_SERVICE_H__






namespace tecgraf
{
namespace openbus
{
namespace core
{
namespace v1_05
{
namespace access_control_service
{

class ICredentialObserver;
typedef ICredentialObserver *ICredentialObserver_ptr;
typedef ICredentialObserver_ptr ICredentialObserverRef;
typedef ObjVar< ICredentialObserver > ICredentialObserver_var;
typedef ObjOut< ICredentialObserver > ICredentialObserver_out;

class ILeaseProvider;
typedef ILeaseProvider *ILeaseProvider_ptr;
typedef ILeaseProvider_ptr ILeaseProviderRef;
typedef ObjVar< ILeaseProvider > ILeaseProvider_var;
typedef ObjOut< ILeaseProvider > ILeaseProvider_out;

class IAccessControlService;
typedef IAccessControlService *IAccessControlService_ptr;
typedef IAccessControlService_ptr IAccessControlServiceRef;
typedef ObjVar< IAccessControlService > IAccessControlService_var;
typedef ObjOut< IAccessControlService > IAccessControlService_out;

class IManagement;
typedef IManagement *IManagement_ptr;
typedef IManagement_ptr IManagementRef;
typedef ObjVar< IManagement > IManagement_var;
typedef ObjOut< IManagement > IManagement_out;

}
}
}
}
}



#include <core.h>
#include <scs.h>



namespace tecgraf
{
namespace openbus
{
namespace core
{
namespace v1_05
{
namespace access_control_service
{

typedef char* CredentialIdentifier;
typedef CORBA::String_var CredentialIdentifier_var;
typedef CORBA::String_out CredentialIdentifier_out;

extern CORBA::TypeCodeConst _tc_CredentialIdentifier;

typedef StringSequenceTmpl<CORBA::String_var> CredentialIdentifierList;
typedef TSeqVar< StringSequenceTmpl<CORBA::String_var> > CredentialIdentifierList_var;
typedef TSeqOut< StringSequenceTmpl<CORBA::String_var> > CredentialIdentifierList_out;

extern CORBA::TypeCodeConst _tc_CredentialIdentifierList;

typedef char* CredentialObserverIdentifier;
typedef CORBA::String_var CredentialObserverIdentifier_var;
typedef CORBA::String_out CredentialObserverIdentifier_out;

extern CORBA::TypeCodeConst _tc_CredentialObserverIdentifier;

typedef StringSequenceTmpl<CORBA::String_var> CredentialObserverIdentifierList;
typedef TSeqVar< StringSequenceTmpl<CORBA::String_var> > CredentialObserverIdentifierList_var;
typedef TSeqOut< StringSequenceTmpl<CORBA::String_var> > CredentialObserverIdentifierList_out;

extern CORBA::TypeCodeConst _tc_CredentialObserverIdentifierList;

struct Credential;
typedef TVarVar< Credential > Credential_var;
typedef TVarOut< Credential > Credential_out;


struct Credential {
  #ifdef HAVE_TYPEDEF_OVERLOAD
  typedef Credential_var _var_type;
  #endif
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  Credential();
  ~Credential();
  Credential( const Credential& s );
  Credential& operator=( const Credential& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  CredentialIdentifier_var identifier;
  CORBA::String_var owner;
  CORBA::String_var delegate;
};

extern CORBA::TypeCodeConst _tc_Credential;

typedef SequenceTmpl< Credential,MICO_TID_DEF> CredentialSeq;
typedef TSeqVar< SequenceTmpl< Credential,MICO_TID_DEF> > CredentialSeq_var;
typedef TSeqOut< SequenceTmpl< Credential,MICO_TID_DEF> > CredentialSeq_out;

extern CORBA::TypeCodeConst _tc_CredentialSeq;


/*
 * Base class and common definitions for interface ICredentialObserver
 */

class ICredentialObserver : 
  virtual public CORBA::Object
{
  public:
    virtual ~ICredentialObserver();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef ICredentialObserver_ptr _ptr_type;
    typedef ICredentialObserver_var _var_type;
    #endif

    static ICredentialObserver_ptr _narrow( CORBA::Object_ptr obj );
    static ICredentialObserver_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static ICredentialObserver_ptr _duplicate( ICredentialObserver_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static ICredentialObserver_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual void credentialWasDeleted( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential ) = 0;

  protected:
    ICredentialObserver() {};
  private:
    ICredentialObserver( const ICredentialObserver& );
    void operator=( const ICredentialObserver& );
};

extern CORBA::TypeCodeConst _tc_ICredentialObserver;

// Stub for interface ICredentialObserver
class ICredentialObserver_stub:
  virtual public ICredentialObserver
{
  public:
    virtual ~ICredentialObserver_stub();
    void credentialWasDeleted( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential );

  private:
    void operator=( const ICredentialObserver_stub& );
};

#ifndef MICO_CONF_NO_POA

class ICredentialObserver_stub_clp :
  virtual public ICredentialObserver_stub,
  virtual public PortableServer::StubBase
{
  public:
    ICredentialObserver_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~ICredentialObserver_stub_clp ();
    void credentialWasDeleted( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential );

  protected:
    ICredentialObserver_stub_clp ();
  private:
    void operator=( const ICredentialObserver_stub_clp & );
};

#endif // MICO_CONF_NO_POA

typedef CORBA::Long Lease;
typedef Lease& Lease_out;
extern CORBA::TypeCodeConst _tc_Lease;


/*
 * Base class and common definitions for interface ILeaseProvider
 */

class ILeaseProvider : 
  virtual public CORBA::Object
{
  public:
    virtual ~ILeaseProvider();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef ILeaseProvider_ptr _ptr_type;
    typedef ILeaseProvider_var _var_type;
    #endif

    static ILeaseProvider_ptr _narrow( CORBA::Object_ptr obj );
    static ILeaseProvider_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static ILeaseProvider_ptr _duplicate( ILeaseProvider_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static ILeaseProvider_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual CORBA::Boolean renewLease( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential, ::tecgraf::openbus::core::v1_05::access_control_service::Lease_out aLease ) = 0;

  protected:
    ILeaseProvider() {};
  private:
    ILeaseProvider( const ILeaseProvider& );
    void operator=( const ILeaseProvider& );
};

extern CORBA::TypeCodeConst _tc_ILeaseProvider;

// Stub for interface ILeaseProvider
class ILeaseProvider_stub:
  virtual public ILeaseProvider
{
  public:
    virtual ~ILeaseProvider_stub();
    CORBA::Boolean renewLease( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential, ::tecgraf::openbus::core::v1_05::access_control_service::Lease_out aLease );

  private:
    void operator=( const ILeaseProvider_stub& );
};

#ifndef MICO_CONF_NO_POA

class ILeaseProvider_stub_clp :
  virtual public ILeaseProvider_stub,
  virtual public PortableServer::StubBase
{
  public:
    ILeaseProvider_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~ILeaseProvider_stub_clp ();
    CORBA::Boolean renewLease( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential, ::tecgraf::openbus::core::v1_05::access_control_service::Lease_out aLease );

  protected:
    ILeaseProvider_stub_clp ();
  private:
    void operator=( const ILeaseProvider_stub_clp & );
};

#endif // MICO_CONF_NO_POA

struct EntryCredential;
typedef TVarVar< EntryCredential > EntryCredential_var;
typedef TVarOut< EntryCredential > EntryCredential_out;


struct EntryCredential {
  #ifdef HAVE_TYPEDEF_OVERLOAD
  typedef EntryCredential_var _var_type;
  #endif
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  EntryCredential();
  ~EntryCredential();
  EntryCredential( const EntryCredential& s );
  EntryCredential& operator=( const EntryCredential& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  Credential aCredential;
  CORBA::Boolean certified;
  CredentialObserverIdentifierList observers;
  CredentialObserverIdentifierList observedBy;
};

extern CORBA::TypeCodeConst _tc_EntryCredential;

typedef SequenceTmpl< EntryCredential,MICO_TID_DEF> EntryCredentialSeq;
typedef TSeqVar< SequenceTmpl< EntryCredential,MICO_TID_DEF> > EntryCredentialSeq_var;
typedef TSeqOut< SequenceTmpl< EntryCredential,MICO_TID_DEF> > EntryCredentialSeq_out;

extern CORBA::TypeCodeConst _tc_EntryCredentialSeq;


/*
 * Base class and common definitions for interface IAccessControlService
 */

class IAccessControlService : 
  virtual public CORBA::Object
{
  public:
    virtual ~IAccessControlService();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef IAccessControlService_ptr _ptr_type;
    typedef IAccessControlService_var _var_type;
    #endif

    static IAccessControlService_ptr _narrow( CORBA::Object_ptr obj );
    static IAccessControlService_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static IAccessControlService_ptr _duplicate( IAccessControlService_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static IAccessControlService_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual CORBA::Boolean loginByPassword( const char* name, const char* password, ::tecgraf::openbus::core::v1_05::access_control_service::Credential_out aCredential, ::tecgraf::openbus::core::v1_05::access_control_service::Lease_out aLease ) = 0;
    virtual CORBA::Boolean loginByCertificate( const char* name, const ::tecgraf::openbus::core::v1_05::OctetSeq& answer, ::tecgraf::openbus::core::v1_05::access_control_service::Credential_out aCredential, ::tecgraf::openbus::core::v1_05::access_control_service::Lease_out aLease ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::OctetSeq* getChallenge( const char* name ) = 0;
    virtual CORBA::Boolean logout( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential ) = 0;
    virtual CORBA::Boolean isValid( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::BooleanSeq* areValid( const ::tecgraf::openbus::core::v1_05::access_control_service::CredentialSeq& credentials ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::EntryCredential* getEntryCredential( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::EntryCredentialSeq* getAllEntryCredential() = 0;
    virtual char* addObserver( ::tecgraf::openbus::core::v1_05::access_control_service::ICredentialObserver_ptr observer, const ::tecgraf::openbus::core::v1_05::access_control_service::CredentialIdentifierList& someCredentialIdentifiers ) = 0;
    virtual CORBA::Boolean removeObserver( const char* identifier ) = 0;
    virtual CORBA::Boolean addCredentialToObserver( const char* observerIdentifier, const char* aCredentialIdentifier ) = 0;
    virtual CORBA::Boolean removeCredentialFromObserver( const char* observerIdentifier, const char* aCredentialIdentifier ) = 0;

  protected:
    IAccessControlService() {};
  private:
    IAccessControlService( const IAccessControlService& );
    void operator=( const IAccessControlService& );
};

extern CORBA::TypeCodeConst _tc_IAccessControlService;

// Stub for interface IAccessControlService
class IAccessControlService_stub:
  virtual public IAccessControlService
{
  public:
    virtual ~IAccessControlService_stub();
    CORBA::Boolean loginByPassword( const char* name, const char* password, ::tecgraf::openbus::core::v1_05::access_control_service::Credential_out aCredential, ::tecgraf::openbus::core::v1_05::access_control_service::Lease_out aLease );
    CORBA::Boolean loginByCertificate( const char* name, const ::tecgraf::openbus::core::v1_05::OctetSeq& answer, ::tecgraf::openbus::core::v1_05::access_control_service::Credential_out aCredential, ::tecgraf::openbus::core::v1_05::access_control_service::Lease_out aLease );
    ::tecgraf::openbus::core::v1_05::OctetSeq* getChallenge( const char* name );
    CORBA::Boolean logout( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential );
    CORBA::Boolean isValid( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential );
    ::tecgraf::openbus::core::v1_05::BooleanSeq* areValid( const ::tecgraf::openbus::core::v1_05::access_control_service::CredentialSeq& credentials );
    ::tecgraf::openbus::core::v1_05::access_control_service::EntryCredential* getEntryCredential( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential );
    ::tecgraf::openbus::core::v1_05::access_control_service::EntryCredentialSeq* getAllEntryCredential();
    char* addObserver( ::tecgraf::openbus::core::v1_05::access_control_service::ICredentialObserver_ptr observer, const ::tecgraf::openbus::core::v1_05::access_control_service::CredentialIdentifierList& someCredentialIdentifiers );
    CORBA::Boolean removeObserver( const char* identifier );
    CORBA::Boolean addCredentialToObserver( const char* observerIdentifier, const char* aCredentialIdentifier );
    CORBA::Boolean removeCredentialFromObserver( const char* observerIdentifier, const char* aCredentialIdentifier );

  private:
    void operator=( const IAccessControlService_stub& );
};

#ifndef MICO_CONF_NO_POA

class IAccessControlService_stub_clp :
  virtual public IAccessControlService_stub,
  virtual public PortableServer::StubBase
{
  public:
    IAccessControlService_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~IAccessControlService_stub_clp ();
    CORBA::Boolean loginByPassword( const char* name, const char* password, ::tecgraf::openbus::core::v1_05::access_control_service::Credential_out aCredential, ::tecgraf::openbus::core::v1_05::access_control_service::Lease_out aLease );
    CORBA::Boolean loginByCertificate( const char* name, const ::tecgraf::openbus::core::v1_05::OctetSeq& answer, ::tecgraf::openbus::core::v1_05::access_control_service::Credential_out aCredential, ::tecgraf::openbus::core::v1_05::access_control_service::Lease_out aLease );
    ::tecgraf::openbus::core::v1_05::OctetSeq* getChallenge( const char* name );
    CORBA::Boolean logout( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential );
    CORBA::Boolean isValid( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential );
    ::tecgraf::openbus::core::v1_05::BooleanSeq* areValid( const ::tecgraf::openbus::core::v1_05::access_control_service::CredentialSeq& credentials );
    ::tecgraf::openbus::core::v1_05::access_control_service::EntryCredential* getEntryCredential( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential );
    ::tecgraf::openbus::core::v1_05::access_control_service::EntryCredentialSeq* getAllEntryCredential();
    char* addObserver( ::tecgraf::openbus::core::v1_05::access_control_service::ICredentialObserver_ptr observer, const ::tecgraf::openbus::core::v1_05::access_control_service::CredentialIdentifierList& someCredentialIdentifiers );
    CORBA::Boolean removeObserver( const char* identifier );
    CORBA::Boolean addCredentialToObserver( const char* observerIdentifier, const char* aCredentialIdentifier );
    CORBA::Boolean removeCredentialFromObserver( const char* observerIdentifier, const char* aCredentialIdentifier );

  protected:
    IAccessControlService_stub_clp ();
  private:
    void operator=( const IAccessControlService_stub_clp & );
};

#endif // MICO_CONF_NO_POA

struct System;
typedef TVarVar< System > System_var;
typedef TVarOut< System > System_out;


struct System {
  #ifdef HAVE_TYPEDEF_OVERLOAD
  typedef System_var _var_type;
  #endif
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  System();
  ~System();
  System( const System& s );
  System& operator=( const System& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  CORBA::String_var id;
  CORBA::String_var description;
};

extern CORBA::TypeCodeConst _tc_System;

typedef SequenceTmpl< System,MICO_TID_DEF> SystemList;
typedef TSeqVar< SequenceTmpl< System,MICO_TID_DEF> > SystemList_var;
typedef TSeqOut< SequenceTmpl< System,MICO_TID_DEF> > SystemList_out;

extern CORBA::TypeCodeConst _tc_SystemList;

struct SystemAlreadyExists : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  SystemAlreadyExists();
  ~SystemAlreadyExists();
  SystemAlreadyExists( const SystemAlreadyExists& s );
  SystemAlreadyExists& operator=( const SystemAlreadyExists& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  SystemAlreadyExists *operator->() { return this; }
  SystemAlreadyExists& operator*() { return *this; }
  operator SystemAlreadyExists*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static SystemAlreadyExists *_downcast( CORBA::Exception *ex );
  static const SystemAlreadyExists *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef SystemAlreadyExists SystemAlreadyExists_catch;
#else
typedef ExceptVar< SystemAlreadyExists > SystemAlreadyExists_var;
typedef TVarOut< SystemAlreadyExists > SystemAlreadyExists_out;
typedef SystemAlreadyExists_var SystemAlreadyExists_catch;
#endif // HAVE_STD_EH

extern CORBA::TypeCodeConst _tc_SystemAlreadyExists;

struct SystemInUse : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  SystemInUse();
  ~SystemInUse();
  SystemInUse( const SystemInUse& s );
  SystemInUse& operator=( const SystemInUse& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  SystemInUse *operator->() { return this; }
  SystemInUse& operator*() { return *this; }
  operator SystemInUse*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static SystemInUse *_downcast( CORBA::Exception *ex );
  static const SystemInUse *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef SystemInUse SystemInUse_catch;
#else
typedef ExceptVar< SystemInUse > SystemInUse_var;
typedef TVarOut< SystemInUse > SystemInUse_out;
typedef SystemInUse_var SystemInUse_catch;
#endif // HAVE_STD_EH

extern CORBA::TypeCodeConst _tc_SystemInUse;

struct SystemNonExistent : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  SystemNonExistent();
  ~SystemNonExistent();
  SystemNonExistent( const SystemNonExistent& s );
  SystemNonExistent& operator=( const SystemNonExistent& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  SystemNonExistent *operator->() { return this; }
  SystemNonExistent& operator*() { return *this; }
  operator SystemNonExistent*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static SystemNonExistent *_downcast( CORBA::Exception *ex );
  static const SystemNonExistent *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef SystemNonExistent SystemNonExistent_catch;
#else
typedef ExceptVar< SystemNonExistent > SystemNonExistent_var;
typedef TVarOut< SystemNonExistent > SystemNonExistent_out;
typedef SystemNonExistent_var SystemNonExistent_catch;
#endif // HAVE_STD_EH

extern CORBA::TypeCodeConst _tc_SystemNonExistent;

struct SystemDeployment;
typedef TVarVar< SystemDeployment > SystemDeployment_var;
typedef TVarOut< SystemDeployment > SystemDeployment_out;


struct SystemDeployment {
  #ifdef HAVE_TYPEDEF_OVERLOAD
  typedef SystemDeployment_var _var_type;
  #endif
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  SystemDeployment();
  ~SystemDeployment();
  SystemDeployment( const SystemDeployment& s );
  SystemDeployment& operator=( const SystemDeployment& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  CORBA::String_var id;
  CORBA::String_var systemId;
  CORBA::String_var description;
};

extern CORBA::TypeCodeConst _tc_SystemDeployment;

typedef SequenceTmpl< SystemDeployment,MICO_TID_DEF> SystemDeploymentList;
typedef TSeqVar< SequenceTmpl< SystemDeployment,MICO_TID_DEF> > SystemDeploymentList_var;
typedef TSeqOut< SequenceTmpl< SystemDeployment,MICO_TID_DEF> > SystemDeploymentList_out;

extern CORBA::TypeCodeConst _tc_SystemDeploymentList;

typedef SequenceTmpl< CORBA::Octet,MICO_TID_OCTET> SystemDeploymentCertificate;
typedef TSeqVar< SequenceTmpl< CORBA::Octet,MICO_TID_OCTET> > SystemDeploymentCertificate_var;
typedef TSeqOut< SequenceTmpl< CORBA::Octet,MICO_TID_OCTET> > SystemDeploymentCertificate_out;

extern CORBA::TypeCodeConst _tc_SystemDeploymentCertificate;

struct InvalidCertificate : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  InvalidCertificate();
  ~InvalidCertificate();
  InvalidCertificate( const InvalidCertificate& s );
  InvalidCertificate& operator=( const InvalidCertificate& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  InvalidCertificate *operator->() { return this; }
  InvalidCertificate& operator*() { return *this; }
  operator InvalidCertificate*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static InvalidCertificate *_downcast( CORBA::Exception *ex );
  static const InvalidCertificate *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef InvalidCertificate InvalidCertificate_catch;
#else
typedef ExceptVar< InvalidCertificate > InvalidCertificate_var;
typedef TVarOut< InvalidCertificate > InvalidCertificate_out;
typedef InvalidCertificate_var InvalidCertificate_catch;
#endif // HAVE_STD_EH

extern CORBA::TypeCodeConst _tc_InvalidCertificate;

struct SystemDeploymentAlreadyExists : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  SystemDeploymentAlreadyExists();
  ~SystemDeploymentAlreadyExists();
  SystemDeploymentAlreadyExists( const SystemDeploymentAlreadyExists& s );
  SystemDeploymentAlreadyExists& operator=( const SystemDeploymentAlreadyExists& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  SystemDeploymentAlreadyExists *operator->() { return this; }
  SystemDeploymentAlreadyExists& operator*() { return *this; }
  operator SystemDeploymentAlreadyExists*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static SystemDeploymentAlreadyExists *_downcast( CORBA::Exception *ex );
  static const SystemDeploymentAlreadyExists *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef SystemDeploymentAlreadyExists SystemDeploymentAlreadyExists_catch;
#else
typedef ExceptVar< SystemDeploymentAlreadyExists > SystemDeploymentAlreadyExists_var;
typedef TVarOut< SystemDeploymentAlreadyExists > SystemDeploymentAlreadyExists_out;
typedef SystemDeploymentAlreadyExists_var SystemDeploymentAlreadyExists_catch;
#endif // HAVE_STD_EH

extern CORBA::TypeCodeConst _tc_SystemDeploymentAlreadyExists;

struct SystemDeploymentNonExistent : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  SystemDeploymentNonExistent();
  ~SystemDeploymentNonExistent();
  SystemDeploymentNonExistent( const SystemDeploymentNonExistent& s );
  SystemDeploymentNonExistent& operator=( const SystemDeploymentNonExistent& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  SystemDeploymentNonExistent *operator->() { return this; }
  SystemDeploymentNonExistent& operator*() { return *this; }
  operator SystemDeploymentNonExistent*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static SystemDeploymentNonExistent *_downcast( CORBA::Exception *ex );
  static const SystemDeploymentNonExistent *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef SystemDeploymentNonExistent SystemDeploymentNonExistent_catch;
#else
typedef ExceptVar< SystemDeploymentNonExistent > SystemDeploymentNonExistent_var;
typedef TVarOut< SystemDeploymentNonExistent > SystemDeploymentNonExistent_out;
typedef SystemDeploymentNonExistent_var SystemDeploymentNonExistent_catch;
#endif // HAVE_STD_EH

extern CORBA::TypeCodeConst _tc_SystemDeploymentNonExistent;

struct User;
typedef TVarVar< User > User_var;
typedef TVarOut< User > User_out;


struct User {
  #ifdef HAVE_TYPEDEF_OVERLOAD
  typedef User_var _var_type;
  #endif
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  User();
  ~User();
  User( const User& s );
  User& operator=( const User& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  CORBA::String_var id;
  CORBA::String_var name;
};

extern CORBA::TypeCodeConst _tc_User;

typedef SequenceTmpl< User,MICO_TID_DEF> UserList;
typedef TSeqVar< SequenceTmpl< User,MICO_TID_DEF> > UserList_var;
typedef TSeqOut< SequenceTmpl< User,MICO_TID_DEF> > UserList_out;

extern CORBA::TypeCodeConst _tc_UserList;

struct UserAlreadyExists : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  UserAlreadyExists();
  ~UserAlreadyExists();
  UserAlreadyExists( const UserAlreadyExists& s );
  UserAlreadyExists& operator=( const UserAlreadyExists& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  UserAlreadyExists *operator->() { return this; }
  UserAlreadyExists& operator*() { return *this; }
  operator UserAlreadyExists*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static UserAlreadyExists *_downcast( CORBA::Exception *ex );
  static const UserAlreadyExists *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef UserAlreadyExists UserAlreadyExists_catch;
#else
typedef ExceptVar< UserAlreadyExists > UserAlreadyExists_var;
typedef TVarOut< UserAlreadyExists > UserAlreadyExists_out;
typedef UserAlreadyExists_var UserAlreadyExists_catch;
#endif // HAVE_STD_EH

extern CORBA::TypeCodeConst _tc_UserAlreadyExists;

struct UserNonExistent : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  UserNonExistent();
  ~UserNonExistent();
  UserNonExistent( const UserNonExistent& s );
  UserNonExistent& operator=( const UserNonExistent& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  UserNonExistent *operator->() { return this; }
  UserNonExistent& operator*() { return *this; }
  operator UserNonExistent*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static UserNonExistent *_downcast( CORBA::Exception *ex );
  static const UserNonExistent *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef UserNonExistent UserNonExistent_catch;
#else
typedef ExceptVar< UserNonExistent > UserNonExistent_var;
typedef TVarOut< UserNonExistent > UserNonExistent_out;
typedef UserNonExistent_var UserNonExistent_catch;
#endif // HAVE_STD_EH

extern CORBA::TypeCodeConst _tc_UserNonExistent;


/*
 * Base class and common definitions for interface IManagement
 */

class IManagement : 
  virtual public CORBA::Object
{
  public:
    virtual ~IManagement();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef IManagement_ptr _ptr_type;
    typedef IManagement_var _var_type;
    #endif

    static IManagement_ptr _narrow( CORBA::Object_ptr obj );
    static IManagement_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static IManagement_ptr _duplicate( IManagement_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static IManagement_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual void addSystem( const char* id, const char* description ) = 0;
    virtual void removeSystem( const char* id ) = 0;
    virtual void setSystemDescription( const char* id, const char* description ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::SystemList* getSystems() = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::System* getSystem( const char* id ) = 0;
    virtual void addSystemDeployment( const char* id, const char* systemId, const char* description, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentCertificate& certificate ) = 0;
    virtual void removeSystemDeployment( const char* id ) = 0;
    virtual void setSystemDeploymentDescription( const char* id, const char* description ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentCertificate* getSystemDeploymentCertificate( const char* id ) = 0;
    virtual void setSystemDeploymentCertificate( const char* id, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentCertificate& certificate ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentList* getSystemDeployments() = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeployment* getSystemDeployment( const char* id ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentList* getSystemDeploymentsBySystemId( const char* systemId ) = 0;
    virtual void addUser( const char* id, const char* name ) = 0;
    virtual void removeUser( const char* id ) = 0;
    virtual void setUserName( const char* id, const char* name ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::User* getUser( const char* id ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::UserList* getUsers() = 0;

  protected:
    IManagement() {};
  private:
    IManagement( const IManagement& );
    void operator=( const IManagement& );
};

extern CORBA::TypeCodeConst _tc_IManagement;

// Stub for interface IManagement
class IManagement_stub:
  virtual public IManagement
{
  public:
    virtual ~IManagement_stub();
    void addSystem( const char* id, const char* description );
    void removeSystem( const char* id );
    void setSystemDescription( const char* id, const char* description );
    ::tecgraf::openbus::core::v1_05::access_control_service::SystemList* getSystems();
    ::tecgraf::openbus::core::v1_05::access_control_service::System* getSystem( const char* id );
    void addSystemDeployment( const char* id, const char* systemId, const char* description, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentCertificate& certificate );
    void removeSystemDeployment( const char* id );
    void setSystemDeploymentDescription( const char* id, const char* description );
    ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentCertificate* getSystemDeploymentCertificate( const char* id );
    void setSystemDeploymentCertificate( const char* id, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentCertificate& certificate );
    ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentList* getSystemDeployments();
    ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeployment* getSystemDeployment( const char* id );
    ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentList* getSystemDeploymentsBySystemId( const char* systemId );
    void addUser( const char* id, const char* name );
    void removeUser( const char* id );
    void setUserName( const char* id, const char* name );
    ::tecgraf::openbus::core::v1_05::access_control_service::User* getUser( const char* id );
    ::tecgraf::openbus::core::v1_05::access_control_service::UserList* getUsers();

  private:
    void operator=( const IManagement_stub& );
};

#ifndef MICO_CONF_NO_POA

class IManagement_stub_clp :
  virtual public IManagement_stub,
  virtual public PortableServer::StubBase
{
  public:
    IManagement_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~IManagement_stub_clp ();
    void addSystem( const char* id, const char* description );
    void removeSystem( const char* id );
    void setSystemDescription( const char* id, const char* description );
    ::tecgraf::openbus::core::v1_05::access_control_service::SystemList* getSystems();
    ::tecgraf::openbus::core::v1_05::access_control_service::System* getSystem( const char* id );
    void addSystemDeployment( const char* id, const char* systemId, const char* description, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentCertificate& certificate );
    void removeSystemDeployment( const char* id );
    void setSystemDeploymentDescription( const char* id, const char* description );
    ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentCertificate* getSystemDeploymentCertificate( const char* id );
    void setSystemDeploymentCertificate( const char* id, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentCertificate& certificate );
    ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentList* getSystemDeployments();
    ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeployment* getSystemDeployment( const char* id );
    ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentList* getSystemDeploymentsBySystemId( const char* systemId );
    void addUser( const char* id, const char* name );
    void removeUser( const char* id );
    void setUserName( const char* id, const char* name );
    ::tecgraf::openbus::core::v1_05::access_control_service::User* getUser( const char* id );
    ::tecgraf::openbus::core::v1_05::access_control_service::UserList* getUsers();

  protected:
    IManagement_stub_clp ();
  private:
    void operator=( const IManagement_stub_clp & );
};

#endif // MICO_CONF_NO_POA

}
}
}
}
}


#ifndef MICO_CONF_NO_POA



namespace POA_tecgraf
{
namespace openbus
{
namespace core
{
namespace v1_05
{
namespace access_control_service
{

class ICredentialObserver : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~ICredentialObserver ();
    tecgraf::openbus::core::v1_05::access_control_service::ICredentialObserver_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static ICredentialObserver * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual void credentialWasDeleted( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential ) = 0;

  protected:
    ICredentialObserver () {};

  private:
    ICredentialObserver (const ICredentialObserver &);
    void operator= (const ICredentialObserver &);
};

class ILeaseProvider : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~ILeaseProvider ();
    tecgraf::openbus::core::v1_05::access_control_service::ILeaseProvider_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static ILeaseProvider * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual CORBA::Boolean renewLease( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential, ::tecgraf::openbus::core::v1_05::access_control_service::Lease_out aLease ) = 0;

  protected:
    ILeaseProvider () {};

  private:
    ILeaseProvider (const ILeaseProvider &);
    void operator= (const ILeaseProvider &);
};

class IAccessControlService : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~IAccessControlService ();
    tecgraf::openbus::core::v1_05::access_control_service::IAccessControlService_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static IAccessControlService * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual CORBA::Boolean loginByPassword( const char* name, const char* password, ::tecgraf::openbus::core::v1_05::access_control_service::Credential_out aCredential, ::tecgraf::openbus::core::v1_05::access_control_service::Lease_out aLease ) = 0;
    virtual CORBA::Boolean loginByCertificate( const char* name, const ::tecgraf::openbus::core::v1_05::OctetSeq& answer, ::tecgraf::openbus::core::v1_05::access_control_service::Credential_out aCredential, ::tecgraf::openbus::core::v1_05::access_control_service::Lease_out aLease ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::OctetSeq* getChallenge( const char* name ) = 0;
    virtual CORBA::Boolean logout( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential ) = 0;
    virtual CORBA::Boolean isValid( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::BooleanSeq* areValid( const ::tecgraf::openbus::core::v1_05::access_control_service::CredentialSeq& credentials ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::EntryCredential* getEntryCredential( const ::tecgraf::openbus::core::v1_05::access_control_service::Credential& aCredential ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::EntryCredentialSeq* getAllEntryCredential() = 0;
    virtual char* addObserver( ::tecgraf::openbus::core::v1_05::access_control_service::ICredentialObserver_ptr observer, const ::tecgraf::openbus::core::v1_05::access_control_service::CredentialIdentifierList& someCredentialIdentifiers ) = 0;
    virtual CORBA::Boolean removeObserver( const char* identifier ) = 0;
    virtual CORBA::Boolean addCredentialToObserver( const char* observerIdentifier, const char* aCredentialIdentifier ) = 0;
    virtual CORBA::Boolean removeCredentialFromObserver( const char* observerIdentifier, const char* aCredentialIdentifier ) = 0;

  protected:
    IAccessControlService () {};

  private:
    IAccessControlService (const IAccessControlService &);
    void operator= (const IAccessControlService &);
};

class IManagement : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~IManagement ();
    tecgraf::openbus::core::v1_05::access_control_service::IManagement_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static IManagement * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual void addSystem( const char* id, const char* description ) = 0;
    virtual void removeSystem( const char* id ) = 0;
    virtual void setSystemDescription( const char* id, const char* description ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::SystemList* getSystems() = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::System* getSystem( const char* id ) = 0;
    virtual void addSystemDeployment( const char* id, const char* systemId, const char* description, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentCertificate& certificate ) = 0;
    virtual void removeSystemDeployment( const char* id ) = 0;
    virtual void setSystemDeploymentDescription( const char* id, const char* description ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentCertificate* getSystemDeploymentCertificate( const char* id ) = 0;
    virtual void setSystemDeploymentCertificate( const char* id, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentCertificate& certificate ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentList* getSystemDeployments() = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeployment* getSystemDeployment( const char* id ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentList* getSystemDeploymentsBySystemId( const char* systemId ) = 0;
    virtual void addUser( const char* id, const char* name ) = 0;
    virtual void removeUser( const char* id ) = 0;
    virtual void setUserName( const char* id, const char* name ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::User* getUser( const char* id ) = 0;
    virtual ::tecgraf::openbus::core::v1_05::access_control_service::UserList* getUsers() = 0;

  protected:
    IManagement () {};

  private:
    IManagement (const IManagement &);
    void operator= (const IManagement &);
};

}
}
}
}
}


#endif // MICO_CONF_NO_POA

void operator<<=( CORBA::Any &_a, const ::tecgraf::openbus::core::v1_05::access_control_service::Credential &_s );
void operator<<=( CORBA::Any &_a, ::tecgraf::openbus::core::v1_05::access_control_service::Credential *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, ::tecgraf::openbus::core::v1_05::access_control_service::Credential &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const ::tecgraf::openbus::core::v1_05::access_control_service::Credential *&_s );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_Credential;

void operator<<=( CORBA::Any &a, const tecgraf::openbus::core::v1_05::access_control_service::ICredentialObserver_ptr obj );
void operator<<=( CORBA::Any &a, tecgraf::openbus::core::v1_05::access_control_service::ICredentialObserver_ptr* obj_ptr );
CORBA::Boolean operator>>=( const CORBA::Any &a, tecgraf::openbus::core::v1_05::access_control_service::ICredentialObserver_ptr &obj );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_ICredentialObserver;

void operator<<=( CORBA::Any &a, const tecgraf::openbus::core::v1_05::access_control_service::ILeaseProvider_ptr obj );
void operator<<=( CORBA::Any &a, tecgraf::openbus::core::v1_05::access_control_service::ILeaseProvider_ptr* obj_ptr );
CORBA::Boolean operator>>=( const CORBA::Any &a, tecgraf::openbus::core::v1_05::access_control_service::ILeaseProvider_ptr &obj );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_ILeaseProvider;

void operator<<=( CORBA::Any &_a, const ::tecgraf::openbus::core::v1_05::access_control_service::EntryCredential &_s );
void operator<<=( CORBA::Any &_a, ::tecgraf::openbus::core::v1_05::access_control_service::EntryCredential *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, ::tecgraf::openbus::core::v1_05::access_control_service::EntryCredential &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const ::tecgraf::openbus::core::v1_05::access_control_service::EntryCredential *&_s );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_EntryCredential;

void operator<<=( CORBA::Any &a, const tecgraf::openbus::core::v1_05::access_control_service::IAccessControlService_ptr obj );
void operator<<=( CORBA::Any &a, tecgraf::openbus::core::v1_05::access_control_service::IAccessControlService_ptr* obj_ptr );
CORBA::Boolean operator>>=( const CORBA::Any &a, tecgraf::openbus::core::v1_05::access_control_service::IAccessControlService_ptr &obj );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_IAccessControlService;

void operator<<=( CORBA::Any &_a, const ::tecgraf::openbus::core::v1_05::access_control_service::System &_s );
void operator<<=( CORBA::Any &_a, ::tecgraf::openbus::core::v1_05::access_control_service::System *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, ::tecgraf::openbus::core::v1_05::access_control_service::System &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const ::tecgraf::openbus::core::v1_05::access_control_service::System *&_s );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_System;

void operator<<=( CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemAlreadyExists &e );
void operator<<=( CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::SystemAlreadyExists *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::SystemAlreadyExists &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemAlreadyExists *&e );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_SystemAlreadyExists;

void operator<<=( CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemInUse &e );
void operator<<=( CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::SystemInUse *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::SystemInUse &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemInUse *&e );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_SystemInUse;

void operator<<=( CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemNonExistent &e );
void operator<<=( CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::SystemNonExistent *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::SystemNonExistent &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemNonExistent *&e );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_SystemNonExistent;

void operator<<=( CORBA::Any &_a, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeployment &_s );
void operator<<=( CORBA::Any &_a, ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeployment *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeployment &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeployment *&_s );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_SystemDeployment;

void operator<<=( CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::InvalidCertificate &e );
void operator<<=( CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::InvalidCertificate *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::InvalidCertificate &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::InvalidCertificate *&e );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_InvalidCertificate;

void operator<<=( CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentAlreadyExists &e );
void operator<<=( CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentAlreadyExists *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentAlreadyExists &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentAlreadyExists *&e );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_SystemDeploymentAlreadyExists;

void operator<<=( CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentNonExistent &e );
void operator<<=( CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentNonExistent *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentNonExistent &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::SystemDeploymentNonExistent *&e );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_SystemDeploymentNonExistent;

void operator<<=( CORBA::Any &_a, const ::tecgraf::openbus::core::v1_05::access_control_service::User &_s );
void operator<<=( CORBA::Any &_a, ::tecgraf::openbus::core::v1_05::access_control_service::User *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, ::tecgraf::openbus::core::v1_05::access_control_service::User &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const ::tecgraf::openbus::core::v1_05::access_control_service::User *&_s );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_User;

void operator<<=( CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::UserAlreadyExists &e );
void operator<<=( CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::UserAlreadyExists *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::UserAlreadyExists &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::UserAlreadyExists *&e );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_UserAlreadyExists;

void operator<<=( CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::UserNonExistent &e );
void operator<<=( CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::UserNonExistent *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::tecgraf::openbus::core::v1_05::access_control_service::UserNonExistent &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::tecgraf::openbus::core::v1_05::access_control_service::UserNonExistent *&e );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_UserNonExistent;

void operator<<=( CORBA::Any &a, const tecgraf::openbus::core::v1_05::access_control_service::IManagement_ptr obj );
void operator<<=( CORBA::Any &a, tecgraf::openbus::core::v1_05::access_control_service::IManagement_ptr* obj_ptr );
CORBA::Boolean operator>>=( const CORBA::Any &a, tecgraf::openbus::core::v1_05::access_control_service::IManagement_ptr &obj );

extern CORBA::StaticTypeInfo *_marshaller_tecgraf_openbus_core_v1_05_access_control_service_IManagement;

void operator<<=( CORBA::Any &_a, const StringSequenceTmpl<CORBA::String_var> &_s );
void operator<<=( CORBA::Any &_a, StringSequenceTmpl<CORBA::String_var> *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, StringSequenceTmpl<CORBA::String_var> &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const StringSequenceTmpl<CORBA::String_var> *&_s );

void operator<<=( CORBA::Any &_a, const SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::Credential,MICO_TID_DEF> &_s );
void operator<<=( CORBA::Any &_a, SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::Credential,MICO_TID_DEF> *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::Credential,MICO_TID_DEF> &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::Credential,MICO_TID_DEF> *&_s );

extern CORBA::StaticTypeInfo *_marshaller__seq_tecgraf_openbus_core_v1_05_access_control_service_Credential;

void operator<<=( CORBA::Any &_a, const SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::EntryCredential,MICO_TID_DEF> &_s );
void operator<<=( CORBA::Any &_a, SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::EntryCredential,MICO_TID_DEF> *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::EntryCredential,MICO_TID_DEF> &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::EntryCredential,MICO_TID_DEF> *&_s );

extern CORBA::StaticTypeInfo *_marshaller__seq_tecgraf_openbus_core_v1_05_access_control_service_EntryCredential;

void operator<<=( CORBA::Any &_a, const SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::System,MICO_TID_DEF> &_s );
void operator<<=( CORBA::Any &_a, SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::System,MICO_TID_DEF> *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::System,MICO_TID_DEF> &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::System,MICO_TID_DEF> *&_s );

extern CORBA::StaticTypeInfo *_marshaller__seq_tecgraf_openbus_core_v1_05_access_control_service_System;

void operator<<=( CORBA::Any &_a, const SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::SystemDeployment,MICO_TID_DEF> &_s );
void operator<<=( CORBA::Any &_a, SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::SystemDeployment,MICO_TID_DEF> *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::SystemDeployment,MICO_TID_DEF> &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::SystemDeployment,MICO_TID_DEF> *&_s );

extern CORBA::StaticTypeInfo *_marshaller__seq_tecgraf_openbus_core_v1_05_access_control_service_SystemDeployment;

void operator<<=( CORBA::Any &_a, const SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::User,MICO_TID_DEF> &_s );
void operator<<=( CORBA::Any &_a, SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::User,MICO_TID_DEF> *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::User,MICO_TID_DEF> &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const SequenceTmpl< tecgraf::openbus::core::v1_05::access_control_service::User,MICO_TID_DEF> *&_s );

extern CORBA::StaticTypeInfo *_marshaller__seq_tecgraf_openbus_core_v1_05_access_control_service_User;

#endif
