/*
** OpenBus Demo - Mico
** client.cpp
*/

#include <fstream>
#include <iostream>

#include "stubs/hello.h"
#include <openbus.h>

const char *busUser;
const char *busPassword;
const char *facetName;

void commandLineParse(int argc, char **argv) {
  for (short i = 1; i < argc; ++i)
    if (!strcmp(argv[i], "-BusUser"))
      busUser = argv[++i];
    else if (!strcmp(argv[i], "-BusPassword"))
      busPassword = argv[++i];
    else if (!strcmp(argv[i], "-FacetName"))
      facetName = argv[++i];
}

int main(int argc, char **argv) {
  openbus::Openbus *bus;
  tecgraf::openbus::core::v1_05::registry_service::IRegistryService *registryService;

  bus = openbus::Openbus::getInstance();

  bus->init(argc, argv);
  
  commandLineParse(argc, argv);

  std::cout << "Conectando no barramento..." << std::endl;

/* Conexo com o barramento. */
  try {
    registryService = bus->connect(busUser, busPassword);
  } catch (const CORBA::SystemException &) {
    std::cout << "** Nao foi possivel se conectar ao barramento. **" << std::endl
              << "* Falha na comunicacao. *" << std::endl;
    exit(-1);
  } catch (const openbus::LOGIN_FAILURE &) {
    std::cout << "** Nao foi possivel se conectar ao barramento. **" << std::endl
              << "* Par usuario/senha invlido. *" << std::endl;
    exit(-1);
  }

  std::cout << "Conexo com o barramento estabelecida com sucesso!" << std::endl;

/* Define a lista de facetas que caracteriza o servio implementa.
*  O trabalho de criao da lista  facilitado pelo uso da classe 
*  FacetListHelper.
*/
  openbus::util::FacetListHelper facetListHelper;
  facetListHelper.add(facetName);

/* Busca no barramento o servio desejado.
*  Uma lista de *ofertas de servio*  retornada para o usurio.
*  OBS.: Neste demo somente h uma oferta de servio.
*/
  tecgraf::openbus::core::v1_05::registry_service::ServiceOfferList_var serviceOfferList =
    registryService->find(facetListHelper.getFacetList());

  if (!serviceOfferList->length()) {
    std::cout << "Nenhuma oferta encontrada." << std::endl;
  } else {
    tecgraf::openbus::core::v1_05::registry_service::ServiceOffer serviceOffer = serviceOfferList[(CORBA::ULong) 0];
  
    scs::core::IComponent_var component = serviceOffer.member;
    CORBA::Object_var obj = component->getFacet("IDL:demoidl/hello/IHello:1.0");
    demoidl::hello::IHello_var hello = demoidl::hello::IHello::_narrow(obj);

    std::cout << "Fazendo chamada remota sayHello()..." << std::endl;

    hello->sayHello();
  }
  
  std::cout << "Desconectando-se do barramento..." << std::endl;

  bus->disconnect();
  delete bus;

  return 0;
}

