#ifndef TEC_FTC_ABI_SAFE
#define TEC_FTC_ABI_SAFE

#include "ftc_decl.h"
#include <stdio.h>

/** 
 * @brief Classe que representa a API de acesso a um arquivo remoto que
 *        utiliza pImpl para estabilidade de ABI
 */
class ftc_abi_safe
{
public:
    /** 
     * @brief Construtor 
     * 
     * @param id Identificador do arquivo.
     * @param writable Indica se o arquivo deve ser aberto para leitura.
     * @param host Endereço do servidor.
     * @param port Porta TCP do servidor.
     * @param accessKey Chave de acesso ao arquivo.
     */
#if !defined(FTC_DOXYGEN)
    TEC_FTC_DECL
#endif
    ftc_abi_safe(const char* id, bool writable, const char* host
                 , unsigned short port, const char* accessKey);
    /** 
     * @brief Destrutor
     */
#if !defined(FTC_DOXYGEN)
    TEC_FTC_DECL
#endif
    ~ftc_abi_safe();

    /** 
     * @brief Abre o arquivo remoto. 
     * 
     * @param readonly Indica se o arquivo deve ser aberto apenas para leitura.
     */
#if !defined(FTC_DOXYGEN)
    TEC_FTC_DECL
#endif
    void open( bool readonly ) ;


    /** 
     * @brief Indica se o arquivo está aberto.
     * 
     * @return Verdadeiro se o arquivo estiver aberto
     */
#if !defined(FTC_DOXYGEN)
    TEC_FTC_DECL
#endif
    bool isOpen() ;

    /** 
     * @brief Fecha o arquivo. 
     */
#if !defined(FTC_DOXYGEN)
    TEC_FTC_DECL
#endif
    void close() ;

    /** 
     * @brief Posiciona o cursor de leitura no arquivo.
     * 
     * @param position Numero de bytes a partir do inicio do arquivo.
     */
#if !defined(FTC_DOXYGEN)
    TEC_FTC_DECL
#endif
    void setPosition( unsigned long long position ) ;

    /** 
     * @brief Retorna a atual posição do cursor de leitura no arquivo.
     * 
     * @return Posição a partir no inicio do arquivo em bytes. 
     */
#if !defined(FTC_DOXYGEN)
    TEC_FTC_DECL
#endif
    unsigned long long getPosition() const;

    /** 
     * @brief Define o tamanho do arquivo.
     * Pode ser usado para alocar um espaço ou truncar o arquivo. 
     * 
     * @param size Novo tamanho do arquivo em bytes. 
     */
#if !defined(FTC_DOXYGEN)
    TEC_FTC_DECL
#endif
    void setSize( unsigned long long size );

    /** 
     * @brief Retorna o tamanho atual do arquivo. 
     * 
     * @return O numero de bytes que o arquivo possui.
     */
#if !defined(FTC_DOXYGEN)
    TEC_FTC_DECL
#endif
    unsigned long long getSize() const;

    /** 
     * @brief Le uma quantidade de bytes a partir de uma dada posição.
     * 
     * @param data Ponteiro para o espaço onde os bytes lidos serão escritos.
     * @param nbytes Quantidades de bytes a serem lidos. 
     * @param position Posição inicial da leitura.
     * 
     * @return Retorna o numero de bytes lidos.
     */
#if !defined(FTC_DOXYGEN)
    TEC_FTC_DECL
#endif
    unsigned long long read(char* data, unsigned long long nbytes, unsigned long long position);

    /** 
     * @brief Escreve uma quantidade de bytes no arquivo. 
     * 
     * @param data Ponteiro de onde os dados serão lidos.
     * @param nbytes Quantidade de bytes a serem escritos. 
     * @param position Posição inicial da escrita.
     * 
     * @return Retorna a quantidade de bytes escritos. 
     */
#if !defined(FTC_DOXYGEN)
    TEC_FTC_DECL
#endif
    unsigned long long write(const char* data, unsigned long long nbytes, unsigned long long position);

    /** 
     * @brief Transfere os dados do arquivo remoto diretamente para um arquivo
     * local. 
     * 
     * @param position Posição do cursor no arquivo remoto.
     * @param nbytes Quantidade de bytes a serem transferidos.
     * @param fd Descritor do arquivo local.
     * @param buffer Deprecado
     * 
     * @return Retorna o número de bytes escritos.
     */
#if !defined(FTC_DOXYGEN)
    TEC_FTC_DECL
#endif
    unsigned long long transferTo(unsigned long long position, unsigned long long nbytes, FILE* fd, char* buffer);

    struct implementation;
private:
    ftc_abi_safe (ftc_abi_safe const&);
    ftc_abi_safe& operator=(ftc_abi_safe const&);

    implementation* impl;
};

#endif

