#ifndef FTC_SAMPLES_OSTREAM_STREAMBUF_HPP
#define FTC_SAMPLES_OSTREAM_STREAMBUF_HPP

#include "ftc.h"

#include <boost/iostreams/categories.hpp>
#include <boost/shared_ptr.hpp>

#include <iosfwd>
#include <memory>

namespace sample {

struct ftc_source
{
    ftc_source (::ftc* f)
        : position (0ul), ftc_ (f) {}

    typedef char char_type;
    typedef boost::iostreams::source_tag category;

    std::streamsize read (char* buffer, std::streamsize n)
    {
        unsigned long long r = ftc_->read (buffer, n, position);
        if(n && r == 0) // EOF
            return -1;
        else
        {
            position += r;
            std::streamsize r_ = r; // convertion without casting
            return r_;
        }
    }

    void close () { ftc_.reset (); }

    unsigned long long position;
    boost::shared_ptr< ::ftc> ftc_;
};

struct ftc_sink
{
    ftc_sink (::ftc* f)
        : position (0ul), ftc_ (f) {}

    typedef char char_type;
    typedef boost::iostreams::sink_tag category;

    std::streamsize write (const char* buffer, std::streamsize n)
    {
        unsigned long long r = ftc_->write (buffer, n, position);
        position += r;
        std::streamsize r_ = r; // convertion without casting
        return r_;
    }

    void close () { ftc_.reset (); }

    unsigned long long position;
    boost::shared_ptr< ::ftc> ftc_;
};

}

#endif
