
#include "ftc.h"
#include "streambuf.hpp"

#include <openssl/md5.h>

#include <boost/iostreams/stream.hpp>

#include <ostream>
#include <iostream>
#include <iterator>
#include <typeinfo>

int main ()
{
    // Nome do arquivo dentro do servidor
    const char filename[] = "/file";

    // O AccessKey é por enquanto padronizado como sendo a chave
    // MD5 de 16 bytes do path do arquivo
    unsigned char access_key[16];
	  MD5(static_cast<unsigned char const*>( \
            static_cast<void const*>(filename)),sizeof(filename)-1,access_key);

    try
    {
        std::auto_ptr< ::ftc> f (new ::ftc (filename, sizeof(filename), true /* writable */, "localhost"
                                            , 25555 /*port*/, static_cast<const char*>(static_cast<void*>(access_key)), sizeof(access_key)));
        {
            boost::iostreams::stream_buffer<sample::ftc_source>
                read_streambuf (f.release ()); // transfer ownership
            std::istream in (&read_streambuf);

            // reads integer from remote file
            int integer = 0;
            in >> integer; 
        }

        f.reset (new ::ftc (filename, sizeof(filename), true /* writable */, "localhost"
                            , 25555 /*port*/, static_cast<const char*>(static_cast<void*>(access_key)),sizeof(access_key) ));
        {
            boost::iostreams::stream_buffer<sample::ftc_sink>
                write_streambuf (f.release ());
            std::ostream out (&write_streambuf);
            
            // overwrite content in remote file
            int integer = 5;
            out << integer;
        }
    }
    catch(std::exception& e)
    {
        std::cerr << "A exception: " << e.what () << " with type " << typeid(e).name () << std::endl;
    }
}
