/*
** IMetaInterfaceImpl.h
*/

#ifndef IMETAINTERFACEIMPL_H_
#define IMETAINTERFACEIMPL_H_

#include <scs/private/config.h>
#include <scs/ComponentContext.h>

#ifndef SCS_ORBIX
#  include <CORBA.h>
#  include <stubs/scs.h>
#else
#  include <cstdio> // Orbix uses EOF without including this header
#  include <stubs/orbix/scsS.hh>
#  include <orbix/corba.hh>
#endif

#include <map>

namespace scs {
  namespace core {
    //! Implementacao do servant da interface scs.core.IMetaInterface
    class SCS_DECL IMetaInterfaceImpl : virtual public POA_scs::core::IMetaInterface
                             , virtual public PortableServer::RefCountServantBase
    {
      ComponentContext* component;
    public:
      /**
       * \brief Construtor
       *
       * \param component Referencia para uma instancia de ComponentContext
       */
      IMetaInterfaceImpl(ComponentContext& component);
      //! Destrutor
      ~IMetaInterfaceImpl();

      /**
       * \brief Retorna as descricoes de todas as facetas do componente
       *
       * Essa função possui complexidade O(n), aonde n e a quantidade de facetas
       * do componente
       */
      FacetDescriptions* getFacets() 
        throw(CORBA::SystemException);
      /**
       * \brief Retorna as descricoes das facetas com nomes especificos do componente
       *
       * \param names Lista de nomes das facetas
       *
       * Essa funcao possui complexidade O(log m*n), aonde m e a quantidade de 
       * de facetas no componente e n e o tamanho da lista de nomes passada
       * como argumento.
       */
      FacetDescriptions* getFacetsByName(const NameList&  names)
        throw(
          CORBA::SystemException, 
          InvalidName);

      //! Retorna as descricoes de todos os receptaculos do componente
      ReceptacleDescriptions* getReceptacles()
        throw(CORBA::SystemException);

      /**
       * \brief Retorna as descricoes dos receptaculos com nomes especificos do componente
       *
       * \param names Lista de nomes dos receptaculos
       */
      ReceptacleDescriptions* getReceptaclesByName(const NameList &  names)
        throw(
          CORBA::SystemException, 
          InvalidName);
    };
  }
}

#endif 

