/*
** scs/core/IComponent.h
*/

#ifndef ICOMPONENTIMPL_H_
#define ICOMPONENTIMPL_H_

#include <scs/private/config.h>
#include <scs/ComponentContext.h>

#ifndef SCS_ORBIX
#  include <CORBA.h>
#  include <stubs/scs.h>
#else
#  include <cstdio> // Orbix uses EOF without including this header
#  include <stubs/orbix/scsS.hh>
#  include <orbix/corba.hh>
#endif

#include <map>

namespace scs {
  namespace core {
    class ComponentContext;

    //! \brief Implementacao de servant da interface scs.core.IComponent.
    class SCS_DECL IComponentImpl : public virtual POA_scs::core::IComponent 
                         , public virtual PortableServer::RefCountServantBase
    {
      private:
        ComponentContext* component;
      public:
        /**
         * \brief Construtor
         *
         * \param component Referencia para uma instancia de ComponentContext
         */
        IComponentImpl(ComponentContext& component);
        //! Destrutor
        ~IComponentImpl();

        /**
         * \brief Função para ativar o componente
         *
         * Essa função é vazia nessa implementação
         */
        void startup() 
          throw(
            CORBA::SystemException,
            scs::core::StartupFailed);
        /**
         * \brief Função para desativar o componente
         *
         * Essa função é vazia nessa implementação
         */
        void shutdown() 
          throw(
            CORBA::SystemException,
            scs::core::ShutdownFailed);
        /**
         * \brief Retorna faceta
         *
         * \param facet_interface Interface da faceta
         *
         * Essa função retorna a faceta de interface facet_interface de
         * ComponentContext. Essa função serializa o acesso ao estado
         * das facets no ComponentContext com ComponentContext::facet_lock.
         */
        CORBA::Object_ptr getFacet(const char* facet_interface) 
          throw(
            CORBA::SystemException);
        /**
         * \brief Retorna faceta
         *
         * \param facet Nome da faceta
         *
         * Essa função retorna a faceta com nome facet de
         * ComponentContext. Essa função serializa o acesso ao estado
         * das facets no ComponentContext com
         * ComponentContext::facet_lock.
         */
        CORBA::Object_ptr getFacetByName(const char* facet) 
          throw(
            CORBA::SystemException);
        //! Retorna o identificador do componente
        ComponentId* getComponentId() 
          throw(CORBA::SystemException);
      };
  }
}

#endif

