// -*- coding: iso-8859-1 -*-
/**
* \mainpage API - SDK Openbus C++
* \file openbus/ORBInitializer.h
*/

#ifndef TECGRAF_SDK_OPENBUS_ORB_INITIALIZER_H_
#define TECGRAF_SDK_OPENBUS_ORB_INITIALIZER_H_

#include "openbus/decl.hpp"

#include <CORBA.h>

/**
* \brief openbus
*/
namespace openbus 
{
/**
 * \brief Inicializa um ORB utilizado exclusivamente para chamadas
 *        atravs de barramentos OpenBus.
 *
 * Inicializa um ORB utilizado exclusivamente para chamadas atravs de
 * barramentos OpenBus, ou seja, esse ORB no pode ser utilizado para
 * fazer chamadas CORBA ordinrias sem o controle de acesso do OpenBus
 * que permite identificao da origem das chamadas. Esse controle de
 * acesso  feito atravs conexes que so obtidas e manipuladas
 * atravs de um OpenBusContext. Cada ORB possui um OpenBusContext
 * associado, que pode ser obitido atravs do comando:
 * CORBA::ORB::resolve_initial_reference("OpenBusContext")
 *
 * O ORB  inicializado da mesma forma feita pela operao
 * 'CORBA::ORB_init' definida pelo padro CORBA. Em particular,
 * algumas implementaes de CORBA no permitem inicializao de
 * mltiplos ORBs num mesmo processo, como por exemplo o ORB Mico
 * 2.3.13.
 * 
 * Chamadas realizadas e recebidas atravs deste ORB so interceptadas
 * pela biblioteca de acesso do OpenBus e podem lanar excees de
 * sistema de CORBA definidas pelo OpenBus. A seguir so apresentadas
 * essas excees: 
 *  - CORBA::NO_PERMISSION{NoLogin}: Nenhuma conexo
 *    "Requester" com login vlido est associada ao contexto atual, ou
 *     seja, a conexo "Requester" corrente est desautenticada.  
 *  - CORBA::NO_PERMISSION{InvalidChain}: A cadeia de chamadas associada
 *     pao contexto atual no  compatvel com o login da conexo
 *     "Requester" desse mesmo contexto. Isso ocorre pois no  possvel
 *     fazer chamadas dentro de uma cadeia recebida por uma conexo com um
 *     login diferente.  - CORBA::NO_PERMISSION{UnknownBus}: O ORB remoto
 *     que recebeu a chamada indicou que no possui uma conexo com login
 *     vlido no barramento atravs do qual a chamada foi realizada,
 *     portanto no  capaz de validar a chamada para que esta seja
 *     processada.  
 *  - CORBA::NO_PERMISSION{UnverifiedLogin}: O ORB remoto
 *    que recebeu a chamada indicou que no  capaz de validar a chamada
 *    para que esta seja processada. Isso indica que o lado remoto tem
 *    problemas de acesso aos servios ncleo do barramento.  
 *  - CORBA::NO_PERMISSION{InvalidRemote}: O ORB remoto que recebeu a
 *    chamada no est se comportando de acordo com o protocolo OpenBus
 *    2.0, o que indica que est mal implementado e tipicamente
 *    representa um bug no servidor sendo chamado ou um erro de
 *    implantao do barramento.
 * 
 * @return O ORB inicializado, similar  operao 'CORBA::ORB_init'
 * definida pelo padro CORBA.
 *
 * Ateno: O Mico 2.3.13 no permite a inicializao de mais de um
 *          ORB. Aps uma primeira chamada bem sucedida de
 *          ORBInitializer(), todas as chamadas consecutivas
 *          retornaro o mesmo ORB que foi criado na primeira chamada.
 * 
 * @param[in] argc Nmero de parmetros usados na inicializao do ORB.
 * @param[in] argv Parmetros usados na inicializao do ORB.
 * 
 * @throw CORBA::Exception
 *
 * @return O ORB inicializado.
 */
  OPENBUS_SDK_DECL CORBA::ORB *ORBInitializer(int &argc, char **argv);
}

#endif
