/**
* \file ostream_output.h
*/

#ifndef LOGGER_OUTPUT_STREAMBUF_OUTPUT_H
#define LOGGER_OUTPUT_STREAMBUF_OUTPUT_H

#include <log/logger.h>
#include <streambuf>
#include <ostream>

namespace logger { namespace output {

struct streambuf_output : output_base
{
  streambuf_output(std::streambuf& streambuf)
    : streambuf(streambuf) {}

  void print(std::string const& string) const
  {
    streambuf.sputn(string.c_str(), string.size());
    streambuf.pubsync();
  }
  streambuf_output* clone() const { return new streambuf_output(*this); }

  std::streambuf& streambuf;
};

inline std::auto_ptr<output_base> make_streambuf_output(std::ostream& stream)
{
  std::auto_ptr<output_base> p(new streambuf_output(*stream.rdbuf()));
  return p;
}

inline std::auto_ptr<output_base> make_streambuf_output(std::streambuf& streambuf)
{
  std::auto_ptr<output_base> p(new streambuf_output(streambuf));
  return p;
}

} }

#endif
