/**
* \file file_output.h
*/

#ifndef LOGGER_OUTPUT_FILE_OUTPUT_H
#define LOGGER_OUTPUT_FILE_OUTPUT_H

#include <log/logger.h>
#include <log/output/streambuf_output.h>
#include <boost/utility/base_from_member.hpp>
#include <boost/shared_ptr.hpp>

#include <fstream>

namespace logger { namespace output {

struct file_output : private boost::base_from_member<boost::shared_ptr<std::ofstream> >
                   , streambuf_output
{
  typedef boost::base_from_member<boost::shared_ptr<std::ofstream> > ofstream_base;

  file_output(const char* filename, std::ios_base::openmode mode)
    : filename(filename), mode(mode)
    , ofstream_base(new std::ofstream(filename, mode)), streambuf_output(*member->rdbuf())
  {
  }
  file_output(file_output const& other)
    : filename(other.filename), mode(other.mode)
    , ofstream_base(new std::ofstream(other.filename.c_str(), other.mode)), streambuf_output(*member->rdbuf())
  {
  }
  file_output* clone() const { return new file_output(*this); }
  
  std::string filename;
  std::ios_base::openmode mode;
};

inline
std::auto_ptr<output_base> make_file_output(const char* filename, std::ios_base::openmode mode
                                            = std::ios_base::out | std::ios_base::trunc)
{
  std::auto_ptr<output_base> p(new file_output(filename, mode));
  return p;
}

} }

#endif
