/**
* \file space_identation.h
*/

#ifndef LOGGER_FORMATTER_SPACE_IDENTATION_H
#define LOGGER_FORMATTER_SPACE_IDENTATION_H

#include <log/logger.h>

namespace logger { namespace formatter {

struct space_identation : formatter_base
{
  space_identation(std::size_t spaces_per_identation, char c)
    : spaces_per_identation(spaces_per_identation), c(c)
  {}

  void format(logger const& l, level lev, scope_token const& token, std::string& string) const
  {
    std::size_t identation_level = l.identation_level(token);
    string.insert(string.begin(), identation_level*spaces_per_identation, c);
  }
  space_identation* clone() const { return new space_identation(*this); }

  std::size_t spaces_per_identation;
  char c;
};

std::auto_ptr<formatter_base> make_space_identation(std::size_t spaces_per_identation = 2, char c = ' ')
{
  std::auto_ptr<formatter_base> p(new space_identation(spaces_per_identation, c));
  return p;
}

} }

#endif

