/**
* \file print_level.h
*/

#ifndef LOGGER_FORMATTER_PRINT_LEVEL_H
#define LOGGER_FORMATTER_PRINT_LEVEL_H

#include <log/logger.h>

#include <memory>

namespace logger { namespace formatter {

struct print_level : formatter_base
{
  void format(logger const& l, level lev, scope_token const& token, std::string& string) const
  {
    const char* level_string[] =
    {
      0, "ERROR   - ", "WARNING - ", "INFO    - ", "DEBUG   - "
    };
    assert(lev > 0 && lev <= debug_level);

    string.insert(0u, level_string[lev]);
  }
  print_level* clone() const { return new print_level(*this); }
};

std::auto_ptr<formatter_base> make_print_level()
{
  std::auto_ptr<formatter_base> p(new print_level);
  return p;
}

} }

#endif
