/**
* \file add_breakline.h
*/

#ifndef LOGGER_FORMATTER_ADD_BREAKLINE_H
#define LOGGER_FORMATTER_ADD_BREAKLINE_H

#include <log/logger.h>

#include <memory>

namespace logger { namespace formatter {

struct add_breakline : formatter_base
{
  add_breakline(const char* breakline)
    : breakline(breakline)
  {}

  void format(logger const& l, level lev, scope_token const& token, std::string& string) const
  {
    string.insert(string.size(), breakline);
  }
  add_breakline* clone() const { return new add_breakline(*this); }

  const char* breakline;
};

std::auto_ptr<formatter_base> make_add_breakline(const char* breakline
#ifdef _WINDOWS
                                                 = "\r\n"
#else
                                                 = "\n"
#endif
                                                 )
{
  std::auto_ptr<formatter_base> p(new add_breakline(breakline));
  return p;
}

} }

#endif
