// -*- coding: iso-8859-1-unix -*-
#ifndef STATES_V1_2_READSTATE_V1_04_01_H_
#define STATES_V1_2_READSTATE_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include "ftc/states/State.h"

namespace tecgraf { namespace ftc { namespace v1_04_01 { namespace states { namespace v1_2 {

  class ReadState : public State
  {
  public:
    ReadState();
    virtual ~ReadState();

    virtual bool do_read(FTCSession& session, Reader& input);
    virtual bool do_write(FTCSession& session, Writer& output);
  private:
    void create_chunk_header(FTCSession& session, Writer& output, IDataChannel* data_channel);
    uint64_t m_position;
    uint64_t m_count;
    uint64_t m_bytes_sent;
    uint64_t m_current_chunk_size;
    uint64_t m_chunk_bytes_sent;
    int64_t  m_remaining;
    bool m_read_uses_transfer_to;
    enum InternalState {
      /// O estado inicial.
      INITIAL,
      /// Estado que indica que a posio a partir da qual os dados sero lidos j
      /// foi lida.
      POSITION_READ,
      /// Estado que indica que a quantidade de bytes que sero lidos j foi lida.
      BYTE_COUNT_READ,
      /// Estado que indica que o cabealho de resposta ja foi montado.
      CHUNK_HEADER_WRITTEN,
      /// Estado que indica que o cabealho de resposta ao comando ja foi enviado.
      CHUNK_HEADER_SENT,
      /// Estado que indica que todos os bytes solicitados j foram enviados.
      BYTES_SENT,
      /// Estado que indica a transferncia de dados
      TRANSFERING
    } m_current_state;
  };

}}}}}

#endif

