// -*- coding: iso-8859-1-unix -*-
#ifndef STATES_V1_2_OPENSTATE_V1_04_01_H_
#define STATES_V1_2_OPENSTATE_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include "ftc/states/State.h"

namespace tecgraf { namespace ftc { namespace v1_04_01 { namespace states { namespace v1_2 {

  class OpenState : public State
  {
  public:
    explicit OpenState(bool read_only);
    virtual ~OpenState();

    virtual bool do_read(FTCSession& session, Reader& input);
    virtual bool do_write(FTCSession& session, Writer& output);
  private:
    bool m_read_only;
    uint8_t m_data_id_size;
    std::vector<uint8_t> m_data_id;
    enum InternalState {
      /// O estado inicial.
      INITIAL,
      /// Estado que indica que o tamanho do identificador do arquivo j foi recebido.
      IDENTIFIER_SIZE_RECEIVED,
      /// Estado que indica que o identificador do arquivo j foi recebido.
      IDENTIFIER_RECEIVED,
      /// O estado inicial.
      FILE_OPEN_RESULT,
      /// Estado que a mensagem de retorno ja foi escrita no buffer.
      RESULT_MESSAGE_WRITTEN,
      /// Estado que indica que o cdigo de erro j foi enviado.
      RESULT_MESSAGE_SENT
    } m_current_state;
  };

}}}}}

#endif

