// -*- coding: iso-8859-1-unix -*-
#ifndef STATES_V1_1_WRITESTATE_V1_04_01_H_
#define STATES_V1_1_WRITESTATE_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include "ftc/states/State.h"

namespace tecgraf { namespace ftc { namespace v1_04_01 { namespace states { namespace v1_1 {

  class WriteState : public State
  {
  public:
    WriteState();
    virtual ~WriteState();

    virtual bool do_read(FTCSession& session, Reader& input);
    virtual bool do_write(FTCSession& session, Writer& output);
  private:
    enum InternalState {
      /// O estado inicial.
      INITIAL,
      /// Estado que indica que a posio a partir da qual os dados sero escritos
      /// j foi lida.
      POSITION_READ,
      /// Estado que indica que a quantidade de bytes que sero escritos j foi lida.
      BYTE_COUNT_READ,
      /// Estado que indica que todos os bytes solicitados j foram recebidos.
      BYTES_RECEIVED,
      /// Estado que a mensagem de retorno ja foi escrita no buffer.
      RESULT_MESSAGE_WRITTEN,
      /// Estado que indica que o cdigo de erro j foi enviado.
      RESULT_MESSAGE_SENT,
      /// Estado que indica a transferncia de dados
      TRANSFERING
    } m_current_state;

    uint64_t m_position;
    uint64_t m_count;
    uint64_t m_bytes_received;
    bool m_write_use_transfer_from;
  };

}}}}}

#endif

