// -*- coding: iso-8859-1-unix -*-
#ifndef STATES_STATE_V1_04_01_H_
#define STATES_STATE_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include "ftc/ResultMessage.h"
#include "ftc/Writer.h"
#include "ftc/Reader.h"

#include <boost/cstdint.hpp>
#include <boost/system/error_code.hpp>

namespace tecgraf { namespace ftc { namespace v1_04_01 { 
  
  class FTCSession;
  class IDataChannel;

namespace states {
  
  class State
  {
  public:
    State();
    virtual ~State();

    bool want_read() const
    {
      return !writing;
    };

    bool want_write() const
    {
      return writing;
    };

    virtual bool do_read(FTCSession& session, Reader& input) = 0;
    virtual bool do_write(FTCSession& session, Writer& output) = 0;
  protected:
    ResultMessage result;
    bool writing;
  };

}}}}

#endif

