// -*- coding: iso-8859-1-unix -*-
#ifndef DETAIL_ENDIAN_V1_04_01_H_
#define DETAIL_ENDIAN_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
#pragma once
#endif

#include <boost/cstdint.hpp>

// from boost sandbox - endian2

namespace tecgraf { namespace ftc { namespace v1_04_01 { namespace endian
{
  // reverse byte order (i.e. endianness)
  inline int16_t  reorder(int16_t x);
  inline int32_t  reorder(int32_t x);
  inline int64_t  reorder(int64_t x);
  inline uint16_t reorder(uint16_t x);
  inline uint32_t reorder(uint32_t x);
  inline uint64_t reorder(uint64_t x);

  template <typename T>
  const T big(const T& x);

  const int8_t big(const int8_t& x); 
  const int16_t big(const int16_t& x);
  const int32_t big(const int32_t& x);
  const int64_t big(const int64_t& x);
  const uint8_t big(const uint8_t& x); 
  const uint16_t big(const uint16_t& x);
  const uint32_t big(const uint32_t& x);
  const uint64_t big(const uint64_t& x);

  inline int16_t reorder(int16_t x)
  {
    return (static_cast<uint16_t>(x) << 8)
      | (static_cast<uint16_t>(x) >> 8);
  }

  inline int32_t reorder(int32_t x)
  {
    uint32_t step16;
    step16 = static_cast<uint32_t>(x) << 16 | static_cast<uint32_t>(x) >> 16;
    return
        ((static_cast<uint32_t>(step16) << 8) & 0xff00ff00)
      | ((static_cast<uint32_t>(step16) >> 8) & 0x00ff00ff);
  }

  inline int64_t reorder(int64_t x)
  {
    uint64_t step32, step16;
    step32 = static_cast<uint64_t>(x) << 32 | static_cast<uint64_t>(x) >> 32;
    step16 = (step32 & 0x0000FFFF0000FFFFLL) << 16
           | (step32 & 0xFFFF0000FFFF0000LL) >> 16;
    return static_cast<int64_t>((step16 & 0x00FF00FF00FF00FFLL) << 8
           | (step16 & 0xFF00FF00FF00FF00LL) >> 8);
  }

  inline uint16_t reorder(uint16_t x)
  {
    return (x << 8)
      | (x >> 8);
  }

  inline uint32_t reorder(uint32_t x)
  {
    uint32_t step16;
    step16 = x << 16 | x >> 16;
    return
        ((step16 << 8) & 0xff00ff00)
      | ((step16 >> 8) & 0x00ff00ff);
  }

  inline uint64_t reorder(uint64_t x)
  {
    uint64_t step32, step16;
    step32 = x << 32 | x >> 32;
    step16 = (step32 & 0x0000FFFF0000FFFFLL) << 16
           | (step32 & 0xFFFF0000FFFF0000LL) >> 16;
    return (step16 & 0x00FF00FF00FF00FFLL) << 8
           | (step16 & 0xFF00FF00FF00FF00LL) >> 8;
  }

}}}}

#endif // DETAIL_ENDIAN_V1_04_01_H_
