// -*- coding: iso-8859-1-unix -*-
#ifndef WRITER_V1_04_01_H_
#define WRITER_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include "ftc/BaseReaderWriter.h"

namespace tecgraf { namespace ftc { namespace v1_04_01 {  

  class FTCSession;
  class Buffer;
  class ResultMessage;
  class IDataChannel;

  class Writer : public BaseReaderWriter
  {
  public:
    Writer(FTCSession& session, Buffer& buffer, boost::system::error_code& ec);
    ~Writer();

    std::size_t send_some();
    std::size_t send_some(Buffer& buffer);
    bool send_all();

    void write_result(const ResultMessage& result);
    
    void write_result_short(const ResultMessage& result, uint16_t tail);
    void write_result_int(const ResultMessage& result, uint32_t tail);
    void write_result_long(const ResultMessage& result, uint64_t tail);

    void write_long(const uint64_t value);

    void prepare_transfer_to(uint64_t& initial_position, const uint64_t& bytes_sent, IDataChannel* source, const bool use_transfer_to);
    void begin_transfer_to();
    int64_t transfer_to(const uint64_t& initial_position, const uint64_t& bytes_sent, IDataChannel* source, const uint64_t& remaining_bytes, const bool use_transfer_to);
    void end_transfer_to();
  };

}}}

#endif

