// -*- coding: iso-8859-1-unix -*-
#ifndef STREAMDATACHANNEL_V1_04_01_H_
#define STREAMDATACHANNEL_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include "ftc/IDataChannel.h"
#include "ftc/FTCException.h"

#include <string>
#include <boost/cstdint.hpp>

namespace tecgraf { namespace ftc { namespace v1_04_01 
{
  static std::string UNSUPPORTED_OPERATION_MSG("Operacao nao suportada pelo canal");

  struct StreamDataChannel : public IDataChannel
  {
    /// @copydoc IDataChannel::supportedOperations()
    virtual uint16_t supportedOperations() const
    { return (Operations::read | Operations::write); }

    virtual int64_t remaining() const
    { throw UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG, "remaining"); }
    virtual uint64_t skip(const uint64_t count)
    { throw UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG, "skip"); }

    /// @copydoc IDataChannel::size()
    virtual uint64_t size() const
    { throw UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG, "getSize"); }
    /// @copydoc IDataChannel::size(const uint64_t)
    virtual void size(const uint64_t size)
    { throw UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG, "setSize"); }

    /// @copydoc IDataChannel::size()
    virtual uint64_t position() const
    { throw UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG, "getPosition"); }
    /// @copydoc IDataChannel::size(const uint64_t)
    virtual void position(const uint64_t position)
    { throw UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG, "setPosition"); }

    /// @copydoc IDataChannel::read(Buffer&)
    virtual int64_t read(Buffer& dest)
    { throw UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG, "read"); }
    /// @copydoc IDataChannel::read(Buffer&, const uint64_t)
    virtual int64_t read(Buffer& dest, const uint64_t remotePosition)
    { throw UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG, "read"); }

    /// @copydoc IDataChannel::write(Buffer&)
    virtual int64_t write(Buffer& source)
    { throw UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG, "write"); }
    /// @copydoc IDataChannel::write(Buffer&, const uint64_t)
    virtual int64_t write(Buffer& source, const uint64_t remotePosition)
    { throw UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG, "write"); }

    /// @copydoc IDataChannel::transferTo()
    virtual int64_t transferTo(const uint64_t remotePosition, const uint64_t nbytes, IDataChannel& dest)
    { throw UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG, "transferTo"); }
    /// @copydoc IDataChannel::transferFrom()
    virtual int64_t transferFrom(IDataChannel& source, const uint64_t remotePosition, const uint64_t nbytes)
    { throw UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG, "transferFrom"); }
  };

} } }

#endif

