// -*- coding: iso-8859-1-unix -*-
#ifndef SERVEREXCEPTIONHANDLER_V1_04_01_H_
#define SERVEREXCEPTIONHANDLER_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include <string>
#include <stdexcept>

namespace tecgraf { namespace ftc { namespace v1_04_01 {

  /**
  * @brief Define as operaes de um objeto que recebe as excees do servidor.
  *
  * Toda exceo lanada durante e execuo do servidor  capturada e informada para uma implementao
  * dessa classe.  possvel assim o tratamento mais adequado da exceo ou simplesmente o log da mesma.
  *
  * @author Tecgraf/PUC-Rio
  */
  class ServerExceptionHandler {
  public:

    /**
    * @brief Construtor
    */
    ServerExceptionHandler() {};

    /**
    * @brief Destrutor
    */
    virtual ~ServerExceptionHandler() {};

    /**
    * @brief Chamado quando uma exceo  lanada no servidor.
    * @param msg Mensagem da exceo quando no especfica - <c>catch(...)</c>.
    */
    virtual void exception_raised(const std::string& msg) = 0;

    /**
    * @brief Chamado quando uma exceo  lanada no servidor.
    * @param msg Mensagem da exceo quando no especfica - <c>catch(...)</c>.
    * @param data_id Referncia ao identificador do canal de dados
    */
    virtual void exception_raised(const std::string& msg, const std::string& data_id) = 0;

    /**
    * @brief Chamado quando uma exceo  lanada no servidor.
    * @param e Objeto da exceo.
    */
    virtual void exception_raised(const std::exception& e) = 0;

    /**
    * @brief Chamado quando uma exceo  lanada no servidor.
    * @param e Objeto da exceo.
    * @param data_id Referncia ao identificador do canal de dados
    */
    virtual void exception_raised(const std::exception& e, const std::string& data_id) = 0;
  };

}}}

#endif

