// -*- coding: iso-8859-1-unix -*-
#ifndef READER_V1_04_01_H_
#define READER_V1_04_01_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include "ftc/BaseReaderWriter.h"

#include <vector>
#include <boost/cstdint.hpp>

namespace tecgraf { namespace ftc { namespace v1_04_01 {  

  class FTCSession;
  class Buffer;
  class IDataChannel;

  class Reader : public BaseReaderWriter
  {
  public:
    Reader(FTCSession& session, Buffer& buffer, boost::system::error_code& ec);
    ~Reader();

    std::size_t recv_some();
    std::size_t recv_some(std::size_t limit);
    std::size_t recv_some(Buffer& dest);
    bool recv_all(std::size_t limit);

    void read(std::vector<uint8_t>& key, std::size_t size);

    uint8_t peek_byte();
    uint8_t read_byte();
    uint16_t read_short();
    uint32_t read_int();
    uint64_t read_long();
    void read_bytes(char* dest, std::size_t size);

    void prepare_transfer_from(uint64_t& initial_position, const uint64_t& bytes_sent, IDataChannel* source, const bool use_transfer_to);
    void begin_transfer_from();
    int64_t transfer_from(const uint64_t& initial_position, const uint64_t& bytes_received, IDataChannel* dest, const uint64_t& remaining_bytes, const bool use_transfer_from);
    void end_transfer_from();
  };

}}}

#endif

